/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.resolution;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.element.IResolutionMatchingResult;
import com.hello2morrow.sonargraph.core.model.element.IssueType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class Resolution
extends NamedElementContainer
implements IResolution {
    private final ArrayList<IIssue> m_issues = new ArrayList();
    private final Date m_date;
    private String m_description;
    private IssueType m_issueType;

    protected Resolution(NamedElement parent, Date date, String description) {
        super(parent);
        assert (date != null) : "Parameter 'date' of method 'Resolution' must not be null";
        this.m_date = date;
        this.m_description = description == null ? "" : description.intern();
    }

    @Override
    public final Language getLanguage() {
        return null;
    }

    public abstract ResolutionKind getKind();

    @Override
    public boolean isBasedOnGeneratedIssue() {
        return false;
    }

    public final IssueType getIssueType() {
        assert (this.m_issueType != null) : "'m_issueType' of method 'getIssueType' must not be null";
        return this.m_issueType;
    }

    @Override
    public final void addChild(NamedElement child) {
        if (child instanceof IssueType) {
            this.m_issueType = (IssueType)child;
        }
        super.addChild(child);
    }

    @Override
    public final void removeChild(NamedElement child) {
        super.removeChild(child);
        if (child instanceof IssueType) {
            this.m_issueType = null;
        }
    }

    public String getFullyQualifiedNameToBeMatched(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getFullyQualifiedNameToBeMatched' must not be null";
        return element.getOriginalFullyQualifiedName();
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        return Integer.toString(this.hashCode());
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    public final Date getDate() {
        return this.m_date;
    }

    @Property
    public String created() {
        return StringUtility.getDateTimeStringFromLocale((Date)this.m_date);
    }

    @Override
    @Property
    public Priority getPriority() {
        return Priority.NONE;
    }

    @Override
    @Property(isAlwaysShown=true)
    public String getAssignee() {
        return "";
    }

    @Override
    @Property(isAlwaysShown=true)
    public final String getDescription() {
        return this.m_description;
    }

    public final void setDescription(String description) {
        this.m_description = description == null ? "" : description;
    }

    @Override
    public void finishModification() {
        this.m_issues.trimToSize();
        super.finishModification();
    }

    public final List<IIssue> getAssociatedIssues() {
        return Collections.unmodifiableList(this.m_issues);
    }

    @Override
    public final void addAssociatedIssue(IIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'addAssociatedIssue' must not be null";
        this.m_issues.add(issue);
    }

    public final int getMatchingElementsCount() {
        return this.m_issues.size();
    }

    public void reset(IIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'reset' must not be null";
        assert (this.m_issues.contains(issue)) : "Not found: " + issue;
        issue.reset();
        this.m_issues.remove(issue);
        if (this.m_issues.isEmpty()) {
            this.resetResolutionMatchingResults();
        }
    }

    public List<IIssue> reset() {
        this.resetResolutionMatchingResults();
        if (!this.m_issues.isEmpty()) {
            ArrayList<IIssue> issues = new ArrayList<IIssue>(this.m_issues);
            for (IIssue nextIssue : this.m_issues) {
                nextIssue.reset();
            }
            this.m_issues.clear();
            return issues;
        }
        return Collections.emptyList();
    }

    private void resetResolutionMatchingResults() {
        this.getChildren(IResolutionMatchingResult.class).forEach(result -> result.reset());
    }

    @Property
    public String getResolutionMatchingConfidence() {
        List<IResolutionMatchingResult> matchingResults = this.getChildren(IResolutionMatchingResult.class);
        if (matchingResults.isEmpty()) {
            return null;
        }
        double highest = -1.0;
        double lowest = 1.0;
        for (IResolutionMatchingResult next : matchingResults) {
            double confidence = next.getResolutionMatchingConfidence();
            if (Double.compare(confidence, highest) > 0) {
                highest = confidence;
            }
            if (Double.compare(confidence, lowest) >= 0) continue;
            lowest = confidence;
        }
        if (Double.compare(highest, 0.0) < 0) {
            return null;
        }
        if (matchingResults.size() == 1 || Double.compare(lowest, highest) == 0) {
            return Double.toString(NumberUtility.round((double)highest));
        }
        StringBuilder result = new StringBuilder();
        result.append(Double.toString(NumberUtility.round((double)lowest))).append(" - ").append(Double.toString(NumberUtility.round((double)highest)));
        return result.toString();
    }

    public Double getResolutionMatchingConfidenceAsDouble() {
        List<IResolutionMatchingResult> results = this.getChildren(IResolutionMatchingResult.class);
        if (results.isEmpty()) {
            return null;
        }
        double sum = 0.0;
        int i2 = 0;
        while (i2 < results.size()) {
            sum += results.get(i2).getResolutionMatchingConfidence();
            ++i2;
        }
        return sum / (double)results.size();
    }

    @Override
    public String getInformation() {
        IssueType type = this.getUniqueChild(IssueType.class);
        return type == null ? "" : type.getInformation();
    }
}

