/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.resolution;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.IIssueAffectedElementType;
import com.hello2morrow.sonargraph.core.model.element.IIssueFilter;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import gnu.trove.set.hash.THashSet;
import java.util.Set;
import java.util.function.Predicate;

public final class IssueFilter
implements IIssueFilter,
Cloneable {
    public static final Class<? extends IStandardEnumeration> ISSUE_SEVERITY = Severity.class;
    public static final Class<? extends IStandardEnumeration> ISSUE_ID = IIssueId.class;
    public static final Class<? extends IStandardEnumeration> ISSUE_PROVIDER = IProviderId.class;
    public static final Class<? extends IStandardEnumeration> ISSUE_CATEGORY = IssueCategory.class;
    public static final Class<? extends IStandardEnumeration> ISSUE_TYPE = IIssueAffectedElementType.class;
    public static final Class<? extends IStandardEnumeration> RESOLUTION_MODE = ResolutionMode.class;
    private Set<Severity> m_severities;
    private Set<IIssueId> m_ids;
    private Set<IProviderId> m_providers;
    private Set<IssueCategory> m_categories;
    private Set<IIssueAffectedElementType> m_issueTypes;
    private Set<ResolutionMode> m_resolutionModes;
    private boolean m_hasFiltered = false;
    private Set<Predicate<Issue>> m_ignoreConditions;

    @SafeVarargs
    public <T extends IStandardEnumeration> IssueFilter(T ... filter) {
        assert (filter != null) : "Parameter 'filter' of method 'IssueFilter' must not be null";
        T[] TArray = filter;
        int n2 = filter.length;
        int n3 = 0;
        while (n3 < n2) {
            T next = TArray[n3];
            this.add(next);
            ++n3;
        }
    }

    public IssueFilter(IssueFilter filterToCopy) {
        assert (filterToCopy != null) : "Parameter 'filterToCopy' of method 'IssueFilter' must not be null";
        this.m_ignoreConditions = filterToCopy.m_ignoreConditions == null ? null : new THashSet(filterToCopy.m_ignoreConditions);
        this.m_severities = filterToCopy.m_severities == null ? null : new THashSet(filterToCopy.m_severities);
        this.m_ids = filterToCopy.m_ids == null ? null : new THashSet(filterToCopy.m_ids);
        this.m_providers = filterToCopy.m_providers == null ? null : new THashSet(filterToCopy.m_providers);
        this.m_categories = filterToCopy.m_categories == null ? null : new THashSet(filterToCopy.m_categories);
        this.m_issueTypes = filterToCopy.m_issueTypes == null ? null : new THashSet(filterToCopy.m_issueTypes);
        this.m_resolutionModes = filterToCopy.m_resolutionModes == null ? null : new THashSet(filterToCopy.m_resolutionModes);
    }

    public boolean isEmpty() {
        return this.m_severities == null && this.m_ids == null && this.m_providers == null && this.m_categories == null && this.m_issueTypes == null && this.m_resolutionModes == null;
    }

    public <T extends IStandardEnumeration> void add(T filter) {
        assert (filter != null) : "Parameter 'filter' of method 'add' must not be null";
        THashSet filters = this.getSetOfFilters(filter.getClass());
        if (filters == null) {
            filters = new THashSet(5);
        }
        filters.add(filter);
        this.refreshFilter((Class<? extends IStandardEnumeration>)filter.getClass(), (Set<T>)filters);
    }

    private <T extends IStandardEnumeration> void refreshFilter(Class<? extends IStandardEnumeration> filterClass, Set<T> filters) {
        if (ISSUE_SEVERITY.isAssignableFrom(filterClass)) {
            this.m_severities = filters;
        } else if (ISSUE_CATEGORY.isAssignableFrom(filterClass)) {
            this.m_categories = filters;
        } else if (ISSUE_PROVIDER.isAssignableFrom(filterClass)) {
            this.m_providers = filters;
        } else if (ISSUE_ID.isAssignableFrom(filterClass)) {
            this.m_ids = filters;
        } else if (ISSUE_TYPE.isAssignableFrom(filterClass)) {
            this.m_issueTypes = filters;
        } else if (RESOLUTION_MODE.isAssignableFrom(filterClass)) {
            this.m_resolutionModes = filters;
        } else assert (false) : "Unexpected class: " + filterClass.getName();
    }

    private boolean matches(IIssueId id) {
        assert (id != null) : "Parameter 'id' of method 'matchesId' must not be null";
        if (this.m_ids == null) {
            return true;
        }
        return this.m_ids.contains(id);
    }

    private boolean matches(Severity severity) {
        assert (severity != null) : "Parameter 'severity' of method 'matchesSeverity' must not be null";
        if (this.m_severities == null) {
            return true;
        }
        for (Severity nextSeverity : this.m_severities) {
            if (severity != nextSeverity) continue;
            return true;
        }
        return false;
    }

    private boolean matches(IProviderId provider) {
        assert (provider != null) : "Parameter 'provider' of method 'matches' must not be null";
        if (this.m_providers == null) {
            return true;
        }
        for (IProviderId nextProvider : this.m_providers) {
            if (!provider.equals(nextProvider)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(IssueCategory category) {
        assert (category != null) : "Parameter 'category' of method 'matches' must not be null";
        if (this.m_categories == null) {
            return true;
        }
        for (IssueCategory nextCategory : this.m_categories) {
            if (category != nextCategory) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Resolution resolution) {
        if (this.m_resolutionModes == null) {
            return true;
        }
        if (this.m_resolutionModes.contains((Object)ResolutionMode.NONE) && resolution == null) {
            return true;
        }
        if (this.m_resolutionModes.contains((Object)ResolutionMode.IGNORE) && resolution != null && resolution instanceof IgnoreDefinition) {
            return true;
        }
        return this.m_resolutionModes.contains((Object)ResolutionMode.TASK) && resolution != null && resolution instanceof TaskDefinition;
    }

    private <T extends Issue> boolean matches(Class<T> issueClass) {
        assert (issueClass != null) : "Parameter 'issueClass' of method 'matches' must not be null";
        if (this.m_issueTypes == null) {
            return true;
        }
        for (IIssueAffectedElementType issueType : this.m_issueTypes) {
            if (!issueType.matches(issueClass)) continue;
            return true;
        }
        return false;
    }

    public <T extends IStandardEnumeration> void initFilter(Class<T> filterClass) {
        if (ISSUE_SEVERITY.isAssignableFrom(filterClass)) {
            this.m_severities = new THashSet();
        } else if (ISSUE_CATEGORY.isAssignableFrom(filterClass)) {
            this.m_categories = new THashSet();
        } else if (ISSUE_PROVIDER.isAssignableFrom(filterClass)) {
            this.m_providers = new THashSet();
        } else if (ISSUE_ID.isAssignableFrom(filterClass)) {
            this.m_ids = new THashSet();
        } else if (ISSUE_TYPE.isAssignableFrom(filterClass)) {
            this.m_issueTypes = new THashSet();
        } else if (RESOLUTION_MODE.isAssignableFrom(filterClass)) {
            this.m_resolutionModes = new THashSet();
        } else assert (false) : "Unexpected class: " + filterClass.getName();
    }

    @Override
    public boolean accept(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'accept' must not be null";
        if (this.ignore(issue)) {
            return false;
        }
        boolean accepted = this.matches(issue.getId()) && this.matches(issue.getSeverity()) && this.matches(issue.getProvider()) && this.matches(issue.getId().getCategory()) && this.matches(issue.getResolution(Resolution.class)) && this.matches(issue.getClass());
        this.m_hasFiltered = this.m_hasFiltered || !accepted;
        return accepted;
    }

    public void addIgnore(Predicate<Issue> ignoreCondition) {
        assert (ignoreCondition != null) : "Parameter 'filterCondition' of method 'addIgnore' must not be null";
        if (this.m_ignoreConditions == null) {
            this.m_ignoreConditions = new THashSet(2);
        }
        this.m_ignoreConditions.add(ignoreCondition);
    }

    private boolean ignore(Issue element) {
        assert (element != null) : "Parameter 'element' of method 'ignore' must not be null";
        if (this.m_ignoreConditions == null) {
            return false;
        }
        for (Predicate<Issue> filterCondition : this.m_ignoreConditions) {
            if (!filterCondition.test(element)) continue;
            return true;
        }
        return false;
    }

    public void resetHasFiltered() {
        this.m_hasFiltered = false;
    }

    public boolean getHasFiltered() {
        return this.m_hasFiltered;
    }

    public <T extends IStandardEnumeration> boolean containsFilter(T filter) {
        Set<?> filters = this.getSetOfFilters(filter.getClass());
        if (filters != null) {
            return filters.contains(filter);
        }
        return false;
    }

    public void remove(IStandardEnumeration filter) {
        Set<?> filters = this.getSetOfFilters(filter.getClass());
        assert (filters != null) : "Parameter 'filters' of method 'remove' must not be null";
        filters.remove(filter);
    }

    private <T extends IStandardEnumeration> Set<T> getSetOfFilters(Class<T> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getSetOfFilters' must not be null";
        if (ISSUE_SEVERITY.isAssignableFrom(clazz)) {
            return this.m_severities;
        }
        if (ISSUE_CATEGORY.isAssignableFrom(clazz)) {
            return this.m_categories;
        }
        if (ISSUE_PROVIDER.isAssignableFrom(clazz)) {
            return this.m_providers;
        }
        if (ISSUE_ID.isAssignableFrom(clazz)) {
            return this.m_ids;
        }
        if (ISSUE_TYPE.isAssignableFrom(clazz)) {
            return this.m_issueTypes;
        }
        if (RESOLUTION_MODE.isAssignableFrom(clazz)) {
            return this.m_resolutionModes;
        }
        assert (false) : "Unexpected class: " + clazz.getName();
        return null;
    }

    public <T extends IStandardEnumeration> int getNumberOfFilters(Class<T> filterClass, Predicate<T> criteria) {
        assert (filterClass != null) : "Parameter 'filterClass' of method 'getNumberOfFilters' must not be null";
        assert (criteria != null) : "Parameter 'criteria' of method 'getNumberOfFilters' must not be null";
        Set<T> filters = this.getSetOfFilters(filterClass);
        if (filters == null) {
            return 0;
        }
        int count = 0;
        for (IStandardEnumeration filter : filters) {
            if (!criteria.test(filter)) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_resolutionModes);
        if (this.m_severities != null) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append(this.m_severities);
        }
        if (this.m_ids != null) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append(this.m_ids);
        }
        if (this.m_providers != null) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append(this.m_providers);
        }
        if (this.m_categories != null) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append(this.m_categories);
        }
        if (this.m_issueTypes != null) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append(this.m_issueTypes);
        }
        return builder.toString();
    }
}

