/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.representation;

import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.OnDemandCycleGroup;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureBaseElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureAssignmentElement;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedElements;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.IExternalContainer;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.ExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.InternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.PhysicalElementBasedLogicalRoot;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.NameMode;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;

public final class RepresentationUtility {
    public static final Predicate<ProgrammingElement> PE = pe -> !pe.isExcluded() && !pe.getRefactoringState().hasBeenDeleted();
    public static final Predicate<ParserDependency> PD = pd -> !pd.isExcluded() && !pd.getTo().isExcluded() && (pd.isCompileTimeDependency() || pd.isArchitectureRelevant()) && !pd.getRefactoringState().hasBeenDeleted();
    public static final NamedElement.IFilter REPRESENTATION_FILTER = new NamedElement.IFilter(){

        @Override
        public boolean accept(NamedElement namedElement) {
            if (!$assertionsDisabled && namedElement == null) {
                throw new AssertionError((Object)"Parameter 'namedElement' of method 'accept' must not be null");
            }
            return !namedElement.ignoreInModelRepresentation() && !namedElement.isExcluded();
        }
    };

    private RepresentationUtility() {
    }

    public static boolean isSuitableToExpandToComponentLevel(RepresentationEdge<?> edge) {
        assert (edge != null) : "Parameter 'edge' of method 'isSuitableToExpandToComponentLevel' must not be null";
        return RepresentationUtility.isEndpointSuitableForExpandToComponentLevel(edge.getFromEndPoint()) || RepresentationUtility.isEndpointSuitableForExpandToComponentLevel(edge.getToEndPoint());
    }

    public static boolean isEndpointSuitableForExpandToComponentLevel(NamedElement endPoint) {
        assert (endPoint != null) : "Parameter 'elementToExpand' of method 'isSuitableForExpandToComponentLevel' must not be null";
        if (endPoint instanceof IComponent) {
            return false;
        }
        if (endPoint instanceof AssignedElement) {
            return false;
        }
        if (endPoint instanceof ProgrammingElement) {
            return false;
        }
        if (endPoint instanceof LogicalProgrammingElement) {
            return false;
        }
        return endPoint.getParent(IComponent.class, new Class[0]) == null;
    }

    public static IDomainRoot.Domain defineDomain(Collection<? extends NamedElement> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'definedomain' must not be null";
        if (elements.isEmpty()) {
            return IDomainRoot.Domain.PHYSICAL;
        }
        int logicalNamespaceCount = 0;
        int systemScopeCount = 0;
        int moduleScopeCount = 0;
        for (Element element : elements) {
            NamedElement parent;
            if (element instanceof PhysicalElementBasedLogicalRoot) {
                ++logicalNamespaceCount;
                ++moduleScopeCount;
                continue;
            }
            if (element instanceof ExternalLogicalNamespaceRoot) {
                ++logicalNamespaceCount;
                parent = ((NamedElement)element).getParent(LogicalNamespaces.class, new Class[0]);
                assert (parent != null) : "'parent' of method 'definedomain' must not be null";
                if (parent instanceof LogicalSystemNamespaces) {
                    ++systemScopeCount;
                }
                if (!(parent instanceof LogicalModuleNamespaces)) continue;
                ++moduleScopeCount;
                continue;
            }
            if (element instanceof ModuleBasedLogicalNamespaceRoot || element instanceof LogicalModuleNamespace) {
                ++logicalNamespaceCount;
                ++moduleScopeCount;
                continue;
            }
            if (element instanceof InternalLogicalNamespaceRoot || element instanceof LogicalSystemNamespace) {
                ++logicalNamespaceCount;
                ++systemScopeCount;
                continue;
            }
            if (!(element instanceof LogicalProgrammingElement)) continue;
            ++logicalNamespaceCount;
            parent = ((LogicalProgrammingElement)element).getParent(LogicalNamespace.class, ParentMode.FIRST_PARENT);
            if (parent instanceof LogicalSystemNamespace) {
                ++systemScopeCount;
                continue;
            }
            if (!(parent instanceof LogicalModuleNamespace)) continue;
            ++moduleScopeCount;
        }
        if (logicalNamespaceCount == 0) {
            NamedElement namedElement = elements.iterator().next();
            ArchitectureFile arch = namedElement.getParent(ArchitectureFile.class, ParentMode.SELF_OR_FIRST_PARENT);
            if (arch != null) {
                return arch.getDomain();
            }
            return IDomainRoot.Domain.PHYSICAL;
        }
        if (logicalNamespaceCount == elements.size()) {
            if (systemScopeCount == elements.size()) {
                return IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE;
            }
            if (moduleScopeCount == elements.size()) {
                return IDomainRoot.Domain.LOGICAL_MODULE_SCOPE;
            }
        }
        return null;
    }

    public static LogicalNamespace getLogicalNamespaceForProgrammingElement(SoftwareSystem softwareSystem, ProgrammingElement programmingElement, IDomainRoot.Domain domain) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getLogicalNamespaceForProgrammingElement' must not be null";
        assert (programmingElement != null) : "Parameter 'namedElement' of method 'getLogicalNamespaceForProgrammingElement' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'getLogicalNamespaceForProgrammingElement' must not be null";
        LogicalNamespace.ISourceNamespace fragmentParent = programmingElement.getParent(LogicalNamespace.ISourceNamespace.class, new Class[0]);
        while (fragmentParent != null && !fragmentParent.contributesToLogicalNamespaces()) {
            fragmentParent = fragmentParent.getNamedElement().getParent(LogicalNamespace.ISourceNamespace.class, new Class[0]);
        }
        if (domain == IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE) {
            if (fragmentParent == null) {
                if (programmingElement.isExternal()) {
                    return softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class).getExternalGlobalLogicalNamespace(programmingElement.getLanguage());
                }
                return softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class).getInternalGlobalLogicalNamespace(programmingElement.getLanguage());
            }
            return fragmentParent.getSystemNamespace();
        }
        if (domain == IDomainRoot.Domain.LOGICAL_MODULE_SCOPE) {
            if (fragmentParent == null) {
                if (programmingElement.isExternal()) {
                    return softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class).getExternalGlobalLogicalNamespace(programmingElement.getLanguage(), programmingElement.getParent(IExternalContainer.class, new Class[0]));
                }
                Module parent = programmingElement.getParent(Module.class, new Class[0]);
                return softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class).getInternalGlobalLogicalNamespace(parent);
            }
            return fragmentParent.getModuleNamespace();
        }
        if (programmingElement.canBelongToNamespace()) assert (false) : "All programing elements should be contained in a logical namespace";
        return null;
    }

    public static NamedElement getRootElementForRepresentation(SoftwareSystem softwareSystem, Collection<NamedElement> mainPathNodes, IDomainRoot.Domain domain) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getRootElementForTree' must not be null";
        assert (mainPathNodes != null) : "Parameter 'mainPathNodes' of method 'getRootElementForRepresentation' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'getRootElementForTree' must not be null";
        NamedElement rootElement = null;
        if (domain == IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE) {
            rootElement = softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class);
        } else if (domain == IDomainRoot.Domain.LOGICAL_MODULE_SCOPE) {
            rootElement = softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class);
        } else if (domain == IDomainRoot.Domain.PHYSICAL) {
            rootElement = softwareSystem.getUniqueExistingChild(Workspace.class);
        } else if (domain == IDomainRoot.Domain.ARCHITECTURE_PHYSICAL || domain == IDomainRoot.Domain.ARCHITECTURE_LOGICAL) {
            Iterator<NamedElement> it = mainPathNodes.iterator();
            while (it.hasNext() && rootElement == null) {
                NamedElement sample = it.next();
                rootElement = sample.getParent(ArchitectureFile.class, ParentMode.SELF_OR_FIRST_PARENT);
            }
        }
        assert (rootElement != null) : "'elementForTree' of method 'getRootElementForTree' must not be null";
        return rootElement;
    }

    public static NameMode getNameMode(NamedElement nodeForName, PresentationMode presentationMode) {
        assert (nodeForName != null) : "Parameter 'nodeForName' of method 'getNameMode' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'getNameMode' must not be null";
        NameMode mode = NameMode.SHORT;
        if (nodeForName instanceof IRecursiveElement && !(nodeForName instanceof ProgrammingElement) && !(nodeForName instanceof LogicalProgrammingElement)) {
            if (presentationMode == PresentationMode.FLAT) {
                mode = NameMode.FULL;
            } else if (presentationMode == PresentationMode.MIXED) {
                mode = NameMode.MIXED;
            }
        }
        return mode;
    }

    private static boolean isSuitableForArchitectureBasedRepresentation(Element element) {
        assert (element != null) : "Parameter 'element' of method 'isSuitableForArchitectureExplorationTree' must not be null";
        if (element instanceof IArchitectureAssignmentElement || element instanceof Artifact || element instanceof UnassignedElements) {
            if (element instanceof Artifact && ((Artifact)element).getNumberOfAssignedElements() == 0) {
                return false;
            }
            if (element instanceof UnassignedElements && ((UnassignedElements)element).getNumberOfAssignedElements() == 0) {
                return false;
            }
            assert (element != null && element instanceof NamedElement) : "Unexpected class in method 'supportsShowInViewFor': " + element;
            NamedElement namedElement = (NamedElement)element;
            ArchitectureFile parentFile = namedElement.getParent(ArchitectureFile.class, ParentMode.FIRST_PARENT);
            if (parentFile != null && parentFile.isChecked() && namedElement.getParent(Interface.class, ParentMode.SELF_OR_FIRST_PARENT) == null && namedElement.getParent(Connector.class, ParentMode.SELF_OR_FIRST_PARENT) == null) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasValidChildrenForRepresentation(NamedElement namedElement, IDomainRoot.Domain domain) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'hasValidChildrenForRepresentation' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'hasValidChildrenForRepresentation' must not be null";
        RepresentationValidChildrenVisitor visitor = new RepresentationValidChildrenVisitor(namedElement, domain);
        namedElement.accept(visitor);
        return visitor.hasValidChildrenForRepresentation();
    }

    public static boolean isValidElementForRepresentation(NamedElement element, EndpointType endpointType) {
        IDomainRoot.Domain domain;
        assert (element != null) : "namedElement 'element' of method 'isValidElementForRepresentation' must not be null";
        if (!element.isValid() || element instanceof SoftwareSystem || element.getRefactoringState().hasBeenDeleted()) {
            return false;
        }
        if (element instanceof CycleGroup) {
            element = ((CycleGroup)element).getCyclicNamedElements().iterator().next();
        }
        if (element instanceof IDomainRoot) {
            domain = ((IDomainRoot)((Object)element)).getDomain();
        } else if (element instanceof LogicalSystemProgrammingElement || element instanceof LogicalSystemNamespace) {
            domain = IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE;
        } else if (element instanceof LogicalModuleProgrammingElement || element instanceof LogicalModuleNamespace || element instanceof PhysicalElementBasedLogicalRoot) {
            domain = IDomainRoot.Domain.LOGICAL_MODULE_SCOPE;
        } else if (element instanceof IArchitectureAssignmentElement || element instanceof IArchitectureElement || element instanceof UnassignedElements) {
            ArchitectureFile architectureFile = element.getParent(ArchitectureFile.class, new Class[0]);
            if (architectureFile == null) {
                return false;
            }
            domain = architectureFile.getDomain();
        } else {
            domain = IDomainRoot.Domain.PHYSICAL;
        }
        Predicate<NamedElement> instanceCheck = namedElement -> {
            if (namedElement.isExcluded()) {
                return false;
            }
            if (namedElement.ignoreInModelRepresentation()) {
                return false;
            }
            if (namedElement instanceof ProgrammingElement || namedElement instanceof LogicalProgrammingElement) {
                if (namedElement.getChildren().isEmpty()) {
                    return !namedElement.getRefactoringState().hasBeenDeleted();
                }
                return true;
            }
            if (domain == IDomainRoot.Domain.ARCHITECTURE_PHYSICAL || domain == IDomainRoot.Domain.ARCHITECTURE_LOGICAL) {
                if (!RepresentationUtility.isSuitableForArchitectureBasedRepresentation(namedElement)) {
                    return false;
                }
                if (namedElement instanceof AssignedElement) {
                    return true;
                }
            }
            return endpointType == null || endpointType != EndpointType.INCLUDE_DEPENDENCY ? RepresentationUtility.hasValidChildrenForRepresentation(namedElement, domain) : true;
        };
        if (element instanceof OnDemandCycleGroup) {
            for (NamedElement elementInCycle : ((OnDemandCycleGroup)element).getCyclicNamedElements()) {
                if (!instanceCheck.test(elementInCycle)) continue;
                return true;
            }
            return false;
        }
        return instanceCheck.test(element);
    }

    public static boolean isValidElementForRepresentation(NamedElement element) {
        return RepresentationUtility.isValidElementForRepresentation(element, null);
    }

    private static final class RepresentationValidChildrenVisitor
    extends NamedElementVisitor
    implements ArchitectureBaseElement.IVisitor,
    AssignedElement.IVisitor,
    LogicalProgrammingElement.IVisitor,
    ProgrammingElement.IVisitor {
        private final NamedElement m_elementForChildren;
        private final IDomainRoot.Domain m_domain;
        private boolean m_hasValidChildrenForRepresentation;

        RepresentationValidChildrenVisitor(NamedElement elementForChildren, IDomainRoot.Domain domain) {
            assert (domain != null) : "Parameter 'domain' of method 'RepresentationValidChildrenVisitor' must not be null";
            assert (elementForChildren != null) : "Parameter 'elementForChildren' of method 'RepresentationValidChildrenVisitor' must not be null";
            this.m_elementForChildren = elementForChildren;
            this.m_domain = domain;
        }

        @Override
        public boolean done() {
            return this.m_hasValidChildrenForRepresentation;
        }

        @Override
        public void visitChildrenOf(NamedElement element) {
            for (NamedElement namedElement : element.getAllChildren()) {
                namedElement.accept(this);
                if (this.done()) break;
            }
        }

        @Override
        public void visitArchitectureBaseElement(ArchitectureBaseElement element) {
            if (element.getAssignedElements().size() > 0) {
                this.m_hasValidChildrenForRepresentation = true;
            } else {
                element.getChildren(Artifact.class).forEach(a2 -> a2.accept(this));
            }
        }

        @Override
        public void visitProgrammingElement(ProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
            if (!(!element.isValid() || this.m_elementForChildren.equals(element) || this.m_domain != IDomainRoot.Domain.PHYSICAL || element.getRefactoringState().hasBeenDeleted() || element.isExcluded() || element.ignoreInModelRepresentation())) {
                this.m_hasValidChildrenForRepresentation = true;
            }
        }

        @Override
        public void visitAssignedElement(AssignedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitAssignedComponent' must not be null";
            if (element.isValid() && !this.m_elementForChildren.equals(element) && (this.m_domain == IDomainRoot.Domain.ARCHITECTURE_PHYSICAL || this.m_domain == IDomainRoot.Domain.ARCHITECTURE_LOGICAL)) {
                this.m_hasValidChildrenForRepresentation = true;
            }
        }

        @Override
        public void visitLogicalProgrammingElement(LogicalProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitLogicalProgrammingElement' must not be null";
            if (!(!element.isValid() || this.m_elementForChildren.equals(element) || this.m_domain != IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE && this.m_domain != IDomainRoot.Domain.LOGICAL_MODULE_SCOPE || element.getRefactoringState().hasBeenDeleted() || element.isExcluded())) {
                this.m_hasValidChildrenForRepresentation = true;
            }
        }

        public boolean hasValidChildrenForRepresentation() {
            return this.m_hasValidChildrenForRepresentation;
        }
    }
}

