/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.representation;

import com.hello2morrow.foundation.utilities.ShortBitFieldUtil;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingNode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.representation.NameMode;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepresentationNode
extends RepresentationElement
implements INode<NamedElement>,
IParserDependenciesProvidingNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepresentationNode.class);
    private final NamedElement m_namedElement;
    private ArrayList<RepresentationEdge<RepresentationNode>> m_edges;
    private short m_state;

    public static Set<RepresentationEdge<RepresentationNode>> getViolations(Set<RepresentationNode> nodes) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'getViolations' must not be empty";
        LOGGER.debug("Determine violations");
        LinkedHashSet<RepresentationEdge<RepresentationNode>> violations = new LinkedHashSet<RepresentationEdge<RepresentationNode>>(nodes.stream().flatMap(n2 -> n2.getOutgoingEdges().stream()).filter(edge -> edge.getNumberOfViolatingParserDependencies() > 0).collect(Collectors.toList()));
        LOGGER.debug("Determine violations - done");
        return violations;
    }

    public RepresentationNode(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'RepresentationNode' must not be null";
        this.m_namedElement = namedElement;
    }

    @Override
    public final NamedElement getElement() {
        return this.m_namedElement.getElement();
    }

    @Override
    public final String getShortName() {
        return this.m_namedElement.getShortName();
    }

    @Override
    public NamedElement getNamedElement() {
        return this.m_namedElement.getRepresentative();
    }

    @Override
    public final NamedElement getUnderlyingObject() {
        return this.getNamedElement();
    }

    @Override
    public int getLineNumber() {
        return this.m_namedElement.getLineNumber();
    }

    @Override
    public final String getImageResourceName() {
        return this.m_namedElement.getImageResourceName();
    }

    @Override
    public final boolean isValid() {
        return this.m_namedElement.isValid();
    }

    @Override
    public final boolean hasUnresolvedErrorIssues() {
        return this.m_namedElement.hasUnresolvedErrorIssues();
    }

    @Override
    public final boolean hasUnresolvedWarningIssues() {
        return this.m_namedElement.hasUnresolvedWarningIssues();
    }

    @Override
    public final boolean isExternal() {
        return this.m_namedElement.isExternal();
    }

    @Override
    public final boolean isExcluded() {
        return this.m_namedElement.isExcluded();
    }

    @Override
    public final boolean ignoreIssues() {
        return this.m_namedElement.ignoreIssues();
    }

    @Override
    public final String getPresentationName(boolean inContext) {
        return this.m_namedElement.getPresentationName(inContext);
    }

    @Override
    public final Element.IPropertiesManager getPropertiesManager() {
        return this.m_namedElement.getPropertiesManager();
    }

    @Override
    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Original: " + this.m_namedElement.toString());
        if (!this.m_namedElement.equals(this.getUnderlyingObject())) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("Representative: " + this.getUnderlyingObject().toString());
        }
        return builder.toString();
    }

    public final void setIsMainPathNode(boolean isMainPathNode) {
        if (isMainPathNode) {
            if (this.isAdditionalNode()) {
                this.m_state = ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << State.IS_ADDITIONAL_NODE.ordinal())));
            }
            this.m_state = ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << State.IS_MAIN_PATH_NODE.ordinal())));
        } else {
            this.m_state = ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << State.IS_MAIN_PATH_NODE.ordinal())));
        }
    }

    public final boolean isMainNode() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << State.IS_MAIN_PATH_NODE.ordinal())));
    }

    public final void setIsAdditionalNode(boolean isAdditionalNode) {
        if (isAdditionalNode) {
            if (this.isMainNode()) {
                this.m_state = ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << State.IS_MAIN_PATH_NODE.ordinal())));
            }
            this.m_state = ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << State.IS_ADDITIONAL_NODE.ordinal())));
        } else {
            this.m_state = ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << State.IS_ADDITIONAL_NODE.ordinal())));
        }
    }

    public final boolean isAdditionalNode() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << State.IS_ADDITIONAL_NODE.ordinal())));
    }

    public final void setIsOriginalInputRelated(boolean isOriginalInputRelated) {
        this.m_state = isOriginalInputRelated ? ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << State.IS_ORIGINAL_INPUT_RELATED.ordinal()))) : ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << State.IS_ORIGINAL_INPUT_RELATED.ordinal())));
    }

    public final boolean isOriginalInputRelated() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << State.IS_ORIGINAL_INPUT_RELATED.ordinal())));
    }

    public final void setIsOriginalInputAncestor(boolean isOriginalInputRelated) {
        this.m_state = isOriginalInputRelated ? ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << State.IS_ORIGINAL_INPUT_ANCESTOR.ordinal()))) : ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << State.IS_ORIGINAL_INPUT_ANCESTOR.ordinal())));
    }

    public final boolean isOriginalInputAncestor() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << State.IS_ORIGINAL_INPUT_ANCESTOR.ordinal())));
    }

    public final void setIsOriginalInputDescendant(boolean isOriginalInputDescendant) {
        this.m_state = isOriginalInputDescendant ? ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << State.IS_ORIGINAL_INPUT_DESCENDANT.ordinal()))) : ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << State.IS_ORIGINAL_INPUT_DESCENDANT.ordinal())));
    }

    public final boolean isOriginalInputDescendant() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << State.IS_ORIGINAL_INPUT_DESCENDANT.ordinal())));
    }

    public final void setIsVisible(boolean isVisible) {
        this.m_state = isVisible ? ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << State.VISIBLE.ordinal()))) : ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << State.VISIBLE.ordinal())));
    }

    public boolean isVisible() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << State.VISIBLE.ordinal())));
    }

    protected final void setState(short state) {
        this.m_state = state;
    }

    protected final short getState() {
        return this.m_state;
    }

    public final boolean hasEdges() {
        return this.m_edges != null && !this.m_edges.isEmpty();
    }

    private void unlinkEdge(RepresentationEdge<RepresentationNode> treeEdge) {
        assert (this.hasEdges()) : "No edges: " + this;
        assert (treeEdge != null) : "Parameter 'treeEdge' of method 'unlinkEdge' must not be null";
        boolean success = this.m_edges.remove(treeEdge);
        assert (success) : "Edge not found: " + treeEdge;
        if (this.m_edges.isEmpty()) {
            this.m_edges = null;
        }
    }

    public final void removeEdges() {
        if (this.hasEdges()) {
            for (RepresentationEdge<RepresentationNode> nextEdge : this.m_edges) {
                boolean isOutgoing;
                boolean bl2 = isOutgoing = nextEdge.getFrom() == this;
                if (isOutgoing) {
                    if (nextEdge.getTo() == this) continue;
                    nextEdge.getTo().unlinkEdge(nextEdge);
                    continue;
                }
                nextEdge.getFrom().unlinkEdge(nextEdge);
            }
            this.m_edges = null;
        }
    }

    public final RepresentationEdge<RepresentationNode> findEdge(RepresentationNode from, RepresentationNode to) {
        assert (from != null) : "Parameter 'from' of method 'findEdge' must not be null";
        assert (to != null) : "Parameter 'to' of method 'findEdge' must not be null";
        if (this.hasEdges()) {
            for (RepresentationEdge<RepresentationNode> nextEdge : this.m_edges) {
                if (nextEdge.getFrom() != from || nextEdge.getTo() != to) continue;
                return nextEdge;
            }
        }
        return null;
    }

    private void linkEdge(RepresentationEdge<RepresentationNode> treeNode) {
        assert (treeNode != null) : "Parameter 'treeNode' of method 'linkEdge' must not be null";
        RepresentationEdge<RepresentationNode> alreadyAddedEdge = this.findEdge(treeNode.getFrom(), treeNode.getTo());
        if (alreadyAddedEdge == null) {
            if (this.m_edges == null) {
                this.m_edges = new ArrayList(5);
            }
            this.m_edges.add(treeNode);
        } else {
            LOGGER.warn("Edge already added: " + alreadyAddedEdge);
        }
    }

    public final void addEdge(RepresentationEdge<RepresentationNode> treeEdge) {
        assert (treeEdge != null) : "Parameter 'treeEdge' of method 'addEdge' must not be null";
        this.linkEdge(treeEdge);
        if (treeEdge.getFrom() != this || treeEdge.getTo() != this) {
            if (treeEdge.getFrom() == this) {
                treeEdge.getTo().linkEdge(treeEdge);
            } else if (treeEdge.getTo() == this) {
                treeEdge.getFrom().linkEdge(treeEdge);
            } else assert (false) : "Edge does not contain 'this': " + this + " (" + treeEdge + ")";
        }
    }

    public final List<RepresentationEdge<RepresentationNode>> getOutgoingEdges() {
        if (!this.hasEdges()) {
            return Collections.emptyList();
        }
        ArrayList<RepresentationEdge<RepresentationNode>> result = new ArrayList<RepresentationEdge<RepresentationNode>>();
        for (RepresentationEdge<RepresentationNode> nextEdge : this.m_edges) {
            if (!nextEdge.getFrom().equals(this)) continue;
            result.add(nextEdge);
        }
        return result;
    }

    public final List<RepresentationEdge<RepresentationNode>> getIncomingEdges() {
        if (!this.hasEdges()) {
            return Collections.emptyList();
        }
        ArrayList<RepresentationEdge<RepresentationNode>> result = new ArrayList<RepresentationEdge<RepresentationNode>>();
        for (RepresentationEdge<RepresentationNode> nextEdge : this.m_edges) {
            if (!nextEdge.getTo().equals(this)) continue;
            result.add(nextEdge);
        }
        return result;
    }

    public final List<RepresentationEdge<RepresentationNode>> getEdges() {
        if (this.m_edges != null) {
            return Collections.unmodifiableList(this.m_edges);
        }
        return Collections.emptyList();
    }

    @Override
    public final List<ParserDependency> getIncomingParserDependencies() {
        ArrayList<ParserDependency> collected = new ArrayList<ParserDependency>();
        for (RepresentationEdge nextIncomingEdge : this.getIncomingEdges()) {
            if (nextIncomingEdge.getEndpointType() != EndpointType.PARSER_DEPENDENCY) continue;
            for (Dependency nextDependency : nextIncomingEdge.getDependencies()) {
                assert (nextDependency instanceof ParserDependency) : "Unexpected class in method 'collectDependencies': " + nextDependency;
                collected.add((ParserDependency)nextDependency);
            }
        }
        return collected;
    }

    @Override
    public final List<ParserDependency> getOutgoingParserDependencies() {
        ArrayList<ParserDependency> collected = new ArrayList<ParserDependency>();
        for (RepresentationEdge nextOutgoingEdge : this.getOutgoingEdges()) {
            if (nextOutgoingEdge.getEndpointType() != EndpointType.PARSER_DEPENDENCY) continue;
            for (Dependency nextDependency : nextOutgoingEdge.getDependencies()) {
                assert (nextDependency instanceof ParserDependency) : "Unexpected class in method 'collectDependencies': " + nextDependency;
                collected.add((ParserDependency)nextDependency);
            }
        }
        return collected;
    }

    public final List<RepresentationNode> getNodesForIncoming(boolean includeSelfEdges) {
        Stream<RepresentationNode> stream = this.getIncomingEdges().stream().map(RepresentationEdge::getFrom).map(RepresentationNode.class::cast);
        if (!includeSelfEdges) {
            stream = stream.filter(node -> this == node);
        }
        return stream.collect(Collectors.toList());
    }

    public final List<RepresentationNode> getNodesForOutgoing(boolean includeSelfEdges) {
        Stream<RepresentationNode> stream = this.getOutgoingEdges().stream().map(RepresentationEdge::getTo).map(RepresentationNode.class::cast);
        if (!includeSelfEdges) {
            stream = stream.filter(node -> this == node);
        }
        return stream.collect(Collectors.toList());
    }

    public void finishModification() {
        if (this.m_edges != null) {
            this.m_edges.trimToSize();
        }
    }

    public String getTextForNode(NameMode nameMode) {
        assert (nameMode != null) : "Parameter 'nameMode' of method 'getTextForNode' must not be null";
        switch (nameMode) {
            case SHORT: {
                return this.getUnderlyingObject().getPresentationName(true);
            }
            case FULL: {
                String text = this.getUnderlyingObject().getPresentationName(false);
                if (text.startsWith("./")) {
                    text = text.substring(2);
                }
                return text;
            }
        }
        assert (false) : "Unsupported name mode:" + (Object)((Object)nameMode);
        return null;
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Is Main Node?: ");
        builder.append(this.isMainNode());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Is Additional Node?: ");
        builder.append(this.isAdditionalNode());
        return builder.toString();
    }

    protected static enum State {
        EXPANDABLE,
        EXPANDED,
        VISIBLE,
        IS_MAIN_PATH_NODE,
        IS_ADDITIONAL_NODE,
        IS_ORIGINAL_INPUT_RELATED,
        IS_ORIGINAL_INPUT_DESCENDANT,
        IS_ORIGINAL_INPUT_ANCESTOR;

    }
}

