/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.representation;

import com.hello2morrow.foundation.propertyreader.IntProperty;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.IDependency;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class RepresentationDependency
extends RepresentationElement
implements IDependency {
    private int m_violationCount;
    private int m_nonArchitectureRelevantCount;

    public static final Set<Pair<String, String>> getDescriptors(Collection<? extends RepresentationDependency> representationDependencies, IElementResolver resolver) {
        assert (representationDependencies != null) : "Parameter 'elementsToAdd' of method 'getDescriptors' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'getDescriptors' must not be null";
        HashSet<Pair<String, String>> descriptors = new HashSet<Pair<String, String>>(representationDependencies.size());
        descriptors.clear();
        for (RepresentationDependency representationDependency : representationDependencies) {
            NamedElement from = representationDependency.getFromEndPoint();
            NamedElement to = representationDependency.getToEndPoint();
            String fromDescriptor = resolver.getDescriptor(from);
            String toDescriptor = resolver.getDescriptor(to);
            if (fromDescriptor == null || toDescriptor == null) continue;
            descriptors.add((Pair<String, String>)new Pair((Object)fromDescriptor, (Object)toDescriptor));
        }
        return descriptors;
    }

    public final EdgeAdapter.ArchitectureViolationMode getArchitectureViolationMode() {
        if (this.getEndpointType() == EndpointType.PARSER_DEPENDENCY) {
            if (this.m_nonArchitectureRelevantCount == this.getWeight()) {
                return EdgeAdapter.ArchitectureViolationMode.NOT_RELEVANT_FOR_ARCHITECTURE;
            }
            if (this.m_violationCount == 0) {
                return EdgeAdapter.ArchitectureViolationMode.NO_VIOLATIONS;
            }
            if (this.getWeight() - this.m_nonArchitectureRelevantCount == this.m_violationCount) {
                return EdgeAdapter.ArchitectureViolationMode.FULL_VIOLATION;
            }
            return EdgeAdapter.ArchitectureViolationMode.PARTIAL_VIOLATION;
        }
        return EdgeAdapter.ArchitectureViolationMode.ARCHITECTURE_NOT_ENABLED;
    }

    public final void update(IProviderId issueProviderId) {
        block8: {
            if (this.getEndpointType() != EndpointType.PARSER_DEPENDENCY) break block8;
            this.m_violationCount = 0;
            this.m_nonArchitectureRelevantCount = 0;
            if (issueProviderId != null) {
                for (Dependency dependency : this.getDependencies()) {
                    assert (dependency != null && dependency instanceof ParserDependency) : "Unexpected class in method 'update': " + dependency;
                    ParserDependency nextParserDependency = (ParserDependency)dependency;
                    if (nextParserDependency.isArchitectureRelevant()) {
                        if (!nextParserDependency.isViolation(issueProviderId)) continue;
                        ++this.m_violationCount;
                        continue;
                    }
                    ++this.m_nonArchitectureRelevantCount;
                }
            } else {
                for (Dependency dependency : this.getDependencies()) {
                    assert (dependency != null && dependency instanceof ParserDependency) : "Unexpected class in method 'update': " + dependency;
                    ParserDependency nextParserDependency = (ParserDependency)dependency;
                    if (nextParserDependency.isArchitectureRelevant()) {
                        if (!nextParserDependency.isViolation()) continue;
                        ++this.m_violationCount;
                        continue;
                    }
                    ++this.m_nonArchitectureRelevantCount;
                }
            }
        }
    }

    public final int getNumberOfViolatingParserDependencies() {
        return this.m_violationCount;
    }

    @Override
    public abstract NamedElement getFromEndPoint();

    @Override
    public abstract NamedElement getToEndPoint();

    public abstract int getWeight();

    @IntProperty
    public abstract int getNumberOfParserDependencies();

    @Override
    public abstract Dependency getFirstDependency();

    @Override
    public abstract List<? extends Dependency> getDependencies();

    public abstract EndpointType getEndpointType();
}

