/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.representation;

import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationUtility;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public abstract class Representation
extends NamedElementContainer {
    public static final int NEW_NAME_SUFFIX = -1;
    private static int s_nameCounter = 0;
    private final NamedElement m_rootElement;
    private final IDomainRoot.Domain m_domain;
    private final Set<NamedElement> m_originalNodes;
    private final EndpointType m_endpointType;
    private final int m_id;

    protected Representation(SoftwareSystem softwareSystem, NamedElement parent, Collection<NamedElement> originalNodes, IDomainRoot.Domain domain, EndpointType endpointType, int nameSuffix) {
        super(parent);
        int n2;
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'Representation' must not be null";
        assert (originalNodes != null) : "Parameter 'originalNodes' of method 'Representation' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'Representation' must not be null";
        assert (endpointType != null) : "Parameter 'endpointType' of method 'Representation' must not be null";
        this.m_rootElement = RepresentationUtility.getRootElementForRepresentation(softwareSystem, originalNodes, domain);
        this.m_originalNodes = new TreeSet<NamedElement>(Comparator.comparing(NamedElement::getFullyQualifiedName));
        originalNodes.stream().map(namedElement -> namedElement.getOriginal()).forEach(e2 -> {
            boolean bl2 = this.m_originalNodes.add((NamedElement)e2);
        });
        this.m_domain = domain;
        this.m_endpointType = endpointType;
        if (nameSuffix == -1) {
            int n3 = s_nameCounter;
            n2 = n3;
            s_nameCounter = n3 + 1;
        } else {
            n2 = nameSuffix;
        }
        this.m_id = n2;
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    public final String getShortName() {
        return Integer.toString(this.m_id);
    }

    @Override
    public String getPresentationName(boolean shortName) {
        return String.valueOf(this.getClass().getSimpleName()) + "|" + this.m_endpointType.getPresentationName() + "|" + this.m_domain.getPresentationName() + "|" + this.m_rootElement.getPresentationName(true) + "|" + this.getShortName();
    }

    @Override
    public final IDomainRoot.Domain getDomain() {
        return this.m_domain;
    }

    public final EndpointType getEndpointType() {
        return this.m_endpointType;
    }

    public final int getId() {
        return this.m_id;
    }

    public final NamedElement getRootElement() {
        return this.m_rootElement;
    }

    public final boolean isLogicalRepresentation() {
        return this.m_domain == IDomainRoot.Domain.LOGICAL_MODULE_SCOPE || this.m_domain == IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE || this.m_domain == IDomainRoot.Domain.ARCHITECTURE_LOGICAL;
    }

    public final Set<NamedElement> getOriginalNodes() {
        return Collections.unmodifiableSet(this.m_originalNodes);
    }

    public final void setOriginalNodes(Collection<NamedElement> originalNodes) {
        assert (originalNodes != null) : "Parameter 'originalNodes' of method 'setOriginalNodes' must not be null";
        this.m_originalNodes.clear();
        this.m_originalNodes.addAll(originalNodes);
    }

    public final void removeFromOriginalInput(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'removeFromOriginalInput' must not be null";
        this.m_originalNodes.remove(namedElement.getOriginal());
    }

    protected final Iterator<NamedElement> getOriginalNodesIterator() {
        return this.m_originalNodes.iterator();
    }

    public final void addToOriginalInput(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'addToOriginalInput' must not be null";
        this.m_originalNodes.add(namedElement.getOriginal());
    }

    @Override
    public final void accept(NamedElement.INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
    }
}

