/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.representation;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureBaseElement;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeType;
import com.hello2morrow.sonargraph.core.model.representation.ProgrammingElementDeltaManager;
import com.hello2morrow.sonargraph.core.model.representation.Representation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationUtility;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.Representations;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public abstract class NodeAndEdgeRepresentation
extends Representation {
    private final SoftwareSystem m_softwareSystem;
    private final INamedElementResolver m_resolver;
    private final Map<NamedElement, NamedElement> m_namedElementToProxy = new THashMap();
    private final Set<CoreParserDependencyType> m_parserDependencyTypesForEdges = new THashSet();
    private final FocusMode m_focusMode;
    private final PresentationMode m_presentationMode;
    private final EnumSet<RepresentationProperty> m_properties = EnumSet.noneOf(RepresentationProperty.class);
    private final List<NodeAndEdgeRepresentation> m_slaveRepresentations = new ArrayList<NodeAndEdgeRepresentation>();
    private Map<NamedElement, Set<ProgrammingElement>> m_mainNodes;
    private Map<NamedElement, Set<ProgrammingElement>> m_additionalNodes;
    private NodeAdapterSet<? extends NodeAdapter> m_nodeAdapterSet;
    private ProgrammingElementDeltaManager m_programmingElementDeltaManager;
    private NodeAndEdgeRepresentation m_masterRepresentation;
    private String m_cycleForRepresentationFqName;

    protected NodeAndEdgeRepresentation(SoftwareSystem softwareSystem, INamedElementResolver resolver, String cycleForRepresentationFqName, Collection<NamedElement> originalInput, Set<CoreParserDependencyType> parserDependencyTypesForEdges, IDomainRoot.Domain domain, FocusMode focusMode, PresentationMode presentationMode, EnumSet<RepresentationProperty> properties, EndpointType endpointType, int nameSuffix) {
        super(softwareSystem, softwareSystem.getUniqueExistingChild(Representations.class), originalInput, domain, endpointType, nameSuffix);
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'BaseRepresentation' must not be null";
        assert (parserDependencyTypesForEdges != null) : "Parameter 'parserDependencyTypesForEdges' of method 'BaseRepresentation' must not be null";
        assert (focusMode != null) : "Parameter 'focusMode' of method 'BaseRepresentation' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'BaseRepresentation' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'BaseRepresentation' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'BaseRepresentation' must not be null";
        assert (endpointType != null) : "Parameter 'endpointType' of method 'BaseRepresentation' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_resolver = resolver;
        this.m_cycleForRepresentationFqName = cycleForRepresentationFqName;
        this.m_parserDependencyTypesForEdges.addAll(parserDependencyTypesForEdges);
        this.m_focusMode = focusMode;
        this.m_presentationMode = presentationMode;
        this.m_properties.addAll(properties);
    }

    public Predicate<ParserDependency> getDependencyFilter() {
        return null;
    }

    public final void setNodes(Map<NamedElement, Set<ProgrammingElement>> mainNodes, Map<NamedElement, Set<ProgrammingElement>> additionalNodes) {
        assert (mainNodes != null) : "Parameter 'mainNodes' of method 'setNodes' must not be null";
        assert (additionalNodes != null) : "Parameter 'additionalNodes' of method 'setNodes' must not be null";
        this.m_mainNodes = mainNodes;
        this.m_additionalNodes = additionalNodes;
    }

    public final void updateNodes(Map<NamedElement, Set<ProgrammingElement>> mainNodes, Map<NamedElement, Set<ProgrammingElement>> additionalNodes, boolean overwrite) {
        Object programmingElements;
        NamedElement original;
        assert (mainNodes != null) : "Parameter 'mainNodes' of method 'updateNodes' must not be null";
        assert (additionalNodes != null) : "Parameter 'additionalNodes' of method 'updateNodes' must not be null";
        for (Map.Entry<NamedElement, Set<ProgrammingElement>> entry : mainNodes.entrySet()) {
            original = entry.getKey().getOriginal();
            if (this.getNode(original) == null) continue;
            if (overwrite) {
                this.m_mainNodes.put(original, entry.getValue());
                continue;
            }
            programmingElements = this.m_mainNodes.get(original);
            if (programmingElements == null) {
                programmingElements = new THashSet();
                this.m_mainNodes.put(original, (Set<ProgrammingElement>)programmingElements);
            }
            programmingElements.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<NamedElement, Set<ProgrammingElement>> entry : additionalNodes.entrySet()) {
            original = entry.getKey().getOriginal();
            if (this.getNode(original) == null) continue;
            if (overwrite) {
                this.m_additionalNodes.put(original, entry.getValue());
                continue;
            }
            programmingElements = this.m_additionalNodes.get(original);
            if (programmingElements == null) {
                programmingElements = new THashSet();
                this.m_additionalNodes.put(original, (Set<ProgrammingElement>)programmingElements);
            }
            programmingElements.addAll((Collection)entry.getValue());
        }
    }

    public final void removeNode(NamedElement elementToRemove, NodeType nodeType, boolean removeFromRepresentation) {
        Map<NamedElement, Set<ProgrammingElement>> mapToUpdate;
        assert (elementToRemove != null) : "Parameter 'elementsToRemove' of method 'updateNodes' must not be null";
        assert (nodeType != null) : "Parameter 'nodeType' of method 'updateNodes' must not be null";
        switch (nodeType) {
            case MAIN: {
                mapToUpdate = this.m_mainNodes;
                break;
            }
            case ADDITIONAL: {
                mapToUpdate = this.m_additionalNodes;
                break;
            }
            default: {
                assert (false) : "Unexpected nodeType " + (Object)((Object)nodeType);
                return;
            }
        }
        NamedElement original = elementToRemove.getOriginal();
        mapToUpdate.remove(original);
        if (removeFromRepresentation) {
            this.removeNodeFromElement(original);
        }
    }

    public void convertNode(NamedElement nodeForElement, NodeType currentType, NodeType newType) {
        Map<NamedElement, Set<ProgrammingElement>> mapToAdd;
        Map<NamedElement, Set<ProgrammingElement>> mapToRemove;
        assert (nodeForElement != null) : "Parameter 'nodeForElement' of method 'convertNode' must not be null";
        assert (currentType != null) : "Parameter 'currentType' of method 'convertNode' must not be null";
        assert (newType != null) : "Parameter 'newType' of method 'convertNode' must not be null";
        assert (currentType != newType) : "'currentType' must be different from 'newType'";
        switch (currentType) {
            case MAIN: {
                mapToRemove = this.m_mainNodes;
                break;
            }
            case ADDITIONAL: {
                mapToRemove = this.m_additionalNodes;
                break;
            }
            default: {
                assert (false) : "Unexpected nodeType " + (Object)((Object)currentType);
                return;
            }
        }
        switch (newType) {
            case MAIN: {
                mapToAdd = this.m_mainNodes;
                break;
            }
            case ADDITIONAL: {
                mapToAdd = this.m_additionalNodes;
                break;
            }
            default: {
                assert (false) : "Unexpected nodeType " + (Object)((Object)newType);
                return;
            }
        }
        NamedElement original = nodeForElement.getOriginal();
        Set<ProgrammingElement> programmingElements = mapToRemove.remove(original);
        assert (programmingElements != null) : "Parameter 'programmingElements' of method 'convertnode' must not be null";
        Set<ProgrammingElement> previous = mapToAdd.put(original, programmingElements);
        assert (previous == null) : "Parameter 'previous' of method 'convertnode' must be null";
    }

    public final void addProgrammingElementsForNamedElement(NamedElement namedElement, Set<ProgrammingElement> programmingElements, boolean mainNodes) {
        THashSet currentProgrammingElements;
        assert (namedElement != null) : "Parameter 'namedElement' of method 'addProgrammingElementsForNamedElement' must not be null";
        assert (programmingElements != null) : "Parameter 'programmingElements' of method 'addProgrammingElementsForNamedElement' must not be null";
        NamedElement original = namedElement.getOriginal();
        Object object = currentProgrammingElements = mainNodes ? this.m_mainNodes.get(original) : this.m_additionalNodes.get(original);
        if (currentProgrammingElements == null) {
            currentProgrammingElements = new THashSet();
            if (mainNodes) {
                this.m_mainNodes.put(original, (Set<ProgrammingElement>)currentProgrammingElements);
            } else {
                this.m_additionalNodes.put(original, (Set<ProgrammingElement>)currentProgrammingElements);
            }
        }
        currentProgrammingElements.addAll(programmingElements);
    }

    protected abstract void removeNodeFromElement(NamedElement var1);

    public final void removeOriginalInputElementsWithoutNodes() {
        Iterator<NamedElement> it = this.getOriginalNodesIterator();
        while (it.hasNext()) {
            NamedElement next = it.next();
            if (this.getNode(next) != null) continue;
            it.remove();
        }
    }

    public final Set<NamedElement> getMainNodes() {
        assert (this.m_mainNodes != null) : "'m_mainNodes' of method 'getMainNodes' must not be null";
        return Collections.unmodifiableSet(this.m_mainNodes.keySet());
    }

    public final Set<NamedElement> getAdditionalNodes() {
        assert (this.m_additionalNodes != null) : "'m_additionalNodes' of method 'getAdditionalNodes' must not be null";
        return Collections.unmodifiableSet(this.m_additionalNodes.keySet());
    }

    public final Set<ProgrammingElement> getProgrammingElementsForMainNode(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getProgrammingElementsForMainNode' must not be null";
        Set<ProgrammingElement> programmingElements = this.m_mainNodes.get(namedElement.getOriginal());
        assert (programmingElements != null) : " 'programmingElements' of method 'getProgrammingElementsForMainNode' must not be null";
        return programmingElements;
    }

    public final Set<ProgrammingElement> getProgrammingElementsForAdditionalNode(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getProgrammingElementsForMainNode' must not be null";
        Set<ProgrammingElement> programmingElements = this.m_additionalNodes.get(namedElement.getOriginal());
        assert (programmingElements != null) : " 'programmingElements' of method 'getProgrammingElementsForMainNode' must not be null";
        return programmingElements;
    }

    public final FocusMode getFocusMode() {
        return this.m_focusMode;
    }

    public final boolean allowsTransitiveDependencies() {
        return this.m_properties.contains((Object)RepresentationProperty.ALLOWS_TRANSITIVE);
    }

    public final PresentationMode getPresentationMode() {
        return this.m_presentationMode;
    }

    public final NamedElement getParent(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getParent' must not be null";
        if (namedElement instanceof ProgrammingElement && this.isLogicalRepresentation()) {
            return RepresentationUtility.getLogicalNamespaceForProgrammingElement(this.m_softwareSystem, (ProgrammingElement)namedElement, this.getDomain());
        }
        NamedElement parent = namedElement.getParent();
        while (parent.isGhost()) {
            parent = parent.getParent();
        }
        return parent;
    }

    private void mapLogicalProgrammingElement(IAssignableToArtifact assignable) {
        assert (assignable instanceof LogicalProgrammingElement);
        LogicalProgrammingElement element = (LogicalProgrammingElement)assignable;
        for (ProgrammingElement programmingElement : element.getLogicalGroup()) {
            this.m_namedElementToProxy.put(programmingElement, element);
        }
    }

    protected final void checkForMappingsToProxies(NamedElement namedElement) {
        block7: {
            block8: {
                assert (namedElement != null) : "Parameter 'namedElement' of method 'checkForLogicalNamespace' must not be null";
                if (!this.isLogicalRepresentation()) break block7;
                if (this.getDomain() != IDomainRoot.Domain.ARCHITECTURE_LOGICAL) break block8;
                if (namedElement instanceof AssignedElement) {
                    this.mapLogicalProgrammingElement(((AssignedElement)namedElement).getAssignable());
                } else if (namedElement instanceof ArchitectureBaseElement) {
                    ArchitectureBaseElement architectureBaseElement = (ArchitectureBaseElement)namedElement;
                    architectureBaseElement.getAssignedElements().forEach(e2 -> this.mapLogicalProgrammingElement((IAssignableToArtifact)e2));
                    architectureBaseElement.getChildren(Artifact.class).forEach(a2 -> this.checkForMappingsToProxies((NamedElement)a2));
                } else {
                    for (AssignedElement assignedElement : namedElement.getChildrenRecursively(AssignedElement.class, new Class[0])) {
                        this.mapLogicalProgrammingElement(assignedElement.getAssignable());
                    }
                }
                break block7;
            }
            if (!(namedElement instanceof LogicalProgrammingElement)) break block7;
            for (ProgrammingElement programmingElement : ((LogicalProgrammingElement)namedElement).getLogicalGroup()) {
                this.m_namedElementToProxy.put(programmingElement, namedElement);
            }
        }
    }

    public final Map<NamedElement, NamedElement> getProgrammingElementToProxy() {
        return Collections.unmodifiableMap(this.m_namedElementToProxy);
    }

    public final void setNodeAdapterSet(NodeAdapterSet<? extends NodeAdapter> nodeAdapterSet) {
        assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'setNodeAdapterSet' must not be null";
        this.m_nodeAdapterSet = nodeAdapterSet;
    }

    public final <T extends NodeAdapter> T getNodeAdapterFromRepresentationNode(RepresentationNode node) {
        assert (node != null) : "Parameter 'node' of method 'getNodeAdapterFromRepresentationNode' must not be null";
        NamedElement namedElement = node.getUnderlyingObject();
        assert (this.m_nodeAdapterSet != null) : "'m_nodeAdapterSet' of method 'getNodeAdapterFromRepresentationNode' must not be null";
        return (T)this.m_nodeAdapterSet.getNodeAdapterFor(namedElement);
    }

    public final void setParserDependencyTypesEdges(Set<CoreParserDependencyType> parserDependencyTypesForEdges) {
        assert (parserDependencyTypesForEdges != null) : "Parameter 'parserDependencyTypesEdges' of method 'setParserDependencyTypesEdges' must not be null";
        this.m_parserDependencyTypesForEdges.clear();
        this.m_parserDependencyTypesForEdges.addAll(parserDependencyTypesForEdges);
    }

    public final Set<CoreParserDependencyType> getParserDependencyTypesForEdges() {
        return Collections.unmodifiableSet(this.m_parserDependencyTypesForEdges);
    }

    public boolean onlyVisible() {
        return this.m_properties.contains((Object)RepresentationProperty.ONLY_VISIBLE);
    }

    public boolean onlyInternal() {
        return this.m_properties.contains((Object)RepresentationProperty.ONLY_INTERNAL);
    }

    public boolean addMainPathNodesDinamically() {
        return this.m_properties.contains((Object)RepresentationProperty.ADD_MAIN_NODES_DYNAMICALLY);
    }

    public EnumSet<RepresentationProperty> getRepresentationProperties() {
        return this.m_properties;
    }

    public Collection<NamedElement> getVisibleMainNodes() {
        return this.getMainNodes();
    }

    public final void createDelta(int stateId, boolean forceResetDeltaManager) {
        if (this.getEndpointType() != EndpointType.PARSER_DEPENDENCY) {
            if (this.m_programmingElementDeltaManager == null) {
                this.m_programmingElementDeltaManager = new ProgrammingElementDeltaManager(stateId);
            }
            return;
        }
        THashSet programmingElementsOfMainNodes = new THashSet();
        THashSet programmingElementsOfAdditionalNodes = new THashSet();
        for (Set<ProgrammingElement> nextProgrammingElements : this.m_mainNodes.values()) {
            programmingElementsOfMainNodes.addAll(nextProgrammingElements);
        }
        for (Set<ProgrammingElement> nextProgrammingElements : this.m_additionalNodes.values()) {
            programmingElementsOfAdditionalNodes.addAll(nextProgrammingElements);
        }
        if (this.m_programmingElementDeltaManager == null || forceResetDeltaManager) {
            this.m_programmingElementDeltaManager = new ProgrammingElementDeltaManager((Collection<ProgrammingElement>)programmingElementsOfMainNodes, (Collection<ProgrammingElement>)programmingElementsOfAdditionalNodes, stateId);
        } else {
            this.m_programmingElementDeltaManager.createDelta((Collection<ProgrammingElement>)programmingElementsOfMainNodes, (Collection<ProgrammingElement>)programmingElementsOfAdditionalNodes, stateId);
        }
    }

    public void applyProgrammingElementCollectionsState(int stateId) {
        if (this.getEndpointType() == EndpointType.PARSER_DEPENDENCY) {
            this.m_programmingElementDeltaManager.setCurrentStateId(stateId);
        }
    }

    public void navigationStatesRemoved(List<Integer> stateIdsToRemove) {
        if (this.getEndpointType() == EndpointType.PARSER_DEPENDENCY && this.m_programmingElementDeltaManager != null) {
            this.m_programmingElementDeltaManager.removeDeltas(stateIdsToRemove);
        }
    }

    public void navigationStateAdded(int stateId, boolean createNewDelta) {
        if (this.getEndpointType() == EndpointType.PARSER_DEPENDENCY) {
            if (createNewDelta || this.m_programmingElementDeltaManager == null) {
                this.createDelta(stateId, false);
            } else {
                this.m_programmingElementDeltaManager.createDelta(stateId);
            }
            this.m_programmingElementDeltaManager.setCurrentDeltaForView(stateId);
        }
    }

    public final void navigationStateRestored(int stateId) {
        if (this.getEndpointType() == EndpointType.PARSER_DEPENDENCY) {
            this.m_programmingElementDeltaManager.setCurrentDeltaForView(stateId);
        }
    }

    public final Set<ProgrammingElement> getProgrammingElementsForMainNodes() {
        if (this.getEndpointType() == EndpointType.PARSER_DEPENDENCY) {
            return this.m_programmingElementDeltaManager.getMainNodeProgrammingElements();
        }
        return Collections.emptySet();
    }

    public final Set<ProgrammingElement> getProgrammingElementsForAdditionalNodes() {
        if (this.getEndpointType() == EndpointType.PARSER_DEPENDENCY) {
            return this.m_programmingElementDeltaManager.getAdditionalNodeProgrammingElements();
        }
        return Collections.emptySet();
    }

    protected final void setProgrammingElementDeltaManager(ProgrammingElementDeltaManager manager) {
        if (this.getEndpointType() == EndpointType.PARSER_DEPENDENCY) {
            assert (manager != null) : "Parameter 'manager' of method 'setProgrammingElementDeltaManager' must not be null";
            this.m_programmingElementDeltaManager = manager;
        }
    }

    public ProgrammingElementDeltaManager getProgrammingElementDeltaManager() {
        return this.m_programmingElementDeltaManager;
    }

    private void setMasterRepresentation(NodeAndEdgeRepresentation masterRepresentation) {
        assert (masterRepresentation != null) : "Parameter 'masterRepresentation' of method 'setMasterRepresentation' must not be null";
        this.m_masterRepresentation = masterRepresentation;
    }

    public NodeAndEdgeRepresentation getMasterRepresentation() {
        return this.m_masterRepresentation;
    }

    public void addSlaveRepresentation(NodeAndEdgeRepresentation slaveRepresentation) {
        assert (slaveRepresentation != null) : "Parameter 'slaveRepresentation' of method 'addDependantRepresentation' must not be null";
        this.m_slaveRepresentations.add(slaveRepresentation);
        slaveRepresentation.setMasterRepresentation(this);
    }

    public void removeSlaveRepresentation(NodeAndEdgeRepresentation slaveRepresentation) {
        assert (slaveRepresentation != null) : "Parameter 'slaveRepresentation' of method 'removeSlaveRepresentation' must not be null";
        this.m_slaveRepresentations.remove(slaveRepresentation);
    }

    public void cleanUpSlaveRepresentations() {
        Iterator<NodeAndEdgeRepresentation> it = this.m_slaveRepresentations.iterator();
        while (it.hasNext()) {
            NodeAndEdgeRepresentation slave = it.next();
            if (slave.isValid()) continue;
            it.remove();
        }
    }

    public List<NodeAndEdgeRepresentation> getSlaveRepresentations() {
        return this.m_slaveRepresentations;
    }

    public final boolean shouldRemoveRepresentation() {
        return this.m_cycleForRepresentationFqName != null && this.m_resolver.resolve(this.m_softwareSystem, this.m_cycleForRepresentationFqName) == null;
    }

    public final String getCycleForRepresentationFqName() {
        return this.m_cycleForRepresentationFqName;
    }

    public final void updateCycleForRepresentationFqName(String cycleFqName) {
        assert (cycleFqName != null) : "Parameter 'cycleFqName' of method 'updateCycleForRepresentationFqName' must not be null";
        this.m_cycleForRepresentationFqName = cycleFqName;
    }

    public boolean isLevelized() {
        return false;
    }

    @Override
    public void remove() {
        this.m_masterRepresentation = null;
        super.remove();
    }

    public abstract RepresentationNode getNode(NamedElement var1);

    public abstract Collection<? extends RepresentationNode> getNodes();

    public abstract Collection<? extends RepresentationNode> getVisibleNodes();

    public static enum RepresentationProperty implements IStandardEnumeration
    {
        ALLOWS_TRANSITIVE,
        ONLY_VISIBLE,
        ONLY_INTERNAL,
        ADD_MAIN_NODES_DYNAMICALLY,
        TYPE_BASED_GRAPH,
        DONT_COLLECT_TYPES_RECURSIVELY;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

