/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.representation;

import com.hello2morrow.foundation.utilities.CollectionUtility;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public final class FocusProperties {
    private FocusMode m_focusMode;
    private final EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> m_properties = EnumSet.noneOf(NodeAndEdgeRepresentation.RepresentationProperty.class);
    private final Set<CoreParserDependencyType> m_parserDependencyTypesForEdges = new HashSet<CoreParserDependencyType>();

    public FocusProperties(FocusMode focusMode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties, Set<CoreParserDependencyType> parserDependencyTypesForEdges) {
        assert (focusMode != null) : "Parameter 'focusMode' of method 'FocusProperties' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'FocusProperties' must not be null";
        this.m_focusMode = focusMode;
        this.m_properties.addAll(properties);
        this.m_parserDependencyTypesForEdges.addAll(parserDependencyTypesForEdges);
    }

    public FocusProperties(FocusProperties toCopy) {
        this(toCopy.m_focusMode, toCopy.m_properties, toCopy.m_parserDependencyTypesForEdges);
    }

    public FocusProperties() {
        this(FocusMode.IN_AND_OUT, EnumSet.noneOf(NodeAndEdgeRepresentation.RepresentationProperty.class), CollectionUtility.asSet((Object[])CoreParserDependencyType.values()));
    }

    public FocusMode getFocusMode() {
        return this.m_focusMode;
    }

    public void setFocusMode(FocusMode focusMode) {
        assert (focusMode != null) : "Parameter 'focusMode' of method 'setFocusMode' must not be null";
        this.m_focusMode = focusMode;
    }

    public void setTransitive(boolean transitive) {
        NodeAndEdgeRepresentation.RepresentationProperty allowsTransitive = NodeAndEdgeRepresentation.RepresentationProperty.ALLOWS_TRANSITIVE;
        if (transitive) {
            this.m_properties.add(allowsTransitive);
        } else {
            this.m_properties.remove((Object)allowsTransitive);
        }
    }

    public boolean transitive() {
        return this.m_properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.ALLOWS_TRANSITIVE);
    }

    public void setOnlyInternal(boolean internal) {
        NodeAndEdgeRepresentation.RepresentationProperty allowsTransitive = NodeAndEdgeRepresentation.RepresentationProperty.ONLY_INTERNAL;
        if (internal) {
            this.m_properties.add(allowsTransitive);
        } else {
            this.m_properties.remove((Object)allowsTransitive);
        }
    }

    public boolean onlyInternal() {
        return this.m_properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.ONLY_INTERNAL);
    }

    public void addParserDependencyType(CoreParserDependencyType parserDependencyType) {
        assert (parserDependencyType != null) : "Parameter 'parserDependencyType' of method 'addParserDependencyType' must not be null";
        this.m_parserDependencyTypesForEdges.add(parserDependencyType);
    }

    public void removeParserDependencyType(CoreParserDependencyType parserDependencyType) {
        assert (parserDependencyType != null) : "Parameter 'parserDependencyType' of method 'removeParserDependencyType' must not be null";
        this.m_parserDependencyTypesForEdges.remove((Object)parserDependencyType);
    }

    public Set<CoreParserDependencyType> getParserDependencyTypesForEdges() {
        return Collections.unmodifiableSet(this.m_parserDependencyTypesForEdges);
    }

    public EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> getProperties() {
        return this.m_properties;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.m_focusMode);
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Properties: " + this.m_properties);
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Dependency Types: " + this.m_parserDependencyTypesForEdges);
        builder.append(StringUtility.LINE_SEPARATOR);
        return builder.toString();
    }
}

