/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.report;

import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import java.util.Comparator;

final class ReportComparator {
    private ReportComparator() {
    }

    static Comparator<Issue> createIssueComparator() {
        return new Comparator<Issue>(){

            @Override
            public int compare(Issue i1, Issue i2) {
                int severityCompare = Integer.compare(i1.getSeverity().ordinal(), i2.getSeverity().ordinal());
                if (severityCompare != 0) {
                    return severityCompare;
                }
                int idCompare = i1.getId().getStandardName().compareToIgnoreCase(i2.getId().getStandardName());
                if (idCompare != 0) {
                    return idCompare;
                }
                int categoryCompare = i1.getId().getCategory().getStandardName().compareToIgnoreCase(i2.getId().getCategory().getStandardName());
                if (categoryCompare != 0) {
                    return categoryCompare;
                }
                int elementCompare = i1.getAffectedElement().getPresentationName(false).compareToIgnoreCase(i1.getAffectedElement().getPresentationName(false));
                return elementCompare;
            }
        };
    }

    static Comparator<IMetricDescriptor> createMetricDescriptorComparator() {
        return new Comparator<IMetricDescriptor>(){

            @Override
            public int compare(IMetricDescriptor o1, IMetricDescriptor o2) {
                int result = o1.getMetricId().getPresentationName().compareToIgnoreCase(o2.getMetricId().getPresentationName());
                if (result != 0) {
                    return result;
                }
                return o1.getMetricId().getStandardName().compareTo(o2.getMetricId().getStandardName());
            }
        };
    }

    static Comparator<IMetricCategory> createMetricCategoryComparator() {
        return new Comparator<IMetricCategory>(){

            @Override
            public int compare(IMetricCategory o1, IMetricCategory o2) {
                int result = o1.getPresentationName().compareToIgnoreCase(o2.getPresentationName());
                if (result != 0) {
                    return result;
                }
                return o1.getStandardName().compareTo(o2.getStandardName());
            }
        };
    }

    static Comparator<SonargraphFeature> createFeatureComparator() {
        return new Comparator<SonargraphFeature>(){

            @Override
            public int compare(SonargraphFeature f1, SonargraphFeature f2) {
                int result = f1.getPresentationName().compareToIgnoreCase(f2.getPresentationName());
                if (result != 0) {
                    return result;
                }
                return f1.getStandardName().compareTo(f2.getStandardName());
            }
        };
    }

    static Comparator<IAnalyzerId> createAnalyzerComparator() {
        return new Comparator<IAnalyzerId>(){

            @Override
            public int compare(IAnalyzerId a1, IAnalyzerId a2) {
                int result = -Integer.compare(a1.getExecutionLevel().ordinal(), a2.getExecutionLevel().ordinal());
                if (result != 0) {
                    return result;
                }
                return a1.getStandardName().compareTo(a2.getStandardName());
            }
        };
    }

    static Comparator<SonargraphPlugin> createPluginComparator() {
        return new Comparator<SonargraphPlugin>(){

            @Override
            public int compare(SonargraphPlugin p1, SonargraphPlugin p2) {
                return ReportComparator.compareSonargraphPlugin(p1, p2);
            }
        };
    }

    static Comparator<Pair<SonargraphPlugin, IAnalyzerId>> createLicensedPluginComparator() {
        return new Comparator<Pair<SonargraphPlugin, IAnalyzerId>>(){

            @Override
            public int compare(Pair<SonargraphPlugin, IAnalyzerId> p1, Pair<SonargraphPlugin, IAnalyzerId> p2) {
                SonargraphPlugin sp1 = (SonargraphPlugin)p1.getFirst();
                SonargraphPlugin sp2 = (SonargraphPlugin)p2.getFirst();
                return ReportComparator.compareSonargraphPlugin(sp1, sp2);
            }
        };
    }

    private static int compareSonargraphPlugin(SonargraphPlugin p1, SonargraphPlugin p2) {
        assert (p1 != null) : "Parameter 'p1' of method 'compareSonargraphPlugin' must not be null";
        assert (p2 != null) : "Parameter 'p2' of method 'compareSonargraphPlugin' must not be null";
        int result = Boolean.compare(p1.isEnabled(), p2.isEnabled());
        if (result != 0) {
            return result;
        }
        return p1.getId().compareTo(p2.getId());
    }
}

