/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.report;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CreateReportResult {
    private final Map<IReport.Format, TFile> m_formatToTargetFile = new LinkedHashMap<IReport.Format, TFile>(IReport.Format.values().length);
    private final Map<IReport.Format, TFile> m_formatToSystemDiffReportFiles = new LinkedHashMap<IReport.Format, TFile>(IReport.Format.values().length);
    private final IReport m_report;

    public CreateReportResult(IReport report) {
        assert (report != null) : "Parameter 'report' of method 'CreateReportResult' must not be null";
        this.m_report = report;
    }

    public IReport getReport() {
        return this.m_report;
    }

    public void addTargetFile(IReport.Format format, TFile targetFile) {
        assert (format != null) : "Parameter 'format' of method 'addTargetFile' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'addTargetFile' must not be null";
        TFile previous = this.m_formatToTargetFile.put(format, targetFile);
        assert (previous == null) : "'previous' of method 'addTargetFile' must be null";
    }

    public String getReportName() {
        List<TFile> files = this.getTargetFiles();
        if (files.isEmpty()) {
            return null;
        }
        return FileUtility.removeExtension((String)files.get(0).getName());
    }

    public TFile getTargetFile(IReport.Format format) {
        assert (format != null) : "Parameter 'format' of method 'getTargetFile' must not be null";
        return this.m_formatToTargetFile.get((Object)format);
    }

    public List<TFile> getTargetFiles() {
        return new ArrayList<TFile>(this.m_formatToTargetFile.values());
    }

    public void addSystemDiffReport(IReport.Format format, TFile file) {
        assert (format != null) : "Parameter 'format' of method 'addSystemDiffReport' must not be null";
        assert (file != null) : "Parameter 'file' of method 'addSystemDiffReport' must not be null";
        this.m_formatToSystemDiffReportFiles.put(format, file);
    }

    public TFile getSystemDiffReportFile(IReport.Format format) {
        return this.m_formatToSystemDiffReportFiles.get((Object)format);
    }

    public List<TFile> getSystemDiffReportFiles() {
        return new ArrayList<TFile>(this.m_formatToTargetFile.values());
    }
}

