/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StringUtility;
import java.util.LinkedHashSet;
import java.util.Set;

public final class StatusInfo {
    private Status m_status = Status.NONE;
    private Set<String> m_elementsInvalidInfo;
    private Set<String> m_collisionInfo;
    private String m_languageNotAvailable;
    private String m_targetRootDirectoryNotFound;
    private boolean m_invalidMatchingPatternUsed;

    public void reset() {
        this.m_elementsInvalidInfo = null;
        this.m_collisionInfo = null;
        this.m_languageNotAvailable = null;
        this.m_targetRootDirectoryNotFound = null;
        this.m_invalidMatchingPatternUsed = false;
        this.m_status = Status.NONE;
    }

    public void invalidMatchingPatternUsed() {
        this.m_invalidMatchingPatternUsed = true;
    }

    public void languageNotAvailable(String language) {
        assert (language != null) : "Parameter 'language' of method 'languageNotAvailable' must not be null";
        this.m_languageNotAvailable = language;
        this.m_status = Status.LANGUAGE_NOT_AVAILABLE;
    }

    public void targetRootDirectoryNotFound(String targetRootDirectory) {
        assert (targetRootDirectory != null && targetRootDirectory.length() > 0) : "Parameter 'targetRootDirectory' of method 'targetRootDirectoryNotFound' must not be empty";
        this.m_targetRootDirectoryNotFound = targetRootDirectory;
        this.m_status = Status.TARGET_ROOT_DIRECTORY_NOT_FOUND;
    }

    public void elementsInvalidInfo(String info) {
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'elementsInvalidInfo' must not be empty";
        if (this.m_elementsInvalidInfo == null) {
            this.m_elementsInvalidInfo = new LinkedHashSet<String>();
            this.m_status = Status.ELEMENTS_INVALID;
        }
        this.m_elementsInvalidInfo.add(info);
    }

    public void addCollisionInfo(String info) {
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'addCollisionInfo' must not be empty";
        if (this.m_collisionInfo == null) {
            this.m_collisionInfo = new LinkedHashSet<String>();
            this.m_status = Status.NOT_APPLICABLE;
        }
        this.m_collisionInfo.add(info);
    }

    public void setStatus(Status status) {
        assert (status != null) : "Parameter 'status' of method 'setStatus' must not be null";
        this.m_status = status;
    }

    public Status getStatus() {
        return this.m_status;
    }

    private String getInfo(Set<String> info, String title) {
        assert (info != null && !info.isEmpty()) : "Parameter 'info' of method 'getInfo' must not be empty";
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'getInfo' must not be empty";
        StringBuilder builder = new StringBuilder(Integer.toString(info.size()));
        builder.append(" " + title);
        int i2 = 1;
        for (String next : info) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("[").append(i2).append("] ");
            builder.append(next);
            ++i2;
        }
        return builder.toString();
    }

    public String getInformation() {
        if (this.m_languageNotAvailable != null) {
            return "'" + this.m_languageNotAvailable + "' not available.";
        }
        if (this.m_targetRootDirectoryNotFound != null) {
            return "'" + this.m_targetRootDirectoryNotFound + "' not found.";
        }
        if (this.m_elementsInvalidInfo != null && !this.m_elementsInvalidInfo.isEmpty()) {
            return this.getInfo(this.m_elementsInvalidInfo, "invalid element(s) detected");
        }
        if (this.m_collisionInfo != null && !this.m_collisionInfo.isEmpty()) {
            return this.getInfo(this.m_collisionInfo, "collision(s) detected");
        }
        if (this.m_invalidMatchingPatternUsed) {
            return "Invalid matching pattern(s) used";
        }
        return "";
    }

    public String toString() {
        String info = this.getInformation();
        return String.valueOf(this.m_status.getStandardName()) + (info.isEmpty() ? "" : " - " + info);
    }

    public static enum Status implements IStandardEnumeration
    {
        NOT_APPLICABLE(false),
        LANGUAGE_NOT_AVAILABLE(false),
        TARGET_ROOT_DIRECTORY_NOT_FOUND(false),
        ELEMENTS_INVALID(false),
        NO_ELEMENT_MATCHED(false),
        APPLICABLE(true),
        PARTIALLY_APPLICABLE(true),
        POTENTIALLY_DONE(false),
        NONE(false);

        private final boolean m_isApplicable;

        private Status(boolean isApplicable) {
            this.m_isApplicable = isApplicable;
        }

        public boolean isApplicable() {
            return this.m_isApplicable;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

