/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.architecture.RecursiveElementComponentContainer;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class PhysicalImpactDependencyEndpointCollector
extends DependencyEndpointCollector {
    protected PhysicalImpactDependencyEndpointCollector() {
    }

    public static final boolean isRecursiveElement(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'isRecursiveElement' must not be null";
        return namedElement instanceof IRecursiveElement;
    }

    public static final Set<ProgrammingElement> getProgrammingElementsFlat(NamedElement forNamedElement) {
        assert (forNamedElement != null) : "Parameter 'forNamedElement' of method 'getProgrammingElementsFlat' must not be null";
        HashSet<ProgrammingElement> result = new HashSet<ProgrammingElement>();
        if (forNamedElement instanceof LogicalNamespace) {
            LogicalNamespace lns = (LogicalNamespace)forNamedElement;
            for (ProgrammingElement next : lns.getProgrammingElements()) {
                result.add(next);
                result.addAll(next.getChildrenRecursively(ProgrammingElement.class, new Class[0]));
            }
        } else if (forNamedElement instanceof RecursiveElementComponentContainer) {
            List<AssignedElement> components = forNamedElement.getChildren(AssignedElement.class);
            for (AssignedElement nextComponent : components) {
                result.addAll(nextComponent.getRepresentedElement().getChildrenRecursively(ProgrammingElement.class, new Class[0]));
            }
        } else {
            List<IComponent> components = forNamedElement.getChildren(IComponent.class);
            for (IComponent nextComponent : components) {
                result.addAll(nextComponent.getNamedElement().getChildrenRecursively(ProgrammingElement.class, new Class[0]));
            }
        }
        return result;
    }
}

