/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementMoveRenameRefactoringIssue;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.refactoring.IRefactoringAdapter;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import java.util.Date;

public final class MoveRenameRefactoringDefinition
extends MoveRefactoringDefinition {
    public static final IIssueId MOVE_RENAME_REFACTORING_ISSUE_ID = CoreIssueId.MOVE_RENAME_REFACTORING;
    private final String m_newName;

    public static String createDescription(String targetRootDirectoryFqName, String moveToParentName, String newName) {
        assert (targetRootDirectoryFqName != null && targetRootDirectoryFqName.length() > 0) : "Parameter 'targetRootDirectoryFqName' of method 'createDescription' must not be empty";
        assert (moveToParentName != null) : "Parameter 'moveToParentName' of method 'createDescription' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'createDescription' must not be empty";
        return String.valueOf(MoveRefactoringDefinition.createDescription(targetRootDirectoryFqName, moveToParentName)) + " and rename to '" + newName + "'";
    }

    public MoveRenameRefactoringDefinition(NamedElement parent, Date date, String assignee, String description, Priority priority, String definedForLanguage, MoveRenameRefactoringElementType elementType, String targetRootDirectoryFqName, String moveToParentName, String newName) {
        super(parent, date, assignee, description, priority, definedForLanguage, elementType, targetRootDirectoryFqName, moveToParentName);
        assert (targetRootDirectoryFqName != null && targetRootDirectoryFqName.length() > 0) : "Parameter 'targetRootDirectoryFqName' of method 'MoveRenameRefactoringDefinition' must not be empty";
        assert (moveToParentName != null) : "Parameter 'moveToParentName' of method 'MoveRenameRefactoringDefinition' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'RenameRefactoringDefinition' must not be empty";
        this.m_newName = newName.intern();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MOVE_RENAME;
    }

    @Property
    public String getNewName() {
        return this.m_newName;
    }

    @Override
    public String getName() {
        return "Move/Rename Refactoring";
    }

    @Override
    public String getShortName() {
        return "Move/Rename";
    }

    @Override
    public IIssueId getAssociatedIssueId() {
        return MOVE_RENAME_REFACTORING_ISSUE_ID;
    }

    @Override
    public Issue createAssociatedIssue(Element element, String descriptor) {
        assert (element != null) : "Parameter 'element' of method 'createAssociatedIssue' must not be null";
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'createAssociatedIssue' must not be empty";
        assert (element != null && element instanceof NamedElement) : "Unexpected class in method 'createAssociatedIssue': " + element;
        return new NamedElementMoveRenameRefactoringIssue((NamedElement)element, descriptor, MoveRenameRefactoringDefinition.createDescription(this.getTargetRootDirectoryFqName(), this.getMoveToParentName(), this.m_newName));
    }

    @Override
    public String getTargetFqName(String nonMatchingFqName, IRefactoringAdapter refactoringAdapter) {
        assert (nonMatchingFqName != null && nonMatchingFqName.length() > 0) : "Parameter 'nonMatchingFqName' of method 'getTargetFqName' must not be empty";
        assert (refactoringAdapter != null) : "Parameter 'refactoringAdapter' of method 'getTargetFqName' must not be null";
        int pos = nonMatchingFqName.lastIndexOf(58);
        if (pos != -1) {
            String nextName = nonMatchingFqName.substring(pos + 1);
            String nextRenamedName = refactoringAdapter.getTargetElementName(nextName, this.getNewName(), this.getRefactoringElementType());
            String moveToParentFqName = refactoringAdapter.getMoveToParentFqName(this.getMoveToParentName(), this.getRefactoringElementType());
            return String.valueOf(this.getTargetRootDirectoryFqName()) + ":" + (!moveToParentFqName.isEmpty() ? String.valueOf(moveToParentFqName) + ":" : "") + nextRenamedName;
        }
        return null;
    }
}

