/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.foundation.propertyreader.IntProperty;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyDeleteRefactoringIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementDeleteRefactoringIssue;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import java.util.Date;
import java.util.List;

public final class DeleteRefactoringDefinition
extends RefactoringDefinition {
    public static final IIssueId ASSOCIATED_ISSUE_ID = CoreIssueId.DELETE_REFACTORING;
    private final boolean m_includeRecursiveElementChildren;
    private int m_numberOfAffectedParserDependencies = -1;

    public static String getDescription(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getDescription' must not be null";
        if (element instanceof NamedElement) {
            return "Delete '" + element.getPresentationName(true) + "'";
        }
        assert (element != null && element instanceof Dependency) : "Unexpected class in method 'getDescription': " + element;
        Dependency dependency = (Dependency)element;
        return "Delete [" + dependency.getDependencyInfo() + "] " + dependency.getUnderlyingFrom().getPresentationName(true) + " -> " + dependency.getUnderlyingTo().getPresentationName(true);
    }

    public DeleteRefactoringDefinition(NamedElement parent, Date date, String assignee, String description, Priority priority, boolean includeRecursiveElementChildren) {
        super(parent, date, assignee, description, priority);
        this.m_includeRecursiveElementChildren = includeRecursiveElementChildren;
    }

    @Property
    public boolean isIncludingRecursiveElementChildren() {
        return this.m_includeRecursiveElementChildren;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.DELETE;
    }

    @Override
    public String getProvider() {
        return "Core";
    }

    @Override
    public String getName() {
        return "Delete Refactoring";
    }

    @Override
    public String getShortName() {
        return "Delete";
    }

    @Override
    public IIssueId getAssociatedIssueId() {
        return ASSOCIATED_ISSUE_ID;
    }

    @Override
    public final String getInformation() {
        if (this.getStatus() == StatusInfo.Status.NOT_APPLICABLE) {
            return this.getStatusInfo().getInformation();
        }
        if (this.m_numberOfAffectedParserDependencies < 0) {
            return "";
        }
        return String.valueOf(this.m_numberOfAffectedParserDependencies) + (this.m_numberOfAffectedParserDependencies == 1 ? " dependency needs to be removed" : " dependencies need to be removed");
    }

    @Override
    public Issue createAssociatedIssue(Element element, String descriptor) {
        assert (element != null) : "Parameter 'element' of method 'createAssociatedIssue' must not be null";
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'createAssociatedIssue' must not be empty";
        String description = DeleteRefactoringDefinition.getDescription(element);
        if (element instanceof NamedElement) {
            return new NamedElementDeleteRefactoringIssue((NamedElement)element, descriptor, description);
        }
        assert (element != null && element instanceof Dependency) : "Unexpected class in method 'createAssociatedIssue': " + element;
        return new DependencyDeleteRefactoringIssue((Dependency)element, descriptor, description);
    }

    public void setNumberOfAffectedParserDependencies(int number) {
        this.m_numberOfAffectedParserDependencies = number;
    }

    public void incrementNumberOfAffectedParserDependencies(int number) {
        if (this.m_numberOfAffectedParserDependencies == -1) {
            this.m_numberOfAffectedParserDependencies = 0;
        }
        this.m_numberOfAffectedParserDependencies += number;
    }

    @IntProperty(undefinedValue=-1)
    public int getNumberOfAffectedParserDependencies() {
        return this.m_numberOfAffectedParserDependencies;
    }

    @Override
    public void reset(IIssue accessor) {
        this.m_numberOfAffectedParserDependencies = -1;
        super.reset(accessor);
    }

    @Override
    public List<IIssue> reset() {
        this.m_numberOfAffectedParserDependencies = -1;
        return super.reset();
    }
}

