/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.IPhysicalElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.ElementRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssignableToArtifactRefactoringDescriptor
extends ElementRefactoringDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssignableToArtifactRefactoringDescriptor.class);

    protected AssignableToArtifactRefactoringDescriptor() {
    }

    public abstract ElementType getType();

    @Override
    public final String getPresentationKind() {
        return this.getType().getPresentationName();
    }

    public boolean isRenamePossible(List<NamedElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isRenamePossible' must not be empty";
        return true;
    }

    public String getRelevantNamePartForRename(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getRelevantNamePartForRename' must not be empty";
        int fromPos = -1;
        int toPos = -1;
        switch (this.getType()) {
            case COMPONENT: {
                fromPos = name.lastIndexOf(47);
                toPos = name.lastIndexOf(46);
                break;
            }
            case TYPE: {
                String separator = this.getLanguage().getNamespaceSeparator();
                fromPos = name.lastIndexOf(separator);
                break;
            }
            default: {
                assert (false) : "Unhandled type: " + (Object)((Object)this.getType());
                break;
            }
        }
        if (fromPos == -1 && toPos == -1) {
            return name;
        }
        if (fromPos != -1 && toPos != -1) {
            return name.substring(fromPos + 1, toPos);
        }
        if (fromPos != -1) {
            return name.substring(fromPos + 1);
        }
        return name.substring(0, toPos);
    }

    @Override
    public final boolean isValidNameForRename(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'isValidNameForRename' must not be empty";
        char firstChar = name.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar)) {
            return false;
        }
        int i2 = 1;
        while (i2 < name.length()) {
            char c2 = name.charAt(i2);
            if (!Character.isJavaIdentifierPart(c2)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public final String getNewNameForRename(String name, String rename) {
        assert (this.isValidNameForRename(rename)) : "Not a valid name: " + rename;
        int pos = -1;
        switch (this.getType()) {
            case COMPONENT: {
                pos = name.lastIndexOf(46);
                break;
            }
            case TYPE: {
                break;
            }
            default: {
                assert (false) : "Unhandled type: " + (Object)((Object)this.getType());
                break;
            }
        }
        return pos != -1 ? String.valueOf(rename) + name.substring(pos) : rename;
    }

    public static final FilePath getFilePath(ProgrammingElement programmingElement) {
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'getFilePath' must not be null";
        FilePath filePath = programmingElement.getParent(FilePath.class, ParentMode.SELF_OR_FIRST_PARENT);
        if (filePath == null) {
            LOGGER.error("Unable to determine file path for: " + programmingElement.getFullyQualifiedName() + " [" + programmingElement.getClass().getName() + "]");
        }
        return filePath;
    }

    public List<StrictPair<FilePath, NamedElement>> getFilePathToPhysicalElementPairs(IAssignableToArtifact element, RefactoringType type) {
        assert (element != null) : "Parameter 'element' of method 'getFilePathToPhysicalElementPairs' must not be null";
        assert (type != null) : "Parameter 'type' of method 'getFilePathToPhysicalElementPairs' must not be null";
        NamedElement namedElement = element.getNamedElement();
        switch (this.getType()) {
            case TYPE: {
                assert (namedElement != null && namedElement instanceof LogicalProgrammingElement) : "Unexpected class in method 'getFilePathToPhysicalElementPairs': " + namedElement;
                List<? extends ProgrammingElement> logicalGroup = ((LogicalProgrammingElement)namedElement).getLogicalGroup();
                if (logicalGroup.isEmpty()) {
                    LOGGER.error("No programming elements in logical programming element: " + namedElement);
                    return Collections.emptyList();
                }
                if (logicalGroup.size() == 1) {
                    ProgrammingElement programmingElement = logicalGroup.get(0);
                    FilePath filePath = AssignableToArtifactRefactoringDescriptor.getFilePath(programmingElement);
                    return filePath != null ? Collections.singletonList(new StrictPair((Object)filePath, (Object)logicalGroup.get(0))) : Collections.emptyList();
                }
                ArrayList<StrictPair<FilePath, NamedElement>> pairs = new ArrayList<StrictPair<FilePath, NamedElement>>(logicalGroup.size());
                for (ProgrammingElement programmingElement : logicalGroup) {
                    FilePath nextFilePath = AssignableToArtifactRefactoringDescriptor.getFilePath(programmingElement);
                    if (nextFilePath == null) continue;
                    pairs.add((StrictPair<FilePath, NamedElement>)new StrictPair((Object)nextFilePath, (Object)programmingElement));
                }
                return pairs;
            }
            case COMPONENT: {
                assert (namedElement instanceof IPhysicalElement) : "Unexpected class in method 'getFilePathPhysicalElementPairs': " + namedElement;
                FilePath filePath = namedElement.getParent(FilePath.class, ParentMode.SELF_OR_FIRST_PARENT);
                if (filePath == null) {
                    LOGGER.error("Unable to determine file path for: " + namedElement.getFullyQualifiedName() + " [" + namedElement.getClass().getName() + "]");
                    return Collections.emptyList();
                }
                return Collections.singletonList(new StrictPair((Object)filePath, (Object)namedElement));
            }
        }
        assert (false) : "Unhandled element type: " + (Object)((Object)this.getType());
        return Collections.emptyList();
    }

    public static enum ElementType implements IStandardEnumeration
    {
        COMPONENT,
        TYPE;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

