/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class WorkspaceDependencyEdgeAdapter<T extends INode<NamedElement>>
extends EdgeAdapter<T> {
    private List<WorkspaceDependency> m_dependencies;

    public WorkspaceDependencyEdgeAdapter(T from, T to) {
        super(from, to);
    }

    @Override
    public int getNumberOfDependencies() {
        return this.m_dependencies.size();
    }

    @Override
    public int getWeight() {
        return this.getNumberOfDependencies();
    }

    @Override
    public int getNumberOfParserDependencies() {
        return 0;
    }

    @Override
    public void addDependency(Dependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'addDependency' must not be null";
        if (this.m_dependencies == null) {
            this.m_dependencies = new ArrayList<WorkspaceDependency>();
        }
        assert (dependency != null && dependency instanceof WorkspaceDependency) : "Unexpected class in method 'addDependency': " + dependency;
        this.m_dependencies.add((WorkspaceDependency)dependency);
    }

    @Override
    public List<WorkspaceDependency> getDependencies() {
        return this.m_dependencies != null ? Collections.unmodifiableList(this.m_dependencies) : Collections.emptyList();
    }

    @Override
    public WorkspaceDependency getFirstDependency() {
        return this.getNumberOfDependencies() >= 1 ? this.m_dependencies.get(0) : null;
    }

    @Override
    public EndpointType getEndpointType() {
        return EndpointType.WORKSPACE_DEPENDENCY;
    }
}

