/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IPhysicalElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import java.io.IOException;
import java.util.Collection;

public abstract class WorkspaceDependency
extends Dependency
implements INode.IEdge,
IPhysicalElement {
    private final IWorkspaceDependencyElement m_from;
    private IWorkspaceDependencyElement m_to;
    private AdditionalDependencyData m_dependencyData = new AdditionalDependencyData();

    public WorkspaceDependency(IWorkspaceDependencyElement from) {
        assert (from != null);
        this.m_from = from;
    }

    public WorkspaceDependency(IWorkspaceDependencyElement from, IWorkspaceDependencyElement to) {
        assert (from != null) : "Parameter 'from' of method 'WorkspaceDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'WorkspaceDependency' must not be null";
        this.m_from = from;
        this.m_to = to;
    }

    public void remove() {
        this.removeIssues();
        this.m_from.unlinkOutgoing(this);
        if (this.m_to != null) {
            this.m_to.unlinkIncoming(this);
        }
    }

    @Override
    public final RefactoringState getRefactoringState() {
        return RefactoringState.NONE;
    }

    @Override
    public boolean hasBeenDirectlyRefactored() {
        return false;
    }

    public final AdditionalDependencyData getAdditionalDependencyData() {
        return this.m_dependencyData;
    }

    public void setAdditionalDependencyData(AdditionalDependencyData data) {
        assert (data != null) : "Parameter 'data' of method 'setAdditionalDependencyData' must not be null";
        this.m_dependencyData = data;
    }

    public final String getToId() {
        return this.m_to.getId();
    }

    public final String getToName() {
        return this.m_to.getName();
    }

    @Override
    public final String toString() {
        return String.valueOf(this.m_from.getName()) + " -> " + (this.getTo() != null ? this.getTo().getName() : "'null' (" + this.getUnderlyingTo().getName() + ")");
    }

    public abstract IWorkspaceDependencyType getType();

    @Override
    public final NamedElement getUnderlyingFrom() {
        return (NamedElement)this.m_from.getUnderlyingObject();
    }

    @Override
    public final NamedElement getUnderlyingTo() {
        return (NamedElement)this.m_to.getUnderlyingObject();
    }

    public final void setTo(IWorkspaceDependencyElement to) {
        assert (to != null && to != this.m_from) : "Parameter 'to' of method 'setTo' must not be null or a self reference: " + to;
        assert (this.m_to != null) : "'m_to' of method 'setTo' must not be null";
        this.m_to.removeIncomingWorkspaceDependency(this);
        this.m_to = to;
        this.m_to.addIncomingWorkspaceDependency(this);
    }

    @Override
    public final IWorkspaceDependencyElement getFrom() {
        return this.m_from;
    }

    public abstract boolean isGenerated();

    public boolean isForInternalUse() {
        return false;
    }

    @Override
    public final IWorkspaceDependencyElement getTo() {
        return ((NamedElement)this.m_to.getUnderlyingObject()).isValid() ? this.m_to : null;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.write(this.m_to);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_to = reader.read(IWorkspaceDependencyElement.class, new SnapshotArgument[0]);
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return true;
    }

    @Override
    public final String getName() {
        assert (this.m_from != null) : "'m_from' of method 'getName' must not be null";
        StringBuilder builder = new StringBuilder();
        builder.append(((NamedElement)this.m_from.getUnderlyingObject()).getName());
        builder.append(" -> ");
        builder.append(((NamedElement)this.m_to.getUnderlyingObject()).getName());
        return builder.toString();
    }

    @Override
    public final String getShortName() {
        assert (this.m_from != null) : "'m_from' of method 'getName' must not be null";
        StringBuilder builder = new StringBuilder();
        builder.append(((NamedElement)this.m_from.getUnderlyingObject()).getShortName());
        builder.append(" -> ");
        builder.append(((NamedElement)this.m_to.getUnderlyingObject()).getShortName());
        return builder.toString();
    }

    @Override
    public final String getPresentationName(boolean inContext) {
        assert (this.m_from != null) : "'m_from' of method 'getPresentationName' must not be null";
        StringBuilder builder = new StringBuilder();
        builder.append(((NamedElement)this.m_from.getUnderlyingObject()).getPresentationName(inContext));
        builder.append(" -> ");
        builder.append(((NamedElement)this.m_to.getUnderlyingObject()).getPresentationName(inContext));
        return builder.toString();
    }

    @Override
    public final Element.IPropertiesManager getPropertiesManager() {
        assert (this.m_from != null) : "'m_from' of method 'getAdditionalElementInfoProvider' must not be null";
        return ((NamedElement)this.m_from.getUnderlyingObject()).getPropertiesManager();
    }

    @Override
    public final ElementWithIssues.IIssueManager getIssueManager() {
        assert (this.m_from != null) : "'m_from' of method 'getAdditionalElementInfoProvider' must not be null";
        return ((NamedElement)this.m_from.getUnderlyingObject()).getIssueManager();
    }

    @Override
    public final boolean isValid() {
        assert (this.m_from != null) : "'m_from' of method 'isValid' must not be null";
        return ((NamedElement)this.m_from.getUnderlyingObject()).isValid() && ((NamedElement)this.m_to.getUnderlyingObject()).isValid();
    }

    @Override
    @Property
    public boolean isExcluded() {
        return ((NamedElement)this.m_from.getUnderlyingObject()).isExcluded() || ((NamedElement)this.m_to.getUnderlyingObject()).isExcluded();
    }

    public boolean addIssueForUnresolvableTo() {
        return true;
    }

    @Override
    public final int getWeight() {
        return 1;
    }

    public static boolean collectionContainsDependency(Collection<WorkspaceDependency> dependencies, String toOrFromName, boolean isOutgoing) {
        assert (dependencies != null) : "Parameter 'dependencies' of method 'collectionContainsDepencency' must not be null";
        assert (toOrFromName != null && toOrFromName.length() > 0) : "Parameter 'toOrFromName' of method 'collectionContainsDepencency' must not be empty";
        return WorkspaceDependency.getDependency(dependencies, toOrFromName, isOutgoing, false) != null;
    }

    public static WorkspaceDependency getDependency(Collection<WorkspaceDependency> dependencies, String toOrFromName, boolean isOutgoing, boolean equalsIgnoreCase) {
        assert (dependencies != null) : "Parameter 'dependencies' of method 'collectionContainsDepencency' must not be null";
        assert (toOrFromName != null && toOrFromName.length() > 0) : "Parameter 'toOrFromName' of method 'collectionContainsDepencency' must not be empty";
        if (dependencies.isEmpty()) {
            return null;
        }
        for (WorkspaceDependency next : dependencies) {
            if (!(isOutgoing ? (equalsIgnoreCase ? next.getToName().equalsIgnoreCase(toOrFromName) : next.getToName().equals(toOrFromName)) : (equalsIgnoreCase ? next.getFrom().getName().equalsIgnoreCase(toOrFromName) : next.getFrom().getName().equals(toOrFromName)))) continue;
            return next;
        }
        return null;
    }

    public static class AdditionalDependencyData {
        private String m_version;
        private String m_languageOfEndpoint;

        public String getVersion() {
            return this.m_version;
        }

        public void setVersion(String version) {
            this.m_version = version;
        }

        public void setLanguageOfEndpoint(String languageOfEndpoint) {
            assert (languageOfEndpoint != null && languageOfEndpoint.length() > 0) : "Parameter 'languageOfEndpoint' of method 'setLanguageOfEndpoint' must not be empty";
            this.m_languageOfEndpoint = languageOfEndpoint;
        }

        public String getLanguageOfEndpoint() {
            return this.m_languageOfEndpoint;
        }

        public String toString() {
            return "AdditionalDependencyData [m_version=" + this.m_version + ", m_languageOfEndpoint=" + this.m_languageOfEndpoint + "]";
        }
    }

    public static interface IWorkspaceDependencyType
    extends IStandardEnumeration {
    }
}

