/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotDependency;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class UnresolvedWorkspaceDependencyElement
extends NamedElement
implements IWorkspaceDependencyElement {
    private final List<WorkspaceDependency> m_incomingWorkspaceDependencies = new ArrayList<WorkspaceDependency>();
    private String m_id;
    private String m_name;

    public UnresolvedWorkspaceDependencyElement(NamedElement parent) {
        super(parent);
    }

    public UnresolvedWorkspaceDependencyElement(NamedElement parent, String name, String id) {
        this(parent);
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'UnresolvedWorkspaceDependencyEndpoint' must not be empty";
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'UnresolvedWorkspaceDependencyEndpoint' must not be empty";
        this.m_name = name;
        this.m_id = id;
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return true;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_id);
        writer.writeString(this.m_name);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_id = reader.readString();
        this.m_name = reader.readString();
    }

    @Override
    public int getIndexOfOutgoingDependency(ISnapshotDependency dependency) {
        return 0;
    }

    @Override
    public void writeDependencyList(ISnapshotWriter snapshotWriter) throws IOException {
    }

    @Override
    public void readDependencyList(ISnapshotReader snapshotReader) throws IOException, ClassNotFoundException {
    }

    @Override
    public ISnapshotDependency getOutgoingDependencyAt(int index) {
        return null;
    }

    @Override
    public NamedElement getUnderlyingObject() {
        return this;
    }

    @Override
    public String getShortName() {
        return this.m_name;
    }

    @Override
    public final Collection<? extends INode.IEdge> getIncomingEdges() {
        return Collections.unmodifiableList(this.m_incomingWorkspaceDependencies);
    }

    @Override
    public Collection<? extends INode.IEdge> getOutgoingEdges() {
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public void addOutgoingWorkspaceDependency(WorkspaceDependency dependency) {
        assert (false) : "No reason to add an outgoing dependency to a unresolvedWorkspaceDependencyElement";
    }

    @Override
    public void addOutgoingWorkspaceDependencyAt(WorkspaceDependency dependency, int pos) {
        assert (false) : "No reason to add an outgoing dependency to a unresolvedWorkspaceDependencyElement";
    }

    @Override
    public void removeOutgoingWorkspaceDependency(WorkspaceDependency dependency) {
        assert (false) : "No reason to remove an outgoing dependency to a unresolvedWorkspaceDependencyElement";
    }

    @Override
    public void unlinkIncoming(WorkspaceDependency dep) {
        assert (dep != null) : "Parameter 'dep' of method 'unlinkIncoming' must not be null";
        this.m_incomingWorkspaceDependencies.remove(dep);
    }

    @Override
    public void unlinkOutgoing(WorkspaceDependency dep) {
        assert (dep != null) : "Parameter 'dep' of method 'unlinkOutgoing' must not be null";
    }

    @Override
    public void removeIncomingWorkspaceDependency(WorkspaceDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'removeIncomingWorkspaceDependency' must not be null";
        assert (this.m_incomingWorkspaceDependencies.contains(dependency)) : "Dependency not found: " + dependency;
        this.m_incomingWorkspaceDependencies.remove(dependency);
    }

    @Override
    public final void addIncomingWorkspaceDependency(WorkspaceDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'addIncomingWorkspaceDependency' must not be null";
        assert (!WorkspaceDependency.collectionContainsDependency(this.m_incomingWorkspaceDependencies, dependency.getFrom().getName(), false)) : "Dependency already added: " + dependency;
        this.m_incomingWorkspaceDependencies.add(dependency);
    }

    @Override
    public void remove() {
        this.clearIncomingWorkspaceDependencies();
        super.remove();
    }

    @Override
    public WorkspaceDependency getOutgoingWorkspaceDependency(IWorkspaceDependencyElement to) {
        return null;
    }

    @Override
    public boolean canAccess(IWorkspaceDependencyElement element) {
        return false;
    }

    @Override
    public List<IWorkspaceDependencyElement> getReferenced() {
        return Collections.emptyList();
    }

    @Override
    public void clearOutgoingWorkspaceDependencies() {
    }

    @Override
    public void clearIncomingWorkspaceDependencies() {
        ArrayList<WorkspaceDependency> incoming = new ArrayList<WorkspaceDependency>(this.m_incomingWorkspaceDependencies);
        for (WorkspaceDependency next : incoming) {
            this.removeIncomingWorkspaceDependency(next);
        }
    }

    @Override
    public List<WorkspaceDependency> getOutgoingWorkspaceDependencies() {
        return Collections.emptyList();
    }

    @Override
    public List<WorkspaceDependency> getIncomingWorkspaceDependencies() {
        return Collections.unmodifiableList(this.m_incomingWorkspaceDependencies);
    }

    @Override
    public boolean isModule() {
        return false;
    }
}

