/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public final class ParserDependencyNodeAdapterSet
extends NodeAdapterSet<ParserDependencyNodeAdapter> {
    private final Map<NamedElement, ParserDependencyNodeAdapter> m_namedElementToNodeAdapter;

    public ParserDependencyNodeAdapterSet(IWorkerContext workerContext, Collection<? extends NamedElement> namedElements, DependencyEndpointCollector collector, Predicate<ProgrammingElement> includeProgrammingElement, Predicate<ParserDependency> includeParserDependency) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'ParserDependencyNodeAdapterSet' must not be null";
        assert (namedElements != null) : "Parameter 'namedElements' of method 'ParserDependencyNodeAdapterSet' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'ParserDependencyNodeAdapterSet' must not be null";
        assert (includeProgrammingElement != null) : "Parameter 'includeProgrammingElement' of method 'ParserDependencyNodeAdapterSet' must not be null";
        assert (includeParserDependency != null) : "Parameter 'includeParserDependency' of method 'ParserDependencyNodeAdapterSet' must not be null";
        workerContext.setNumberOfSteps(1);
        this.m_namedElementToNodeAdapter = new THashMap(namedElements.size());
        for (NamedElement namedElement : namedElements) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            ParserDependencyNodeAdapter adapter = new ParserDependencyNodeAdapter(namedElement);
            ParserDependencyNodeAdapter previous = this.m_namedElementToNodeAdapter.put(namedElement, adapter);
            assert (previous == null) : "'previous' of method 'ParserDependencyNodeAdapterSet' must be null: " + adapter;
        }
        workerContext.beginBlockOfWork(this.m_namedElementToNodeAdapter.size());
        for (Map.Entry entry : this.m_namedElementToNodeAdapter.entrySet()) {
            NamedElement nextNamedElement = (NamedElement)entry.getKey();
            ParserDependencyNodeAdapter fromNodeAdapter = (ParserDependencyNodeAdapter)entry.getValue();
            Collection<ProgrammingElement> programmingElements = collector.getProgrammingElements(nextNamedElement);
            for (ProgrammingElement next : programmingElements) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                if (!includeProgrammingElement.test(next)) continue;
                Iterator<ParserDependency> iterator = next.getDependencyIterator();
                while (iterator.hasNext()) {
                    ProgrammingElement toProgrammingElement;
                    ParserDependencyNodeAdapter toNodeAdapter;
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    ParserDependency nextDependency = iterator.next();
                    if (nextDependency.getFrom() != next || !includeParserDependency.test(nextDependency) || (toNodeAdapter = ParserDependencyNodeAdapterSet.getNodeAdapter(toProgrammingElement = nextDependency.getTo(), collector, this.m_namedElementToNodeAdapter)) == null || !collector.addDependency(fromNodeAdapter.getUnderlyingObject(), toNodeAdapter.getUnderlyingObject(), nextDependency)) continue;
                    Object edgeAdapter = fromNodeAdapter.findOutgoingEdge(toNodeAdapter);
                    if (edgeAdapter == null) {
                        edgeAdapter = new ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>(fromNodeAdapter, toNodeAdapter);
                        fromNodeAdapter.addOutgoindEdge((EdgeAdapter<? extends NodeAdapter>)edgeAdapter);
                    }
                    ((EdgeAdapter)edgeAdapter).addDependency(nextDependency);
                }
            }
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
    }

    @Override
    protected Map<NamedElement, ParserDependencyNodeAdapter> getNamedElementToNodeAdapter() {
        return this.m_namedElementToNodeAdapter;
    }

    @Override
    protected ParserDependencyNodeAdapter createNodeAdapter(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'createNodeAdapter' must not be null";
        return new ParserDependencyNodeAdapter(namedElement);
    }

    @Override
    protected EdgeAdapter<? extends NodeAdapter> createEdgeAdapter(ParserDependencyNodeAdapter from, ParserDependencyNodeAdapter to) {
        assert (from != null) : "Parameter 'from' of method 'createEdgeAdapter' must not be null";
        assert (to != null) : "Parameter 'to' of method 'createEdgeAdapter' must not be null";
        return new ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>(from, to);
    }

    public Set<NamedElement> getNamedElements() {
        return Collections.unmodifiableSet(this.m_namedElementToNodeAdapter.keySet());
    }
}

