/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public abstract class NodeAdapter
implements INode<NamedElement> {
    private final NamedElement m_namedElement;
    private int m_level = 0;
    private int m_cycleIndex = -1;

    public NodeAdapter(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'NodeAadpter' must not be null";
        this.m_namedElement = namedElement;
    }

    @Override
    public final NamedElement getUnderlyingObject() {
        return this.m_namedElement;
    }

    @Override
    public final String getName() {
        return this.m_namedElement.getName();
    }

    public final void setLevel(int level) {
        this.m_level = level;
    }

    public final int getLevel() {
        return this.m_level;
    }

    public final void setCycleIndex(int cycleIndex) {
        this.m_cycleIndex = cycleIndex;
    }

    public final int getCycleIndex() {
        return this.m_cycleIndex;
    }

    protected abstract Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> getIn();

    protected abstract Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> getOut();

    protected abstract <K extends NodeAdapter, V extends EdgeAdapter<? extends NodeAdapter>> boolean addToIn(K var1, V var2);

    protected abstract <K extends NodeAdapter, V extends EdgeAdapter<? extends NodeAdapter>> boolean addToOut(K var1, V var2);

    protected abstract void lastIncomingEdgeRemoved();

    protected abstract void lastOutgoingEdgeRemoved();

    protected boolean isDerived(EdgeAdapter<? extends NodeAdapter> edge) {
        assert (edge != null) : "Parameter 'edge' of method 'isDerived' must not be null";
        return true;
    }

    public final boolean hasDependencies() {
        Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> out = this.getOut();
        Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> in = this.getIn();
        return out != null && !out.isEmpty() || in != null && !in.isEmpty();
    }

    public final int getNumberOfIncomingEdges() {
        Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> in = this.getIn();
        return in == null ? 0 : in.size();
    }

    public final int getNumberOfOutgoingEdges() {
        Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> out = this.getOut();
        return out == null ? 0 : out.size();
    }

    @Override
    public Collection<? extends EdgeAdapter<? extends NodeAdapter>> getOutgoingEdges() {
        Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> out = this.getOut();
        return out != null ? Collections.unmodifiableCollection(out.values()) : Collections.emptySet();
    }

    @Override
    public Collection<? extends EdgeAdapter<? extends NodeAdapter>> getIncomingEdges() {
        Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> in = this.getIn();
        return in != null ? Collections.unmodifiableCollection(in.values()) : Collections.emptySet();
    }

    public final <T extends EdgeAdapter<? extends NodeAdapter>> T findIncomingEdge(INode<?> from) {
        assert (from != null) : "Parameter 'from' of method 'findIncomingEdge' must not be null";
        Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> in = this.getIn();
        return (T)(in != null ? in.get(from) : null);
    }

    public final <T extends EdgeAdapter<? extends NodeAdapter>> T findOutgoingEdge(INode<?> to) {
        assert (to != null) : "Parameter 'to' of method 'findOutgoingEdge' must not be null";
        Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> out = this.getOut();
        return (T)(out != null ? out.get(to) : null);
    }

    protected final void addIncomingEdge(EdgeAdapter<? extends NodeAdapter> edge) {
        assert (edge != null) : "Parameter 'edge' of method 'addIncomingEdge' must not be null";
        assert (edge.getTo() == this) : "Not an incoming edge : " + edge;
        boolean success = this.addToIn(edge.getFrom(), edge);
        assert (success) : "Already added to incoming: " + edge;
    }

    public final void addOutgoindEdge(EdgeAdapter<? extends NodeAdapter> edge) {
        assert (edge != null) : "Parameter 'edge' of method 'addOutgoindEdge' must not be null";
        assert (edge.getFrom() == this) : "Not an outgoing edge: " + edge;
        boolean success = this.addToOut(edge.getTo(), edge);
        assert (success) : "Already added to outgoing: " + edge;
        edge.getTo().addIncomingEdge(edge);
    }

    public final void removeIncomingEdge(EdgeAdapter<? extends NodeAdapter> edge) {
        assert (edge != null) : "Parameter 'edge' of method 'removeIncomingEdge' must not be null";
        Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> in = this.getIn();
        assert (in != null) : "Parameter 'm_in' of method 'removeIncomingEdge' must not be null";
        EdgeAdapter<? extends NodeAdapter> removed = in.remove(edge.getFrom());
        assert (removed == edge) : "Edge does not match: " + removed + " / " + edge;
        if (in.isEmpty()) {
            this.lastIncomingEdgeRemoved();
        }
    }

    public final void removeOutgoingEdge(EdgeAdapter<? extends NodeAdapter> edge) {
        assert (edge != null) : "Parameter 'edge' of method 'removeOutgoingEdge' must not be null";
        Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> out = this.getOut();
        assert (out != null) : "Parameter 'm_out' of method 'removeOutgoingEdge' must not be null";
        EdgeAdapter<? extends NodeAdapter> removed = out.remove(edge.getTo());
        assert (removed == edge) : "Edge does not match: " + removed + " / " + edge;
        if (out.isEmpty()) {
            this.lastOutgoingEdgeRemoved();
        }
    }

    public final Set<EdgeAdapter<? extends NodeAdapter>> removeEdges(boolean derivedOnly) {
        boolean removeEdge;
        Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> in = this.getIn();
        Map<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> out = this.getOut();
        if (in == null && out == null) {
            return Collections.emptySet();
        }
        THashSet removedEdges = new THashSet();
        if (in != null) {
            for (Map.Entry<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> nextInEntry : in.entrySet()) {
                EdgeAdapter<? extends NodeAdapter> nextInEdge = nextInEntry.getValue();
                removeEdge = true;
                if (derivedOnly) {
                    removeEdge = this.isDerived(nextInEdge);
                }
                if (!removeEdge) continue;
                nextInEdge.getFrom().removeOutgoingEdge(nextInEdge);
                removedEdges.add(nextInEdge);
            }
            this.lastIncomingEdgeRemoved();
        }
        if (out != null) {
            for (Map.Entry<? extends NodeAdapter, ? extends EdgeAdapter<? extends NodeAdapter>> nextOutEntry : out.entrySet()) {
                EdgeAdapter<? extends NodeAdapter> nextOutEdge = nextOutEntry.getValue();
                removeEdge = true;
                if (derivedOnly) {
                    removeEdge = this.isDerived(nextOutEdge);
                }
                if (!removeEdge) continue;
                nextOutEdge.getTo().removeIncomingEdge(nextOutEdge);
                removedEdges.add(nextOutEdge);
            }
            this.lastOutgoingEdgeRemoved();
        }
        return removedEdges;
    }

    public final int hashCode() {
        return this.m_namedElement.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodeAdapter other = (NodeAdapter)obj;
        return this.m_namedElement.equals(other.m_namedElement);
    }

    public String toString() {
        return "[" + this.m_namedElement.getClass().getSimpleName() + "] " + this.m_namedElement.getName() + " <<level:" + this.m_level + (this.m_cycleIndex != -1 ? " cycle group:" + this.m_cycleIndex : "") + ">>";
    }
}

