/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.HashSupport;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.IFile;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNameContributor;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.ILogicalElement;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.LogicalStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementProxy;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class LogicalProgrammingElement
extends NamedElement
implements IAssignableToArtifact,
ILogicalElement {
    private final ProgrammingElement m_element;
    private String m_fqNamePart;

    public static final boolean includeInLogicalDomain(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'includeInLogicalDomain' must not be null";
        return element.canBelongToNamespace() && !element.isExcluded() && !element.getRefactoringState().hasBeenDeleted();
    }

    protected static List<ProgrammingElement> getDirectProgrammingElementChildren(ProgrammingElement programmingElement) {
        return LogicalProgrammingElement.getDirectProgrammingElementChildren(programmingElement, false);
    }

    protected static List<ProgrammingElement> getDirectProgrammingElementChildren(ProgrammingElement programmingElement, boolean considerGhosts) {
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'getDirectProgrammingElementChildren' must not be null";
        assert (LogicalProgrammingElement.includeInLogicalDomain(programmingElement)) : "Not included: " + programmingElement;
        ArrayList<ProgrammingElement> directChildren = new ArrayList<ProgrammingElement>();
        for (NamedElement e2 : programmingElement.getChildren()) {
            if (e2 instanceof ProgrammingElement) {
                directChildren.add((ProgrammingElement)e2);
                continue;
            }
            if (!(e2 instanceof NamedElementProxy)) continue;
            directChildren.add((ProgrammingElement)((NamedElementProxy)e2).getElement());
        }
        if (directChildren.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ProgrammingElement> children = new ArrayList<ProgrammingElement>(directChildren.size());
        for (ProgrammingElement next : directChildren) {
            if (!LogicalProgrammingElement.includeInLogicalDomain(next)) continue;
            if (considerGhosts && next.isGhost()) {
                children.addAll(LogicalProgrammingElement.getDirectProgrammingElementChildren(next, true));
                continue;
            }
            children.add(next);
        }
        return children;
    }

    protected LogicalProgrammingElement(NamedElement parent, ProgrammingElement element) {
        super(parent);
        assert (element != null) : "Parameter 'element' of method 'ProgrammingElementProxy' must not be null";
        assert (LogicalProgrammingElement.includeInLogicalDomain(element)) : "Not included: " + element;
        this.m_element = element;
    }

    public abstract List<? extends LogicalProgrammingElement> getAllChildren();

    @Override
    public final NamedElement getNamedElement() {
        return this;
    }

    public final void setFqNamePart(String fqNamePart) {
        assert (fqNamePart != null) : "Parameter 'fqNamePart' of method 'setFqNamePart' must not be null";
        this.m_fqNamePart = fqNamePart;
    }

    @Override
    public boolean ignoreIssues() {
        for (ProgrammingElement programmingElement : this.getLogicalGroup()) {
            if (programmingElement.ignoreIssues()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final String getShortName() {
        return this.m_element.getShortName();
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        if (this.m_fqNamePart == null) {
            this.m_fqNamePart = this.m_element.getFullyQualifiedNamePart();
            if (this.m_element.hasMultipleDefinitions()) {
                String fqName = this.m_element.getFullyQualifiedName();
                this.m_fqNamePart = String.valueOf(this.m_fqNamePart) + HashSupport.MD5.getHexString(fqName);
            }
        }
        return this.m_fqNamePart;
    }

    @Override
    public final String getPresentationName(boolean shortName) {
        return this.m_element.getPresentationName(shortName);
    }

    @Property
    public final String getFullyQualifiedTypeName() {
        return this.m_element instanceof IType ? ((IType)((Object)this.m_element)).getFullyQualifiedTypeName() : "";
    }

    @Override
    public final String getImageResourceName() {
        return this.m_element.getImageResourceName();
    }

    @Override
    public final String getName() {
        return this.m_element.getName();
    }

    @Override
    public final boolean isDefinedInEnclosingElement() {
        return this.m_element.isDefinedInEnclosingElement();
    }

    @Override
    public final boolean isExternal() {
        return this.m_element.isExternal();
    }

    @Override
    public final boolean isExcluded() {
        return this.m_element.isExcluded();
    }

    @Override
    public final boolean ignoreInModelRepresentation() {
        return false;
    }

    @Override
    public final IStructureItem getStructureItem() {
        return LogicalStructureItem.LOGICAL_PROGRAMMING_ELEMENT;
    }

    @Override
    public final String getDescription() {
        return this.m_element.getDescription();
    }

    public final ProgrammingElement getPrimaryProgrammingElement() {
        return this.m_element;
    }

    public List<? extends ProgrammingElement> getLogicalGroup() {
        List<? extends ProgrammingElement> logicalGroup = this.m_element.getLogicalGroupInternal();
        assert (logicalGroup.contains(this.m_element)) : "Unexpected element in logical group of 1 element: " + logicalGroup.get(0) + "\nexpected:\n" + this.m_element;
        if (logicalGroup.size() == 1) {
            return logicalGroup;
        }
        ArrayList<ProgrammingElement> processedLogicalGroup = new ArrayList<ProgrammingElement>(logicalGroup.size());
        for (ProgrammingElement programmingElement : logicalGroup) {
            if (!LogicalProgrammingElement.includeInLogicalDomain(programmingElement)) continue;
            processedLogicalGroup.add(programmingElement);
        }
        return processedLogicalGroup;
    }

    public final List<? extends ProgrammingElement> getLogicalGroupRecursively() {
        ArrayList<ProgrammingElement> result = new ArrayList<ProgrammingElement>();
        result.addAll(this.getLogicalGroup());
        for (LogicalProgrammingElement logicalProgrammingElement : this.getAllChildren()) {
            result.addAll(logicalProgrammingElement.getLogicalGroupRecursively());
        }
        return result;
    }

    @Override
    public final int getLineNumber() {
        return this.m_element.getLineNumber();
    }

    protected abstract LogicalProgrammingElement create(ProgrammingElement var1);

    @Override
    public final NamedElement resolveByFullyQualifiedNamePart(String namePart) {
        assert (namePart != null) : "Parameter 'namePart' of method 'resolveOriginalByFullyQualifiedNamePart' must not be null";
        boolean found = false;
        for (ProgrammingElement programmingElement : this.getLogicalGroup()) {
            for (ProgrammingElement nextChild : LogicalProgrammingElement.getDirectProgrammingElementChildren(programmingElement)) {
                if (!namePart.equals(nextChild.getFullyQualifiedNamePart())) continue;
                found = true;
                LogicalProgrammingElement created = this.create(nextChild);
                if (created == null) continue;
                return created;
            }
        }
        assert (!found) : "Could not create logical programming element for '" + namePart + "' of " + this.toString();
        return null;
    }

    @Override
    public NamedElement resolveOriginalByFullyQualifiedNamePart(String namePart) {
        return this.resolveByFullyQualifiedNamePart(namePart);
    }

    public final int hashCode() {
        return this.m_element.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LogicalProgrammingElement other = (LogicalProgrammingElement)obj;
        return this.m_element.equals(other.m_element);
    }

    @Override
    public final String getArchitectureFilterName() {
        NamedElement parent = this.getParent();
        if (!(parent instanceof LogicalProgrammingElement)) {
            IArchitectureFilterNamePrefixProvider provider = this.getParent(IArchitectureFilterNamePrefixProvider.class, new Class[0]);
            assert (provider != null) : "'provider' of method 'getArchitectureFilterName' must not be null";
            IArchitectureFilterNameContributor contributor = this.getParent(IArchitectureFilterNameContributor.class, new Class[0]);
            return String.valueOf(provider.getArchitectureFilterNamePrefix()) + (contributor != null ? contributor.getArchitectureFilterNamePart() : "") + this.getShortName().replace("/", " slash").replace("*", " star ");
        }
        return IAssignableToArtifact.super.getArchitectureFilterName();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitLogicalProgrammingElement(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append(StringUtility.LINE_SEPARATOR);
        for (ProgrammingElement programmingElement : this.getLogicalGroup()) {
            builder.append("PE of Logical group: [");
            builder.append(Integer.toHexString(programmingElement.hashCode()));
            builder.append("] ");
            builder.append(programmingElement.getFullyQualifiedName());
            builder.append(" [");
            builder.append(programmingElement.getClass().getName());
            builder.append("]");
            IFile file = programmingElement.getParent(IFile.class, ParentMode.FIRST_PARENT);
            if (file != null) {
                builder.append(" - File: " + file.getIdentifyingPath());
            }
            builder.append(StringUtility.LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitLogicalProgrammingElement(LogicalProgrammingElement var1);
    }
}

