/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.foundation.collections.MultipleValueMap;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.ILogicalElement;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.LogicalStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.programming.ILogicalProgrammingElementContainer;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogicalNamespace
extends NamedElementContainer
implements ILogicalElement,
IRecursiveElement,
ILogicalProgrammingElementContainer {
    public static final String NAMESPACE_FRAGMENT = "NamespaceFragment";
    public static final String NAMESPACE_FRAGMENT_PART = "NamespaceFragmentPart";
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicalNamespace.class);
    private final ArrayList<NamedElement> m_sourceNamespaces = new ArrayList(5);
    private final String m_shortName;
    private Set<ProgrammingElement> m_programmingElements;
    private MultipleValueMap<String, ProgrammingElement> m_fqNamePartToPrimaryProgrammingElement;
    private boolean m_isValid = true;

    public LogicalNamespace(NamedElement parent, String shortName) {
        super(parent);
        assert (shortName != null) : "Parameter 'name' of method 'LogicalNamespace' must not be null";
        this.m_shortName = shortName.intern();
    }

    @Override
    public final String getSeparator() {
        Language language = this.getLanguage();
        assert (language != null) : "'language' of method 'getSeparator' must not be null";
        return language.getNamespaceSeparator();
    }

    @Override
    public final NamedElement getNamedElement() {
        return this;
    }

    public abstract IMetricLevel getMetricLevel();

    public final boolean isGlobal() {
        return this.m_shortName.equals(this.getGlobalNamespaceName());
    }

    public final boolean isEmpty() {
        return this.getChildren().isEmpty() && (this.m_programmingElements == null || this.m_programmingElements.isEmpty());
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        return super.getFullyQualifiedNamePart();
    }

    @Override
    public final RefactoringState getRefactoringState() {
        for (NamedElement next : this.m_sourceNamespaces) {
            if (next.getRepresentative().getRefactoringState() != RefactoringState.REFACTORED) continue;
            return RefactoringState.REFACTORED;
        }
        return RefactoringState.NONE;
    }

    @Override
    public final boolean hasBeenDirectlyRefactored() {
        for (NamedElement next : this.m_sourceNamespaces) {
            if (!next.getRepresentative().hasBeenDirectlyRefactored()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Property
    public final String getInformation() {
        IDomainRoot context = this.getParent(IDomainRoot.class, new Class[0]);
        return context != null ? context.getDomainInfo() : "";
    }

    public final List<TFile> getPhysicalCorrespondents() {
        if (this.m_sourceNamespaces.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TFile> correspondents = new ArrayList<TFile>(this.m_sourceNamespaces.size());
        for (NamedElement next : this.m_sourceNamespaces) {
            TFile nextCorrespondent = ((ISourceNamespace)((Object)next.getOriginal())).getPhysicalCorrespondent();
            if (nextCorrespondent == null) continue;
            correspondents.add(nextCorrespondent);
        }
        return correspondents;
    }

    protected void reduceToPrimaryProgrammingElements(Set<ProgrammingElement> programmingElements) {
        assert (programmingElements != null) : "Parameter 'programmingElements' of method 'getPrimaryProgrammingElements' must not be null";
    }

    protected void handleDuplicateFqNamePart(MultipleValueMap<String, ProgrammingElement> fqNamePartToPrimaryProgrammingElement, String duplicateFqNamePart) {
        assert (fqNamePartToPrimaryProgrammingElement != null && !fqNamePartToPrimaryProgrammingElement.isEmpty()) : "Parameter 'fqNamePartToPrimaryProgrammingElement' of method 'handleDuplicateFqdNamePart' must not be empty";
        assert (duplicateFqNamePart != null && duplicateFqNamePart.length() > 0) : "Parameter 'duplicateFqNamePart' of method 'handleDuplicateFqdNamePart' must not be empty";
        Collection programmingElements = fqNamePartToPrimaryProgrammingElement.get((Object)duplicateFqNamePart);
        fqNamePartToPrimaryProgrammingElement.removeValuesOf((Object)duplicateFqNamePart);
        for (ProgrammingElement next : programmingElements) {
            IWorkspaceDependencyElement nextWorkspaceDependencyElement = next.getParent(IWorkspaceDependencyElement.class, new Class[0]);
            boolean error = false;
            if (nextWorkspaceDependencyElement != null) {
                error = fqNamePartToPrimaryProgrammingElement.put((Object)(String.valueOf(nextWorkspaceDependencyElement.getNamedElement().getShortName()) + Element.INNER_NAME_PARTS_SEPARATOR + duplicateFqNamePart), (Object)next);
            }
            if (!error && nextWorkspaceDependencyElement != null) continue;
            LOGGER.error("Unable to resolve duplicate fq name part '" + duplicateFqNamePart + "' in namespace '" + this.getName() + "' [" + (Object)((Object)this.getDomain()) + "]\n" + next.getDebugInfo());
        }
    }

    @Override
    public final void finishModification() {
        THashSet duplicateFqNameParts = new THashSet();
        this.m_sourceNamespaces.trimToSize();
        if (this.m_programmingElements != null) {
            this.reduceToPrimaryProgrammingElements(this.m_programmingElements);
            this.m_fqNamePartToPrimaryProgrammingElement = new MultipleValueMap(this.m_programmingElements.size());
            for (ProgrammingElement programmingElement : this.m_programmingElements) {
                String nextFqNamePart = programmingElement.getFullyQualifiedNamePart();
                if (!this.m_fqNamePartToPrimaryProgrammingElement.put((Object)nextFqNamePart, (Object)programmingElement)) continue;
                duplicateFqNameParts.add(nextFqNamePart);
            }
            this.m_fqNamePartToPrimaryProgrammingElement.compact();
        }
        for (String string : duplicateFqNameParts) {
            this.handleDuplicateFqNamePart(this.m_fqNamePartToPrimaryProgrammingElement, string);
        }
        if (this.m_fqNamePartToPrimaryProgrammingElement != null) {
            for (String string : this.m_fqNamePartToPrimaryProgrammingElement.keySet()) {
                LogicalProgrammingElement nextLogicalProgrammingElement = this.create(this, (ProgrammingElement)this.m_fqNamePartToPrimaryProgrammingElement.getFirst((Object)string));
                nextLogicalProgrammingElement.setFqNamePart(string);
                this.addChild(nextLogicalProgrammingElement);
            }
        }
        super.finishModification();
    }

    public abstract boolean isSystemScope();

    @Override
    public final String getShortName() {
        return this.m_shortName;
    }

    private void appendShortName(StringBuilder builder) {
        assert (builder != null) : "Parameter 'builder' of method 'appendShortName' must not be null";
        NamedElement parent = this.getParent();
        if (parent != null && this.getClass().isAssignableFrom(parent.getClass())) {
            ((LogicalNamespace)parent).appendShortName(builder);
            builder.append(this.getSeparator());
        }
        builder.append(this.getShortName());
    }

    @Override
    public final String getName() {
        StringBuilder builder = new StringBuilder();
        this.appendShortName(builder);
        return builder.toString();
    }

    @Override
    public final String getImageResourceName() {
        if (this.isPart()) {
            return NAMESPACE_FRAGMENT_PART;
        }
        return NAMESPACE_FRAGMENT;
    }

    @Override
    public final String getImageResource() {
        return NAMESPACE_FRAGMENT;
    }

    @Override
    public final String getImageResourcePart() {
        return NAMESPACE_FRAGMENT_PART;
    }

    @Override
    public final boolean ignoreInModelRepresentation() {
        return false;
    }

    @Override
    public final IStructureItem getStructureItem() {
        return LogicalStructureItem.LOGICAL_NAMESPACE;
    }

    protected abstract LogicalProgrammingElement create(LogicalNamespace var1, ProgrammingElement var2);

    @Override
    public final NamedElement resolveByFullyQualifiedNamePart(String namePart) {
        Collection programmingElements;
        assert (namePart != null) : "Parameter 'namePart' of method 'findInAllChildrenByFullyQualifiedNamePart' must not be null";
        for (NamedElement nextChild : super.getChildren()) {
            if (!namePart.equals(nextChild.getFullyQualifiedNamePart())) continue;
            return nextChild;
        }
        if (this.m_fqNamePartToPrimaryProgrammingElement != null && !(programmingElements = this.m_fqNamePartToPrimaryProgrammingElement.get((Object)namePart)).isEmpty()) {
            LogicalProgrammingElement created = this.create(this, (ProgrammingElement)programmingElements.stream().findFirst().get());
            assert (created != null) : "'created' of method 'findInAllChildrenByFullyQualifiedNamePart' must not be null";
            return created;
        }
        return null;
    }

    @Override
    public NamedElement resolveOriginalByFullyQualifiedNamePart(String namePart) {
        return this.resolveByFullyQualifiedNamePart(namePart);
    }

    protected abstract String getGlobalNamespaceName();

    protected abstract String getNamespaceSeparator();

    public void addProgrammingElement(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'addProgrammingElement' must not be null";
        if (this.m_programmingElements == null) {
            this.m_programmingElements = new LinkedHashSet<ProgrammingElement>();
        }
        boolean success = this.m_programmingElements.add(element);
        assert (success) : "Duplicate: " + element;
    }

    public final Collection<ProgrammingElement> getLogicalElementsWithSameName(LogicalProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'getLogicalElementsWithSameName' must not be null";
        return this.m_fqNamePartToPrimaryProgrammingElement.get((Object)element.getFullyQualifiedNamePart());
    }

    private boolean programmingElementsMatch(LogicalProgrammingElement logicalProgrammingElement, ProgrammingElement programmingElement) {
        assert (logicalProgrammingElement != null) : "Parameter 'logicalProgrammingElement' of method 'programmingElementsMatch' must not be null";
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'programmingElementsMatch' must not be null";
        for (ProgrammingElement programmingElement2 : logicalProgrammingElement.getLogicalGroup()) {
            if (programmingElement2 != programmingElement) continue;
            return true;
        }
        return false;
    }

    private boolean process(LogicalProgrammingElement logicalProgrammingElement, ProgrammingElement programmingElementToBeMatched, List<LogicalProgrammingElement> collector) {
        assert (logicalProgrammingElement != null) : "Parameter 'logicalProgrammingElement' of method 'process' must not be null";
        assert (programmingElementToBeMatched != null) : "Parameter 'programmingElementToBeMatched' of method 'process' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'process' must not be null";
        collector.add(logicalProgrammingElement);
        if (this.programmingElementsMatch(logicalProgrammingElement, programmingElementToBeMatched)) {
            return true;
        }
        for (NamedElement namedElement : logicalProgrammingElement.getAllChildren()) {
            if (!(namedElement instanceof LogicalProgrammingElement) || !this.process((LogicalProgrammingElement)namedElement, programmingElementToBeMatched, collector)) continue;
            return true;
        }
        return false;
    }

    private List<LogicalProgrammingElement> collectLogicalProgrammingElements(NamedElement parent, ProgrammingElement programmingElement) {
        assert (parent != null) : "Parameter 'parent' of method 'collectLogicalProgrammingElements' must not be null";
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'collectLogicalProgrammingElements' must not be null";
        ArrayList<LogicalProgrammingElement> path = new ArrayList<LogicalProgrammingElement>();
        for (NamedElement namedElement : parent.getAllChildren()) {
            if (!(namedElement instanceof LogicalProgrammingElement)) continue;
            if (this.process((LogicalProgrammingElement)namedElement, programmingElement, path)) break;
            path.clear();
        }
        return path;
    }

    public List<LogicalProgrammingElement> getPath(ProgrammingElement programmingElement) {
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'find' must not be null";
        if (this.m_programmingElements != null) {
            boolean found = false;
            block0: for (ProgrammingElement next : this.m_programmingElements) {
                if (found) break;
                if (next == programmingElement) {
                    found = true;
                    continue;
                }
                for (ProgrammingElement nextChild : next.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                    if (nextChild != programmingElement && !nextChild.getDefinitions().contains(programmingElement)) continue;
                    found = true;
                    continue block0;
                }
            }
            if (found) {
                return this.collectLogicalProgrammingElements(this, programmingElement);
            }
        }
        return Collections.emptyList();
    }

    @Override
    @Property
    public final boolean isPart() {
        return this.m_programmingElements == null || this.m_programmingElements.isEmpty();
    }

    @Override
    @Property
    public final boolean isMixable() {
        return this.isPart() && this.getChildren().size() == 1 && this.getChildren().get(0) instanceof IRecursiveElement;
    }

    @Override
    @Property
    public final boolean isExternal() {
        return this.getParent().isExternal();
    }

    public final List<ProgrammingElement> getProgrammingElements() {
        if (this.m_programmingElements == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ProgrammingElement>(this.m_programmingElements);
    }

    public final void connect(ISourceNamespace sourceNamespace) {
        assert (sourceNamespace != null) : "Parameter 'sourceNamespace' of method 'connect' must not be null";
        if (this.isSystemScope()) {
            sourceNamespace.setSystemNamespace(this);
        } else {
            sourceNamespace.setModuleNamespace(this);
        }
        NamedElement original = sourceNamespace.getNamedElement().getOriginal();
        assert (original != null && original instanceof ISourceNamespace) : "Unexpected class in method 'connect': " + original;
        assert (!this.m_sourceNamespaces.contains(original)) : "'m_sourceNamespaces' of method 'connect' already contains: " + original;
        this.m_sourceNamespaces.add(original);
    }

    @Override
    public boolean isValid() {
        return this.m_isValid;
    }

    public final void disconnect() {
        for (NamedElement next : this.m_sourceNamespaces) {
            if (this.isSystemScope()) {
                ((ISourceNamespace)((Object)next.getRepresentative())).setSystemNamespace(null);
                continue;
            }
            ((ISourceNamespace)((Object)next.getRepresentative())).setModuleNamespace(null);
        }
        this.m_programmingElements = null;
        this.m_isValid = false;
    }

    public final boolean hasSourceNamespaces() {
        return !this.m_sourceNamespaces.isEmpty();
    }

    public final List<ISourceNamespace> getRepresentativeSourceNamespaces() {
        return Collections.unmodifiableList(this.m_sourceNamespaces.stream().map(n2 -> n2.getRepresentative()).map(ISourceNamespace.class::cast).collect(Collectors.toList()));
    }

    public final List<ISourceNamespace> getOriginalSourceNamespaces() {
        return Collections.unmodifiableList(this.m_sourceNamespaces.stream().map(ISourceNamespace.class::cast).collect(Collectors.toList()));
    }

    public final List<LogicalNamespace> getNonPartLogicalNamespaces() {
        ArrayList<LogicalNamespace> nonParts = new ArrayList<LogicalNamespace>();
        for (LogicalNamespace next : this.getChildrenRecursively(LogicalNamespace.class, new Class[0])) {
            if (next.isPart()) continue;
            nonParts.add(next);
        }
        return nonParts;
    }

    @Override
    public final String getArchitectureFilterNamePart() {
        if (this.isGlobal()) {
            return "";
        }
        String part = this.getName().replace(this.getNamespaceSeparator(), "/");
        return part.isEmpty() ? part : String.valueOf(part) + "/";
    }

    @Override
    public final String getArchitectureFilterName() {
        IArchitectureFilterNamePrefixProvider provider = this.getParent(IArchitectureFilterNamePrefixProvider.class, new Class[0]);
        assert (provider != null) : "'provider' of method 'getArchitectureFilterName' must not be null";
        if (this.isGlobal()) {
            return String.valueOf(provider.getArchitectureFilterNamePrefix()) + "*";
        }
        return String.valueOf(provider.getArchitectureFilterNamePrefix()) + this.getArchitectureFilterNamePart() + "**";
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitLogicalNamespace(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n");
        for (NamedElement next : this.m_sourceNamespaces) {
            builder.append("Original source namespace: ").append(next);
            builder.append("\n");
            NamedElement representative = next.getRepresentative();
            if (next == representative) continue;
            builder.append("-> Representative: ").append(representative);
            builder.append("\n");
        }
        return builder.toString();
    }

    public static interface ISourceNamespace {
        public NamedElement getNamedElement();

        public RefactoringState getRefactoringState();

        public String getFullyQualifiedNamePart();

        public LogicalNamespace getModuleNamespace();

        public void setModuleNamespace(LogicalNamespace var1);

        public LogicalNamespace getSystemNamespace();

        public void setSystemNamespace(LogicalNamespace var1);

        public TFile getPhysicalCorrespondent();

        default public String getNamespaceName() {
            return this.getNamedElement().getName();
        }

        public boolean contributesToLogicalNamespaces();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitLogicalNamespace(LogicalNamespace var1);
    }
}

