/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.IIssueAffectedElementType;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;

public final class IssueAffectedElementType
extends Enum<IssueAffectedElementType>
implements IIssueAffectedElementType {
    public static final /* enum */ IssueAffectedElementType NAMED_ELEMENT_ISSUE = new IssueAffectedElementType(new Class[]{NamedElementIssue.class}, "Element");
    public static final /* enum */ IssueAffectedElementType DEPENDENCY_ISSUE = new IssueAffectedElementType(new Class[]{DependencyIssue.class}, "Dependency");
    private final Class<?>[] m_issueClasses;
    private final String m_presentationName;
    private static final /* synthetic */ IssueAffectedElementType[] ENUM$VALUES;

    static {
        ENUM$VALUES = new IssueAffectedElementType[]{NAMED_ELEMENT_ISSUE, DEPENDENCY_ISSUE};
    }

    private IssueAffectedElementType(Class<?>[] issueClasses, String presentationName) {
        assert (issueClasses != null && issueClasses.length > 0) : "Parameter 'issueClasses' of method 'IssueAffectedElementType' must not be empty";
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'IssueType' must not be empty";
        this.m_issueClasses = issueClasses;
        this.m_presentationName = presentationName;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    @Override
    public boolean matches(Class<? extends Issue> issueClass) {
        assert (issueClass != null) : "Parameter 'issueClass' of method 'matches' must not be null";
        Class<?>[] classArray = this.m_issueClasses;
        int n2 = this.m_issueClasses.length;
        int n3 = 0;
        while (n3 < n2) {
            Class<? extends Issue> nextClass = classArray[n3];
            if (nextClass.isAssignableFrom(issueClass)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static IssueAffectedElementType getMatchingType(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'matchesType' must not be null";
        IssueAffectedElementType[] issueAffectedElementTypeArray = IssueAffectedElementType.values();
        int n2 = issueAffectedElementTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IssueAffectedElementType next = issueAffectedElementTypeArray[n3];
            if (next.matches(issue.getClass())) {
                return next;
            }
            ++n3;
        }
        assert (false) : "No matching type found for " + issue;
        return null;
    }

    public static IssueAffectedElementType[] values() {
        IssueAffectedElementType[] issueAffectedElementTypeArray = ENUM$VALUES;
        int n2 = issueAffectedElementTypeArray.length;
        IssueAffectedElementType[] issueAffectedElementTypeArray2 = new IssueAffectedElementType[n2];
        System.arraycopy(ENUM$VALUES, 0, issueAffectedElementTypeArray2, 0, n2);
        return issueAffectedElementTypeArray2;
    }

    public static IssueAffectedElementType valueOf(String string) {
        return Enum.valueOf(IssueAffectedElementType.class, string);
    }
}

