/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.IncludeDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.IncludeDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Map;

public final class IncludeDependencyNodeAdapterSet
extends NodeAdapterSet<IncludeDependencyNodeAdapter> {
    private final Map<NamedElement, IncludeDependencyNodeAdapter> m_namedElementToNodeAdapter;

    public IncludeDependencyNodeAdapterSet(IWorkerContext workerContext, Collection<? extends NamedElement> namedElements, DependencyEndpointCollector collector) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'IncludeDependencyNodeAdapterSet' must not be null";
        assert (namedElements != null) : "Parameter 'namedElements' of method 'IncludeDependencyNodeAdapterSet' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'IncludeDependencyNodeAdapterSet' must not be null";
        workerContext.setNumberOfSteps(1);
        this.m_namedElementToNodeAdapter = new THashMap(namedElements.size());
        for (NamedElement namedElement : namedElements) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            IncludeDependencyNodeAdapter adapter = new IncludeDependencyNodeAdapter(namedElement);
            IncludeDependencyNodeAdapter previous = this.m_namedElementToNodeAdapter.put(namedElement, adapter);
            assert (previous == null) : "'previous' of method 'IncludeDependencyNodeAdapterSet' must be null: " + adapter;
        }
        workerContext.beginBlockOfWork(this.m_namedElementToNodeAdapter.size());
        for (Map.Entry entry : this.m_namedElementToNodeAdapter.entrySet()) {
            NamedElement nextNamedElement = (NamedElement)entry.getKey();
            IncludeDependencyNodeAdapter fromNodeAdapter = (IncludeDependencyNodeAdapter)entry.getValue();
            for (NamedElement nextChild : nextNamedElement.getChildren(NamedElement.class)) {
                Object edgeAdapter;
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                IncludeDependencyNodeAdapter toNodeAdapter = IncludeDependencyNodeAdapterSet.getNodeAdapter(nextChild, collector, this.m_namedElementToNodeAdapter);
                if (toNodeAdapter == null || !collector.addDependency(fromNodeAdapter.getUnderlyingObject(), toNodeAdapter.getUnderlyingObject(), null) || (edgeAdapter = fromNodeAdapter.findOutgoingEdge(toNodeAdapter)) != null) continue;
                edgeAdapter = new IncludeDependencyEdgeAdapter<IncludeDependencyNodeAdapter>(fromNodeAdapter, toNodeAdapter);
                fromNodeAdapter.addOutgoindEdge((EdgeAdapter<? extends NodeAdapter>)edgeAdapter);
            }
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
    }

    @Override
    protected Map<NamedElement, IncludeDependencyNodeAdapter> getNamedElementToNodeAdapter() {
        return this.m_namedElementToNodeAdapter;
    }

    @Override
    protected IncludeDependencyNodeAdapter createNodeAdapter(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'createNodeAdapter' must not be null";
        return new IncludeDependencyNodeAdapter(namedElement);
    }

    @Override
    protected EdgeAdapter<? extends NodeAdapter> createEdgeAdapter(IncludeDependencyNodeAdapter from, IncludeDependencyNodeAdapter to) {
        assert (from != null) : "Parameter 'from' of method 'createEdgeAdapter' must not be null";
        assert (to != null) : "Parameter 'to' of method 'createEdgeAdapter' must not be null";
        return new IncludeDependencyEdgeAdapter<IncludeDependencyNodeAdapter>(from, to);
    }
}

