/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNameProvider;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceRoot;

public abstract class ExternalLogicalNamespaceRoot
extends LogicalNamespaceRoot
implements IArchitectureFilterNameProvider {
    private final NamedElement m_external;
    private final boolean m_isSystemScope;

    public ExternalLogicalNamespaceRoot(NamedElement parent, NamedElement external, boolean isSystemScope) {
        super(parent);
        assert (external != null) : "Parameter 'external' of method 'ExternalLogicalNamespaceRoot' must not be null";
        assert (external.isExternal()) : "Must be 'external': " + external;
        this.m_external = external;
        this.m_isSystemScope = isSystemScope;
    }

    @Override
    public final boolean isSystemScope() {
        return this.m_isSystemScope;
    }

    @Override
    public final NamedElement getPhysicalElement() {
        return this.m_external;
    }

    @Override
    public IDomainRoot.Domain getDomain() {
        return this.m_isSystemScope ? IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE : IDomainRoot.Domain.LOGICAL_MODULE_SCOPE;
    }

    public final NamedElement getExternal() {
        return this.m_external;
    }

    @Override
    public final Language getLanguage() {
        return this.m_external.getLanguage();
    }

    @Override
    @Property
    public final boolean isExternal() {
        return true;
    }

    @Override
    public String getShortName() {
        return this.m_external.getShortName();
    }

    @Override
    public String getImageResourceName() {
        return "ExternalLogicalNamespaces";
    }

    @Override
    @Property
    public final String getDomainInfo() {
        return "External [" + this.getDomain().getPresentationName() + " " + this.getLanguage().getPresentationName() + "]";
    }

    @Override
    public String getArchitectureFilterNamePrefix() {
        return String.valueOf(this.getShortName()) + "/";
    }

    @Override
    public final String getArchitectureFilterName() {
        return String.valueOf(this.getArchitectureFilterNamePrefix()) + "**";
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitExternalLogicalNamespaceRoot(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitExternalLogicalNamespaceRoot(ExternalLogicalNamespaceRoot var1);
    }
}

