/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ExternalLogicalNamespaceRoot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ExternalElementContainer
extends ExternalLogicalNamespaceRoot {
    private final String m_name;
    private List<NamedElement> m_duplicates = null;

    public ExternalElementContainer(NamedElement parent, NamedElement external, String name) {
        super(parent, external, false);
        assert (parent != null) : "Parameter 'parent' of method 'ExternalElementContainer' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ExternalElementContainer' must not be empty";
        this.m_name = name;
    }

    @Override
    public String getImageResourceName() {
        return this.getExternal().getImageResourceName();
    }

    public void addNameDuplicate(NamedElement dup) {
        assert (dup != null) : "Parameter 'dup' of method 'addNameDuplicate' must not be null";
        if (this.m_duplicates == null) {
            this.m_duplicates = new ArrayList<NamedElement>(2);
        }
        this.m_duplicates.add(dup);
    }

    public List<NamedElement> getNameDuplicates() {
        return this.m_duplicates == null ? Collections.emptyList() : Collections.unmodifiableList(this.m_duplicates);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getShortName() {
        return this.m_name;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return this.m_name;
    }

    @Override
    public String getPresentationName(boolean parentIsPresented) {
        return this.m_name;
    }

    @Override
    public String getDescription() {
        return this.getExternal().getDescription();
    }

    @Override
    public String getArchitectureFilterNamePrefix() {
        IArchitectureFilterNamePrefixProvider provider = this.getParent(IArchitectureFilterNamePrefixProvider.class, new Class[0]);
        assert (provider != null) : "'provider' of method 'getArchitectureFilterNamePrefix' must not be null";
        return String.valueOf(provider.getArchitectureFilterNamePrefix()) + this.m_name + '/';
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitExternalElementContainer(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitExternalElementContainer(ExternalElementContainer var1);
    }
}

