/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.Issue;

final class ArchitectureCheckIssueVisitor
implements IVirtualModel.IIssueVisitor {
    private final Type m_type;
    private final IProviderId m_provider;
    private boolean m_hasIssue;

    ArchitectureCheckIssueVisitor(Type type, IProviderId provider) {
        assert (type != null) : "Parameter 'type' of method 'ArchitectureCheckIssueVisitor' must not be null";
        this.m_type = type;
        this.m_provider = provider;
    }

    @Override
    public boolean visit(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'visit' must not be null";
        if (this.m_type.getCategory().equals((Object)issue.getId().getCategory()) && (this.m_provider == null || this.m_provider.equals(issue.getProvider())) && !issue.isIgnored()) {
            this.m_hasIssue = true;
            return false;
        }
        return true;
    }

    boolean hasIssue() {
        return this.m_hasIssue;
    }

    static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type VIOLATION = new Type(IssueCategory.ARCHITECTURE_VIOLATION);
        public static final /* enum */ Type DEPRECATION = new Type(IssueCategory.ARCHITECTURE_DEPRECATION);
        private final IssueCategory m_category;
        private static final /* synthetic */ Type[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Type[]{VIOLATION, DEPRECATION};
        }

        private Type(IssueCategory category) {
            assert (category != null) : "Parameter 'category' of method 'Type' must not be null";
            this.m_category = category;
        }

        IssueCategory getCategory() {
            return this.m_category;
        }

        public static Type[] values() {
            Type[] typeArray = ENUM$VALUES;
            int n2 = typeArray.length;
            Type[] typeArray2 = new Type[n2];
            System.arraycopy(ENUM$VALUES, 0, typeArray2, 0, n2);
            return typeArray2;
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

