/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingEdge;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AggregatedDependency
extends Element
implements IParserDependenciesProvidingEdge {
    private final List<ParserDependency> m_dependencies = new ArrayList<ParserDependency>();
    private final NamedElement m_from;
    private final NamedElement m_to;

    public AggregatedDependency(NamedElement from, NamedElement to) {
        assert (from != null) : "Parameter 'from' of method 'AggregatedDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'AggregatedDependency' must not be null";
        this.m_from = from;
        this.m_to = to;
    }

    public AggregatedDependency(ParserDependency dep) {
        assert (dep != null) : "Parameter 'dep' of method 'AggregatedDependency' must not be empty";
        this.m_from = dep.getFrom();
        this.m_to = dep.getTo();
        this.add(dep);
    }

    @Override
    public final RefactoringState getRefactoringState() {
        return RefactoringState.NONE;
    }

    @Override
    public final boolean hasBeenDirectlyRefactored() {
        return false;
    }

    @Override
    public final NamedElement getFromEndPoint() {
        return this.m_from;
    }

    @Override
    public final NamedElement getToEndPoint() {
        return this.m_to;
    }

    public boolean includeInCycleAnalysis() {
        return !this.m_dependencies.stream().allMatch(d2 -> !d2.includeInDependencyAnalysis());
    }

    @Override
    public final boolean isValid() {
        return this.m_from.isValid() && this.m_to.isValid();
    }

    @Override
    public final String getName() {
        return String.valueOf(this.m_from.getName()) + " -> " + this.m_to.getName();
    }

    @Override
    public final String getShortName() {
        return String.valueOf(this.m_from.getShortName()) + " -> " + this.m_to.getShortName();
    }

    @Override
    @Property
    public final boolean isExcluded() {
        return this.m_from.isExcluded() || this.m_to.isExcluded();
    }

    @Override
    public final boolean ignoreIssues() {
        return this.m_from.ignoreIssues() && this.m_to.ignoreIssues();
    }

    public final List<ParserDependency> getParserDependencies() {
        return Collections.unmodifiableList(this.m_dependencies);
    }

    @Override
    public final Element.IPropertiesManager getPropertiesManager() {
        return this.m_from.getPropertiesManager();
    }

    public final void add(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'add' must not be null";
        this.m_dependencies.add(dependency);
    }

    @Override
    public final int getLineNumber() {
        return this.m_dependencies.size() == 1 ? this.m_dependencies.get(0).getLineNumber() : -1;
    }

    public final int getNumberOfDependencies() {
        return this.m_dependencies.size();
    }

    public final Dependency getFirstDependency() {
        return this.m_dependencies.size() >= 1 ? (Dependency)this.m_dependencies.get(0) : null;
    }

    public final String getDependencyInfo() {
        if (this.m_dependencies.size() == 1) {
            return this.m_dependencies.get(0).getDependencyInfo();
        }
        return String.valueOf(this.m_dependencies.size()) + " references";
    }

    @Override
    public final int getNumberOfParserDependencies() {
        return this.getNumberOfDependencies();
    }

    @Override
    public final ParserDependency getFirstParserDependency() {
        return !this.m_dependencies.isEmpty() ? this.m_dependencies.get(0) : null;
    }
}

