/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.plugin;

import com.hello2morrow.foundation.persistence.IObjectReader;
import com.hello2morrow.foundation.persistence.IObjectWriter;
import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssueWithDescription;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.plugin.PluginIssueId;
import java.io.IOException;

public final class PluginDependencyIssue
extends DependencyIssueWithDescription {
    private static final String LINE = "line";
    private static final String ID = "id";
    private PluginIssueId m_id;
    private int m_line;

    public PluginDependencyIssue() {
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeOther(ID, (Object)this.m_id);
        writer.writeInt(LINE, this.m_line);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        reader.readOther(ID, PluginIssueId.class, id -> {
            PluginIssueId pluginIssueId = this.m_id = id;
        });
        this.m_line = reader.readInt(LINE);
    }

    public PluginDependencyIssue(PluginIssueId id, Dependency dep, String description, int line) {
        super(dep, description);
        assert (id != null) : "Parameter 'id' of method 'PluginDependencyIssue' must not be null";
        assert (IIssueId.PatternEditMode.DEPENDENCY.equals((Object)id.getPatternEditMode()));
        this.m_id = id;
        this.m_line = line;
    }

    @Override
    public String getKey() {
        return String.valueOf(super.getKey()) + ":" + this.getProvider().getStandardName();
    }

    @Override
    public IIssueId getId() {
        return this.m_id;
    }

    @Override
    public IProviderId getProvider() {
        return this.m_id.getProvider();
    }

    @Override
    public int getLineNumber() {
        return this.m_line <= 0 ? super.getLineNumber() : this.m_line;
    }
}

