/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.plugin;

import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginConfiguration;
import de.schlichtherle.truezip.file.TFile;

public final class PluginConfigurationFile
extends ModifiableFile
implements ISoftwareSystemDefinitionElement {
    private final SonargraphPluginConfiguration m_configuration;
    private final String m_pluginId;

    public static String getFileName(String pluginId) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'getFileName' must not be empty";
        return String.valueOf(pluginId) + CoreFileType.PLUGIN_CONFIGURATION.getDefaultExtension();
    }

    public PluginConfigurationFile(NamedElement parent, TFile file, IModifiablePathListener listener, String pluginId, SonargraphPluginConfiguration configuration) {
        super(parent, file, listener);
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'PluginConfigurationFile' must not be empty";
        this.m_pluginId = pluginId;
        this.m_configuration = configuration;
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.PLUGIN_CONFIGURATION;
    }

    public String getPluginId() {
        return this.m_pluginId;
    }

    public SonargraphPluginConfiguration getPluginConfiguration() {
        return this.m_configuration;
    }

    @Property
    public boolean isEnabled() {
        return this.m_configuration != null ? this.m_configuration.isEnabled() : false;
    }

    public void setModified() {
        this.resetTimestamp();
        this.modified();
    }
}

