/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path.scm;

import com.hello2morrow.foundation.persistence.IObjectReader;
import com.hello2morrow.foundation.persistence.IObjectWriter;
import com.hello2morrow.foundation.persistence.IPersistable;
import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingLink;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TemporalCouplingModel
extends NamedElement {
    private static final String NODES = "nodes";
    private TemporalCouplingNode[] m_nodes;

    public TemporalCouplingModel(NamedElement parent) {
        super(parent);
    }

    public TemporalCouplingModel(NamedElement parent, TemporalCouplingNode[] nodes) {
        super(parent);
        assert (nodes != null) : "Parameter 'nodes' of method 'TemporalCouplingModel' must not be null";
        this.m_nodes = nodes;
    }

    public List<TemporalCouplingLink> getTemporalCouplingFor(SourceFile source) {
        assert (source != null);
        TemporalCouplingNode targetNode = null;
        TemporalCouplingNode[] temporalCouplingNodeArray = this.m_nodes;
        int n2 = this.m_nodes.length;
        int n3 = 0;
        while (n3 < n2) {
            TemporalCouplingNode node = temporalCouplingNodeArray[n3];
            if (node.getSourceFile() == source) {
                targetNode = node;
                break;
            }
            ++n3;
        }
        if (targetNode == null) {
            return null;
        }
        int[] links = targetNode.getLinks();
        ArrayList<TemporalCouplingLink> result = new ArrayList<TemporalCouplingLink>(links.length / 2);
        int i2 = 0;
        while (i2 < links.length) {
            SourceFile targetSource = this.m_nodes[links[i2]].getSourceFile();
            TemporalCouplingLink link = new TemporalCouplingLink(targetSource, links[i2 + 1]);
            result.add(link);
            i2 += 2;
        }
        if (result.size() == 0) {
            return null;
        }
        result.sort((a2, b2) -> b2.getWeight() - a2.getWeight());
        return result;
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeOwnedObjects(NODES, (IPersistable[])this.m_nodes);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        this.m_nodes = (TemporalCouplingNode[])reader.readOwnedObjects(NODES, TemporalCouplingNode.class);
    }

    @Override
    public String getShortName() {
        return "TemporalCouplingModel";
    }
}

