/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;

public abstract class SourceFile
extends FilePath {
    private int m_commentLines = -1;
    private int m_totalLines = -1;
    private int m_linesOfCode = -1;
    private int m_codeCommentLines = -1;

    protected SourceFile(NamedElement parent) {
        super(parent);
    }

    public SourceFile(NamedElement parent, TFile file) {
        super(parent, file);
    }

    protected SourceFile(NamedElement parent, String path) {
        super(parent, path);
    }

    public FilePath getPhysicalFilePath() {
        return this;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_commentLines);
        writer.writeInt(this.m_totalLines);
        writer.writeInt(this.m_linesOfCode);
        writer.writeInt(this.m_codeCommentLines);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_commentLines = reader.readInt();
        this.m_totalLines = reader.readInt();
        this.m_linesOfCode = reader.readInt();
        this.m_codeCommentLines = reader.readInt();
    }

    public final void setCommentLines(int n2) {
        this.m_commentLines = n2;
    }

    public final void setTotalLines(int n2) {
        this.m_totalLines = n2;
    }

    public final void setLinesOfCode(int n2) {
        this.m_linesOfCode = n2;
    }

    @IntProperty(undefinedValue=-1)
    public final int getCommentLines() {
        return this.m_commentLines;
    }

    @IntProperty(undefinedValue=-1)
    public final int getTotalLines() {
        return this.m_totalLines;
    }

    @IntProperty(undefinedValue=-1)
    public final int getLinesOfCode() {
        return this.m_linesOfCode;
    }

    @IntProperty(undefinedValue=-1)
    public final int getCodeCommentLines() {
        return this.m_codeCommentLines;
    }

    public final void setCodeCommentLines(int n2) {
        this.m_codeCommentLines = n2;
    }

    @Override
    public boolean ignoreInModelRepresentation() {
        return false;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitSourceFile(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitSourceFile(SourceFile var1);
    }
}

