/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.foundation.file.IDirectoryType;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import de.schlichtherle.truezip.file.TFile;

public abstract class SoftwareSystemDirectoryPath
extends DirectoryPath {
    private boolean m_correspondingFileExists;

    public SoftwareSystemDirectoryPath(NamedElement parent, TFile file) {
        super(parent, file);
        this.m_correspondingFileExists = file.exists();
    }

    public SoftwareSystemDirectoryPath(NamedElement parent, String relativeDirectoryPath) {
        super(parent, relativeDirectoryPath);
        TFile file = this.getFile();
        this.m_correspondingFileExists = file != null && file.exists();
    }

    public abstract IDirectoryType getDirectoryType();

    public final boolean correspondingFileExists() {
        return this.m_correspondingFileExists;
    }

    public final void enforceExistence(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'enforceExistence' must not be null";
        this.checkExistence();
        if (!this.correspondingFileExists()) {
            TFile directory = this.getFile();
            assert (directory != null) : "Parameter 'directory' of method 'enforceExistence' must not be null";
            if (!directory.exists() || !directory.isDirectory()) {
                if (!directory.mkdir()) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_DIRECTORY, "Failed to create software system directory '" + this.getIdentifyingPath() + "'", new Object[0]);
                }
                this.checkExistence();
            }
        }
    }

    public final void checkExistence() {
        TFile file = this.getFile();
        this.m_correspondingFileExists = file != null && file.exists();
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    protected final void lastChildRemoved() {
    }

    @Override
    public final boolean removeOnLastChildRemoval() {
        return false;
    }

    @Override
    public final boolean ignoreInModelRepresentation() {
        return true;
    }

    @Override
    public final void accept(NamedElement.INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
    }
}

