/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactoringTarget;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.IWorkspaceFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IWorkspaceFilterNameProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IRootDirectoryKindProvider;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotRootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.List;

public abstract class RootDirectoryPath
extends DirectoryPath
implements IRefactoringTarget,
IWorkspaceFilterNamePrefixProvider,
IWorkspaceFilterNameProvider,
IBaseDirectory,
ISnapshotRootDirectoryPath {
    private IModelServiceProvider m_msp;
    private int m_numberOfFiles = -1;
    private StrictPair<IBaseDirectory, String> m_baseDirectoryAndOriginalPath;
    private boolean m_enabled = true;

    public RootDirectoryPath(NamedElement parent) {
        super(parent);
    }

    public RootDirectoryPath(IModelServiceProvider msp, NamedElement parent, TFile file) {
        super(parent, file);
        assert (msp != null) : "Parameter 'msp' of method 'RootDirectoryPath' must not be null";
        this.m_msp = msp;
    }

    @Override
    public final boolean isRootDirectory() {
        return true;
    }

    @Override
    public boolean mayContainSourceFiles() {
        return true;
    }

    protected final IModelServiceProvider getModelServiceProvider() {
        return this.m_msp;
    }

    @Override
    public IBaseDirectory getBaseDirectory() {
        if (this.m_baseDirectoryAndOriginalPath != null) {
            return (IBaseDirectory)this.m_baseDirectoryAndOriginalPath.getFirst();
        }
        return super.getBaseDirectory();
    }

    @Override
    public final void setModelServiceProvider(IModelServiceProvider msp) {
        assert (msp != null) : "Parameter 'msp' of method 'setModelServiceProvider' must not be null";
        this.m_msp = msp;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeBoolean(this.m_enabled);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_enabled = reader.readBoolean();
    }

    public final int getNumberOfFiles() {
        return this.m_numberOfFiles;
    }

    public final void initializeCounter() {
        this.m_numberOfFiles = 0;
    }

    public final void clearCounter() {
        this.m_numberOfFiles = -1;
    }

    public final void incrementNumberOfFiles() {
        assert (this.m_numberOfFiles != -1) : "Has not been initialized";
        ++this.m_numberOfFiles;
    }

    @Override
    public final String getShortName() {
        String path = this.getName();
        int pos = path.lastIndexOf(47);
        if (pos != -1) {
            return path.substring(pos + 1);
        }
        return path;
    }

    @Override
    public final String getName() {
        return this.m_baseDirectoryAndOriginalPath == null ? super.getName() : (String)this.m_baseDirectoryAndOriginalPath.getSecond();
    }

    @Override
    public final String getIdentifyingPath() {
        return this.m_baseDirectoryAndOriginalPath == null ? super.getName() : (String)this.m_baseDirectoryAndOriginalPath.getSecond();
    }

    public void setOrigin(IBaseDirectory baseDirectory, String realPath) {
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'setOrigin' must not be null";
        assert (realPath != null && realPath.length() > 0) : "Parameter 'realPath' of method 'setOrigin' must not be empty";
        this.m_baseDirectoryAndOriginalPath = new StrictPair((Object)baseDirectory, (Object)realPath);
    }

    public final void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public final boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public RootDirectoryPath getOriginal() {
        return (RootDirectoryPath)super.getOriginal(this.m_msp);
    }

    @Override
    public final RootDirectoryPath getRepresentative() {
        return (RootDirectoryPath)super.getRepresentative(this.m_msp);
    }

    @Override
    public final List<NamedElement> getChildren() {
        return super.getChildren(this.m_msp);
    }

    @Override
    public final NamedElement getParent() {
        return super.getParent(this.m_msp);
    }

    @Override
    public final Element.IPropertiesManager getPropertiesManager() {
        return this.m_msp.getPropertiesManager();
    }

    @Override
    public final ElementWithIssues.IIssueManager getIssueManager() {
        return this.m_msp.getIssueManager();
    }

    @Override
    public final IVirtualModel getCurrentModel() {
        return this.m_msp.getCurrentModel();
    }

    @Override
    public String getImageResourceName() {
        if (!this.isArtificial() && FileUtility.isArchiveOrContainedInArchive((TFile)this.getFile())) {
            return "RootArchivePath";
        }
        return RootDirectoryPath.class.getSimpleName();
    }

    @Override
    public final String getPresentationName(boolean parentIsPresented) {
        return this.getIdentifyingPath();
    }

    @Override
    public final String getWorkspaceFilterNamePrefix() {
        if (this.isExternal()) {
            return "";
        }
        NamedElement parent = this.getParent();
        assert (parent != null) : "Parameter 'parent' of method 'getWorkspaceFilterNamePrefix' must not be null";
        String name = this.getName();
        if (name.startsWith("./")) {
            name = name.substring("./".length());
        } else if (name.startsWith("../")) {
            name = name.substring("..".length() + "/".length());
        } else if (name.equals(".")) {
            return String.valueOf(parent.getShortName()) + "/";
        }
        return String.valueOf(parent.getShortName()) + "/" + name + "/";
    }

    @Override
    @Property
    public final String getWorkspaceFilterName() {
        if (this.isExternal()) {
            return "";
        }
        return String.valueOf(this.getWorkspaceFilterNamePrefix()) + "**";
    }

    @Override
    public final TFile getDirectoryFile() {
        return this.getFile();
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return this.getName();
    }

    @Override
    protected void lastChildRemoved() {
    }

    @Override
    public boolean removeOnLastChildRemoval() {
        return false;
    }

    protected final String getDirectoryPathKind() {
        IRootDirectoryKindProvider provider = this.getParent(IRootDirectoryKindProvider.class, new Class[0]);
        return provider != null ? provider.getRootDirectoryPathTypePresentationKind() : "";
    }

    protected String getFileKind(boolean lowerCase) {
        IRootDirectoryKindProvider fileKindProvider = this.getParent(IRootDirectoryKindProvider.class, new Class[0]);
        return fileKindProvider != null ? fileKindProvider.getRootDirectoryPathFileTypePresentationKind(lowerCase) : "";
    }

    @Override
    public String getInformation() {
        int numberOfFiles = this.getNumberOfFiles();
        return numberOfFiles != -1 ? String.valueOf(NumberUtility.format((Number)numberOfFiles)) + " " + this.getFileKind(true) + " file(s) found" : "";
    }

    @Override
    public final String getPresentationKind() {
        StringBuilder builder = new StringBuilder();
        String fileKind = this.getFileKind(false);
        if (!fileKind.isEmpty()) {
            builder.append(fileKind);
        }
        builder.append(" Root ");
        String pathKind = this.getDirectoryPathKind();
        if (!pathKind.isEmpty()) {
            builder.append(pathKind);
        } else {
            builder.append("Directory");
        }
        return builder.toString();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitRootDirectoryPath(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String toString() {
        boolean isDisabled;
        boolean isClone = this.getOriginal() != this;
        boolean bl2 = isDisabled = !this.isEnabled();
        if (isClone || isDisabled) {
            StringBuilder builder = new StringBuilder();
            if (isClone) {
                builder.append("[Clone] ");
            }
            if (isDisabled) {
                builder.append("[Disabled] ");
            }
            builder.append(super.toString());
            return builder.toString();
        }
        return super.toString();
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n");
        builder.append("Enabled: ");
        builder.append(this.m_enabled);
        builder.append("\n");
        builder.append("Base directory: ");
        builder.append(this.getDirectoryFile().getAbsolutePath());
        return builder.toString();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitRootDirectoryPath(RootDirectoryPath var1);
    }
}

