/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.DirectoryScanner;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ModifiableDirectoryPathCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ModifiableFileDeltaDetector
implements DirectoryScanner.IFileConsumer {
    private final IWorkerContext m_workerContext;
    private final OperationResult m_result;
    private final List<String> m_ignore;
    private final ModifiableFileDelta m_delta;
    private Set<IModifiableFile> m_existingFiles;
    private Set<IModifiableDirectory> m_existingDirectories;
    private IProvider m_provider;

    public ModifiableFileDeltaDetector(IWorkerContext workerContext, OperationResult result, List<String> ignore, ModifiableFileDelta delta) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'ModifiableFileDeltaDetector' must not be null";
        assert (result != null) : "Parameter 'result' of method 'ModifiableFileDeltaDetector' must not be null";
        assert (ignore != null) : "Parameter 'ignore' of method 'ModifiableFileDeltaDetector' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'ModifiableFileDeltaDetector' must not be null";
        this.m_workerContext = workerContext;
        this.m_result = result;
        this.m_ignore = ignore;
        this.m_delta = delta;
    }

    public ModifiableFileDelta getDelta() {
        return this.m_delta;
    }

    public void detect(IProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'detect' must not be null";
        this.m_provider = provider;
        this.m_delta.initialize(this.m_provider.getKey(), this.m_provider.getFileTypes());
        DirectoryPath directoryPath = this.m_provider.getDirectoryPath();
        Class<?>[] stopClasses = this.m_provider.getStopClasses();
        TFile directory = directoryPath.getFile();
        boolean isScannable = true;
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                this.m_result.addWarning((OperationResult.IMessageCause)IOMessageCause.NOT_A_DIRECTORY);
                isScannable = false;
            } else if (!directory.canRead()) {
                this.m_result.addWarning((OperationResult.IMessageCause)IOMessageCause.NO_PERMISSION);
                isScannable = false;
            }
        } else {
            isScannable = false;
        }
        this.m_existingFiles = new HashSet<IModifiableFile>();
        this.m_existingDirectories = new HashSet<IModifiableDirectory>();
        for (IModifiableFile iModifiableFile : directoryPath.getChildrenRecursively(IModifiableFile.class, stopClasses)) {
            if (!provider.exists(iModifiableFile)) continue;
            this.m_existingFiles.add(iModifiableFile);
        }
        for (IModifiableDirectory iModifiableDirectory : directoryPath.getChildrenRecursively(IModifiableDirectory.class, stopClasses)) {
            if (!provider.exists(iModifiableDirectory)) continue;
            this.m_existingDirectories.add(iModifiableDirectory);
        }
        if (isScannable) {
            DirectoryScanner directoryScanner = new DirectoryScanner(this.m_ignore, false);
            directoryScanner.scan(directory, (DirectoryScanner.IFileConsumer)this);
        }
        IModifiableFileDeltaKey iModifiableFileDeltaKey = this.m_provider.getKey();
        for (IModifiableFile iModifiableFile : this.m_existingFiles) {
            if (iModifiableFile.needsSave()) {
                this.m_delta.conflictsWithDeleted(iModifiableFileDeltaKey, iModifiableFile);
                continue;
            }
            this.m_delta.deleted(iModifiableFileDeltaKey, iModifiableFile);
        }
        for (IModifiableDirectory iModifiableDirectory : this.m_existingDirectories) {
            this.m_delta.deleted(iModifiableFileDeltaKey, iModifiableDirectory);
        }
        this.m_existingFiles = null;
        this.m_existingDirectories = null;
        this.m_provider = null;
    }

    public IFileType accepts(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'accepts' must not be null";
        assert (this.m_provider != null) : "'m_filter' of method 'accepts' must not be null";
        for (IFileType nextFileType : this.m_provider.getFileTypes()) {
            String[] stringArray = nextFileType.getExtensions();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String nextExtension = stringArray[n3];
                if (file.getName().endsWith(nextExtension) && this.m_provider.accept(file)) {
                    return nextFileType;
                }
                ++n3;
            }
        }
        return null;
    }

    public void consume(TFile rootPathBeingScanned, TFile file, IFileType fileType) {
        assert (rootPathBeingScanned != null) : "Parameter 'rootPathBeingScanned' of method 'consume' must not be null";
        assert (file != null) : "Parameter 'file' of method 'consume' must not be null";
        assert (fileType != null) : "Parameter 'fileType' of method 'consume' must not be null";
        assert (this.m_provider != null) : "'m_provider' of method 'consume' must not be null";
        IModifiableFileDeltaKey key = this.m_provider.getKey();
        IModifiableFile found = null;
        for (IModifiableFile nextExisting : this.m_existingFiles) {
            TFile nextFile = nextExisting.getFile();
            assert (nextFile != null) : "'nextFile' of method 'consume' must not be null";
            if (!FileUtility.areEqual((TFile)nextFile, (TFile)file)) continue;
            if (nextExisting.getTimestamp() != file.lastModified()) {
                if (nextExisting.needsSave()) {
                    this.m_delta.conflictsWithModified(key, nextExisting);
                } else {
                    this.m_delta.modified(key, nextExisting);
                }
            }
            found = nextExisting;
            break;
        }
        if (found == null) {
            String identifyingPath = FileUtility.calculateRelativePath((TFile)file, (TFile)rootPathBeingScanned);
            this.m_delta.added(key, new ModifiableFileCandidate(identifyingPath, file, fileType, this.m_provider.getImageResource(fileType)));
        } else {
            this.m_existingFiles.remove(found);
        }
    }

    public boolean continueScanning(TFile rootPathBeingScanned, TFile path) {
        assert (rootPathBeingScanned != null) : "Parameter 'rootPathBeingScanned' of method 'continueScanning' must not be null";
        assert (path != null) : "Parameter 'directory' of method 'continueScanning' must not be null";
        assert (this.m_provider != null) : "'m_provider' of method 'continueScanning' must not be null";
        if (!this.m_workerContext.hasBeenCanceled()) {
            if (!this.m_provider.recursive() && rootPathBeingScanned != path) {
                return false;
            }
            this.m_workerContext.working(path.getAbsolutePath(), false);
            if (rootPathBeingScanned != path) {
                IModifiableDirectory found = null;
                for (IModifiableDirectory nextExisting : this.m_existingDirectories) {
                    TFile nextFile = nextExisting.getFile();
                    assert (nextFile != null) : "'nextFile' of method 'continueScanning' must not be null";
                    if (!FileUtility.areEqual((TFile)nextFile, (TFile)path)) continue;
                    found = nextExisting;
                    break;
                }
                if (found == null) {
                    String identifyingPath = FileUtility.calculateRelativePath((TFile)path, (TFile)rootPathBeingScanned);
                    this.m_delta.added(this.m_provider.getKey(), new ModifiableDirectoryPathCandidate(identifyingPath, path));
                } else {
                    this.m_existingDirectories.remove(found);
                }
            }
            return true;
        }
        return false;
    }

    public static interface IProvider {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public IModifiableFileDeltaKey getKey();

        public List<IFileType> getFileTypes();

        public String getImageResource(IFileType var1);

        public DirectoryPath getDirectoryPath();

        default public boolean recursive() {
            return true;
        }

        default public boolean exists(IModifiableFile modifiableFile) {
            assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exists' must not be null";
            return true;
        }

        default public boolean exists(IModifiableDirectory directoryPath) {
            assert (directoryPath != null) : "Parameter 'directoryPath' of method 'exists' must not be null";
            return true;
        }

        default public boolean accept(TFile file) {
            assert (file != null) : "Parameter 'file' of method 'accepts' must not be null";
            return true;
        }

        default public Class<?>[] getStopClasses() {
            return new Class[0];
        }
    }

    public static final class SingleFileTypeProviderAdapter
    implements IProvider {
        private final IModifiableFileDeltaKey m_key;
        private final DirectoryPath m_directory;
        private final IFileType m_fileType;
        private final String m_imageResourceName;
        private final boolean m_recursive;

        public SingleFileTypeProviderAdapter(IModifiableFileDeltaKey key, DirectoryPath directory, IFileType fileType, String imageResourceName, boolean recursive) {
            assert (key != null) : "Parameter 'key' of method 'SingleFileTypeProviderAdapter' must not be null";
            assert (directory != null) : "Parameter 'directory' of method 'SingleFileTypeProviderAdapter' must not be null";
            assert (fileType != null) : "Parameter 'fileType' of method 'SingleFileTypeProviderAdapter' must not be null";
            assert (imageResourceName != null && imageResourceName.length() > 0) : "Parameter 'imageResourceName' of method 'SingleFileTypeProviderAdapter' must not be empty";
            this.m_key = key;
            this.m_directory = directory;
            this.m_fileType = fileType;
            this.m_imageResourceName = imageResourceName;
            this.m_recursive = recursive;
        }

        @Override
        public IModifiableFileDeltaKey getKey() {
            return this.m_key;
        }

        @Override
        public DirectoryPath getDirectoryPath() {
            return this.m_directory;
        }

        @Override
        public List<IFileType> getFileTypes() {
            return Collections.singletonList(this.m_fileType);
        }

        @Override
        public String getImageResource(IFileType fileType) {
            return this.m_imageResourceName;
        }

        public boolean isRecursive() {
            return this.m_recursive;
        }
    }
}

