/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiableDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ModifiableDirectoryPathCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class ModifiableFileDelta {
    private final Map<IModifiableFileDeltaKey, Modification> m_deltaKeyToModification = new LinkedHashMap<IModifiableFileDeltaKey, Modification>(5);
    private final Set<IModifiableFile> m_keepConflictingFiles = new HashSet<IModifiableFile>(5);

    void initialize(IModifiableFileDeltaKey key, List<IFileType> fileTypes) {
        assert (key != null) : "Parameter 'key' of method 'initialize' must not be null";
        assert (fileTypes != null && fileTypes.size() > 0) : "Parameter 'fileTypes' of method 'initialize' must not be empty";
        if (!this.m_deltaKeyToModification.containsKey(key)) {
            this.m_deltaKeyToModification.put(key, new Modification(fileTypes));
        }
    }

    public Set<IModifiableFileDeltaKey> getAvailableModifiableFileDeltaKeys() {
        return Collections.unmodifiableSet(this.m_deltaKeyToModification.keySet());
    }

    private Modification getModification(IModifiableFileDeltaKey key) {
        assert (key != null) : "Parameter 'key' of method 'getModification' must not be null";
        Modification modification = this.m_deltaKeyToModification.get(key);
        assert (modification != null) : "'modification' of method 'getModification' must not be null";
        return modification;
    }

    void added(IModifiableFileDeltaKey key, ModifiableFileCandidate modifiableFileCandidate) {
        assert (key != null) : "Parameter 'key' of method 'added' must not be null";
        assert (modifiableFileCandidate != null) : "Parameter 'modifiableFileCandidate' of method 'added' must not be null";
        this.getModification(key).added(modifiableFileCandidate);
    }

    void modified(IModifiableFileDeltaKey key, IModifiableFile modifiableFile) {
        assert (key != null) : "Parameter 'key' of method 'modified' must not be null";
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'modified' must not be null";
        this.getModification(key).modified(modifiableFile);
    }

    void deleted(IModifiableFileDeltaKey key, IModifiableFile modifiableFile) {
        assert (key != null) : "Parameter 'key' of method 'deleted' must not be null";
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'deleted' must not be null";
        this.getModification(key).deleted(modifiableFile);
    }

    void deleted(IModifiableFileDeltaKey key, IModifiableDirectory directoryPath) {
        assert (key != null) : "Parameter 'key' of method 'deleted' must not be null";
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'deleted' must not be null";
        this.getModification(key).deleted(directoryPath);
    }

    void added(IModifiableFileDeltaKey key, ModifiableDirectoryPathCandidate directory) {
        assert (key != null) : "Parameter 'key' of method 'added' must not be null";
        assert (directory != null) : "Parameter 'directory' of method 'scanned' must not be null";
        this.getModification(key).added(directory);
    }

    public void visit(IVisitor visitor, boolean skipKept) {
        assert (visitor != null) : "Parameter 'visitor' of method 'visit' must not be null";
        Modification modification = this.m_deltaKeyToModification.get(visitor.getKey());
        if (modification != null) {
            modification.visit(visitor, skipKept, this.m_keepConflictingFiles);
        }
    }

    void conflictsWithModified(IModifiableFileDeltaKey key, IModifiableFile modifiableFile) {
        assert (key != null) : "Parameter 'key' of method 'conflictsWithModified' must not be null";
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'conflict' must not be null";
        this.getModification(key).conflictsWithModified(modifiableFile);
        this.m_keepConflictingFiles.add(modifiableFile);
    }

    void conflictsWithDeleted(IModifiableFileDeltaKey key, IModifiableFile modifiableFile) {
        assert (key != null) : "Parameter 'key' of method 'conflictsWithDeleted' must not be null";
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'conflict' must not be null";
        this.getModification(key).conflictsWithDeleted(modifiableFile);
        this.m_keepConflictingFiles.add(modifiableFile);
    }

    public void setKeepConflictContent(IModifiableFile modifiableFile, boolean keep) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'keepConflictContent' must not be null";
        this.m_keepConflictingFiles.remove(modifiableFile);
        if (keep) {
            this.m_keepConflictingFiles.add(modifiableFile);
        }
    }

    public boolean keepConflictContent(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'keepConflictContent' must not be null";
        return this.m_keepConflictingFiles.contains(modifiableFile);
    }

    public List<IModifiableFile> getAdded() {
        ArrayList<IModifiableFile> modifiableFiles = new ArrayList<IModifiableFile>();
        for (Modification next : this.m_deltaKeyToModification.values()) {
            next.collectAdded(modifiableFiles);
        }
        return modifiableFiles;
    }

    public List<IModifiableFile> getModified() {
        ArrayList<IModifiableFile> modifiableFiles = new ArrayList<IModifiableFile>();
        for (Modification next : this.m_deltaKeyToModification.values()) {
            next.collectModified(modifiableFiles);
        }
        return modifiableFiles;
    }

    public List<IModifiableFile> getDeleted() {
        ArrayList<IModifiableFile> modifiableFiles = new ArrayList<IModifiableFile>();
        for (Modification next : this.m_deltaKeyToModification.values()) {
            next.collectDeleted(modifiableFiles);
        }
        return modifiableFiles;
    }

    public List<IModifiableFile> getConflictsWithModified() {
        ArrayList<IModifiableFile> modifiableFiles = new ArrayList<IModifiableFile>();
        for (Modification next : this.m_deltaKeyToModification.values()) {
            next.collectConflictsWithModified(modifiableFiles);
        }
        return modifiableFiles;
    }

    public List<IModifiableFile> getConflictsWithDeleted() {
        ArrayList<IModifiableFile> modifiableFiles = new ArrayList<IModifiableFile>();
        for (Modification next : this.m_deltaKeyToModification.values()) {
            next.collectConflictsWithDeleted(modifiableFiles);
        }
        return modifiableFiles;
    }

    public boolean containsFiles(IModifiableFileDeltaKey key) {
        assert (key != null) : "Parameter 'key' of method 'containsFiles' must not be null";
        Modification modification = this.m_deltaKeyToModification.get(key);
        return modification != null ? modification.containsFiles() : false;
    }

    public boolean containsDirectories() {
        for (Modification next : this.m_deltaKeyToModification.values()) {
            if (!next.containsDirectories()) continue;
            return true;
        }
        return false;
    }

    public boolean containsFiles() {
        for (Modification next : this.m_deltaKeyToModification.values()) {
            if (!next.containsFiles()) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfModifiedFiles() {
        int totalCount = 0;
        for (Modification next : this.m_deltaKeyToModification.values()) {
            totalCount += next.getNumberOfModifiedFiles();
        }
        return totalCount;
    }

    public boolean isEmpty() {
        for (Modification nextModification : this.m_deltaKeyToModification.values()) {
            if (nextModification.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<IModifiableFileDeltaKey, Modification> nextEntry : this.m_deltaKeyToModification.entrySet()) {
            builder.append("### Modification Key: ").append(nextEntry.getKey()).append(" ###").append("\n");
            builder.append(nextEntry.getValue().toString());
        }
        return builder.toString();
    }

    private static final class FileModification {
        private final Set<ModifiableFileCandidate> m_added = new LinkedHashSet<ModifiableFileCandidate>();
        private final Set<IModifiableFile> m_modified = new LinkedHashSet<IModifiableFile>();
        private final Set<IModifiableFile> m_deleted = new LinkedHashSet<IModifiableFile>();
        private final Set<IModifiableFile> m_conflictsWithModified = new LinkedHashSet<IModifiableFile>();
        private final Set<IModifiableFile> m_conflictsWithDeleted = new LinkedHashSet<IModifiableFile>();

        FileModification() {
        }

        void added(ModifiableFileCandidate modifiableFileCandidate) {
            assert (modifiableFileCandidate != null) : "Parameter 'modifiableFileCandidate' of method 'added' must not be null";
            this.m_added.add(modifiableFileCandidate);
        }

        void modified(IModifiableFile modifiableFile) {
            assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'modified' must not be null";
            this.m_modified.add(modifiableFile);
        }

        void deleted(IModifiableFile modifiableFile) {
            assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'deleted' must not be null";
            this.m_deleted.add(modifiableFile);
        }

        void conflictsWithModified(IModifiableFile modifiableFile) {
            assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'conflict' must not be null";
            this.m_conflictsWithModified.add(modifiableFile);
        }

        void conflictsWithDeleted(IModifiableFile modifiableFile) {
            assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'conflict' must not be null";
            this.m_conflictsWithDeleted.add(modifiableFile);
        }

        Set<ModifiableFileCandidate> getAdded() {
            return this.m_added;
        }

        Set<IModifiableFile> getModified() {
            return this.m_modified;
        }

        Set<IModifiableFile> getDeleted() {
            return this.m_deleted;
        }

        Set<IModifiableFile> getConflictsWithModified() {
            return this.m_conflictsWithModified;
        }

        Set<IModifiableFile> getConflictsWithDeleted() {
            return this.m_conflictsWithDeleted;
        }

        boolean containsFiles() {
            return !this.m_added.isEmpty() || !this.m_deleted.isEmpty() || !this.m_modified.isEmpty() || !this.m_conflictsWithDeleted.isEmpty() || !this.m_conflictsWithModified.isEmpty();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (IModifiableFile iModifiableFile : this.m_deleted) {
                builder.append("Deleted ").append(iModifiableFile.getFileType().getPresentationName()).append(": ");
                builder.append(iModifiableFile.getIdentifyingPath());
                builder.append("\n");
            }
            for (IModifiableFile iModifiableFile : this.m_modified) {
                builder.append("Modified ").append(iModifiableFile.getFileType().getPresentationName()).append(": ");
                builder.append(iModifiableFile.getIdentifyingPath());
                builder.append("\n");
            }
            for (ModifiableFileCandidate modifiableFileCandidate : this.m_added) {
                builder.append("Added ").append(modifiableFileCandidate.getFileType().getPresentationName()).append(": ");
                builder.append(modifiableFileCandidate.getIdentifyingPath());
                builder.append("\n");
            }
            for (IModifiableFile iModifiableFile : this.m_conflictsWithDeleted) {
                builder.append(iModifiableFile.getFileType().getPresentationName()).append(" conflicts with deleted: ");
                builder.append(iModifiableFile.getIdentifyingPath());
                builder.append("\n");
            }
            for (IModifiableFile iModifiableFile : this.m_conflictsWithModified) {
                builder.append(iModifiableFile.getFileType().getPresentationName()).append(" conflicts with modified: ");
                builder.append(iModifiableFile.getIdentifyingPath());
                builder.append("\n");
            }
            return builder.toString();
        }

        public int size() {
            return this.m_deleted.size() + this.m_modified.size() + this.m_added.size() + this.m_conflictsWithDeleted.size() + this.m_conflictsWithModified.size();
        }
    }

    public static interface IVisitor {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public IModifiableFileDeltaKey getKey();

        default public void visitAdded(ModifiableFileCandidate added) {
            assert (added != null) : "Parameter 'added' of method 'visitAdded' must not be null";
        }

        default public void visitDeleted(IModifiableFile deleted) {
            assert (deleted != null) : "Parameter 'deleted' of method 'visitDeleted' must not be null";
        }

        default public void visitModified(IModifiableFile modified) {
            assert (modified != null) : "Parameter 'modified' of method 'visitModified' must not be null";
        }

        default public void visitAdded(ModifiableDirectoryPathCandidate added) {
            assert (added != null) : "Parameter 'added' of method 'visitAdded' must not be null";
        }

        default public void visitDeleted(IModifiableDirectory deleted) {
            assert (deleted != null) : "Parameter 'deleted' of method 'visitDeleted' must not be null";
        }
    }

    private static final class Modification {
        private final Map<IFileType, FileModification> m_fileTypeToFileModification = new LinkedHashMap<IFileType, FileModification>(2);
        private final Set<IModifiableDirectory> m_deletedDirectories = new TreeSet<IModifiableDirectory>(new Comparator<IModifiableDirectory>(){

            @Override
            public int compare(IModifiableDirectory d1, IModifiableDirectory d2) {
                if (!$assertionsDisabled && d1 == null) {
                    throw new AssertionError((Object)"Parameter 'd1' of method 'enclosing_method' must not be null");
                }
                if (!$assertionsDisabled && d2 == null) {
                    throw new AssertionError((Object)"Parameter 'd2' of method 'enclosing_method' must not be null");
                }
                return d2.getIdentifyingPath().compareTo(d1.getIdentifyingPath());
            }
        });
        private final Set<ModifiableDirectoryPathCandidate> m_addedDirectories = new TreeSet<ModifiableDirectoryPathCandidate>(new Comparator<ModifiableDirectoryPathCandidate>(){

            @Override
            public int compare(ModifiableDirectoryPathCandidate d1, ModifiableDirectoryPathCandidate d2) {
                if (!$assertionsDisabled && d1 == null) {
                    throw new AssertionError((Object)"Parameter 'd1' of method 'enclosing_method' must not be null");
                }
                if (!$assertionsDisabled && d2 == null) {
                    throw new AssertionError((Object)"Parameter 'd2' of method 'enclosing_method' must not be null");
                }
                return d1.getIdentifyingPath().compareTo(d2.getIdentifyingPath());
            }
        });

        Modification(List<IFileType> fileTypes) {
            assert (fileTypes != null && !fileTypes.isEmpty()) : "Parameter 'fileTypes' of method 'Modification' must not be empty";
            for (IFileType nextFileType : fileTypes) {
                FileModification previous = this.m_fileTypeToFileModification.put(nextFileType, new FileModification());
                assert (previous == null) : "Already added file type: " + nextFileType;
            }
        }

        private FileModification getFileModification(IFileType fileType) {
            assert (fileType != null) : "Parameter 'fileType' of method 'getFileModification' must not be null";
            FileModification fileModification = this.m_fileTypeToFileModification.get(fileType);
            assert (fileModification != null) : "Parameter 'fileModification' of method 'getFileModification' must not be null";
            return fileModification;
        }

        void added(ModifiableFileCandidate modifiableFileCandidate) {
            assert (modifiableFileCandidate != null) : "Parameter 'modifiableFileCandidate' of method 'added' must not be null";
            this.getFileModification(modifiableFileCandidate.getFileType()).added(modifiableFileCandidate);
        }

        void modified(IModifiableFile modifiableFile) {
            assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'modified' must not be null";
            this.getFileModification(modifiableFile.getFileType()).modified(modifiableFile);
        }

        void deleted(IModifiableFile modifiableFile) {
            assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'deleted' must not be null";
            this.getFileModification(modifiableFile.getFileType()).deleted(modifiableFile);
        }

        void conflictsWithModified(IModifiableFile modifiableFile) {
            assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'conflict' must not be null";
            this.getFileModification(modifiableFile.getFileType()).conflictsWithModified(modifiableFile);
        }

        void conflictsWithDeleted(IModifiableFile modifiableFile) {
            assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'conflict' must not be null";
            this.getFileModification(modifiableFile.getFileType()).conflictsWithDeleted(modifiableFile);
        }

        void collectAdded(List<IModifiableFile> modifiableFiles) {
            assert (modifiableFiles != null) : "Parameter 'modifiableFiles' of method 'collectAdded' must not be null";
            for (FileModification nextFileModification : this.m_fileTypeToFileModification.values()) {
                modifiableFiles.addAll(nextFileModification.getAdded());
            }
        }

        void collectModified(List<IModifiableFile> modifiableFiles) {
            assert (modifiableFiles != null) : "Parameter 'modifiableFiles' of method 'collectModified' must not be null";
            for (FileModification nextFileModification : this.m_fileTypeToFileModification.values()) {
                modifiableFiles.addAll(nextFileModification.getModified());
            }
        }

        void collectDeleted(List<IModifiableFile> modifiableFiles) {
            assert (modifiableFiles != null) : "Parameter 'modifiableFiles' of method 'collectDeleted' must not be null";
            for (FileModification nextFileModification : this.m_fileTypeToFileModification.values()) {
                modifiableFiles.addAll(nextFileModification.getDeleted());
            }
        }

        void collectConflictsWithModified(List<IModifiableFile> modifiableFiles) {
            assert (modifiableFiles != null) : "Parameter 'modifiableFiles' of method 'collectConflictsWithModified' must not be null";
            for (FileModification nextFileModification : this.m_fileTypeToFileModification.values()) {
                modifiableFiles.addAll(nextFileModification.getConflictsWithModified());
            }
        }

        void collectConflictsWithDeleted(List<IModifiableFile> modifiableFiles) {
            assert (modifiableFiles != null) : "Parameter 'modifiableFiles' of method 'collectConflictsWithDeleted' must not be null";
            for (FileModification nextFileModification : this.m_fileTypeToFileModification.values()) {
                modifiableFiles.addAll(nextFileModification.getConflictsWithDeleted());
            }
        }

        boolean containsFiles() {
            for (FileModification nextFileModification : this.m_fileTypeToFileModification.values()) {
                if (!nextFileModification.containsFiles()) continue;
                return true;
            }
            return false;
        }

        void deleted(IModifiableDirectory directoryPath) {
            assert (directoryPath != null) : "Parameter 'directoryPath' of method 'deleted' must not be null";
            this.m_deletedDirectories.add(directoryPath);
        }

        void added(ModifiableDirectoryPathCandidate directory) {
            assert (directory != null) : "Parameter 'directory' of method 'scanned' must not be null";
            this.m_addedDirectories.add(directory);
        }

        boolean containsDirectories() {
            return !this.m_deletedDirectories.isEmpty() || !this.m_addedDirectories.isEmpty();
        }

        void visit(IVisitor visitor, boolean skipKept, Set<IModifiableFile> keepConflictingFiles) {
            assert (visitor != null) : "Parameter 'visitor' of method 'visit' must not be null";
            assert (keepConflictingFiles != null) : "Parameter 'keepConflictingFiles' of method 'visit' must not be null";
            for (FileModification fileModification : this.m_fileTypeToFileModification.values()) {
                for (IModifiableFile iModifiableFile : fileModification.getModified()) {
                    visitor.visitModified(iModifiableFile);
                }
                for (IModifiableFile iModifiableFile : fileModification.getDeleted()) {
                    visitor.visitDeleted(iModifiableFile);
                }
                for (IModifiableFile iModifiableFile : fileModification.getConflictsWithModified()) {
                    if (skipKept && keepConflictingFiles.contains(iModifiableFile)) continue;
                    visitor.visitModified(iModifiableFile);
                }
                for (IModifiableFile iModifiableFile : fileModification.getConflictsWithDeleted()) {
                    if (skipKept && keepConflictingFiles.contains(iModifiableFile)) continue;
                    visitor.visitDeleted(iModifiableFile);
                }
                for (ModifiableFileCandidate modifiableFileCandidate : fileModification.getAdded()) {
                    visitor.visitAdded(modifiableFileCandidate);
                }
            }
            for (IModifiableDirectory iModifiableDirectory : this.m_deletedDirectories) {
                visitor.visitDeleted(iModifiableDirectory);
            }
            for (ModifiableDirectoryPathCandidate modifiableDirectoryPathCandidate : this.m_addedDirectories) {
                visitor.visitAdded(modifiableDirectoryPathCandidate);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (FileModification fileModification : this.m_fileTypeToFileModification.values()) {
                builder.append(fileModification.toString());
            }
            for (IModifiableDirectory iModifiableDirectory : this.m_deletedDirectories) {
                builder.append("Deleted directory: ");
                builder.append(iModifiableDirectory.getIdentifyingPath());
                builder.append("\n");
            }
            for (ModifiableDirectoryPathCandidate modifiableDirectoryPathCandidate : this.m_addedDirectories) {
                builder.append("Added directory: ");
                builder.append(modifiableDirectoryPathCandidate.getIdentifyingPath());
                builder.append("\n");
            }
            return builder.toString();
        }

        public int getNumberOfModifiedFiles() {
            int size = 0;
            for (FileModification nextFileModification : this.m_fileTypeToFileModification.values()) {
                size += nextFileModification.size();
            }
            return size;
        }

        public boolean isEmpty() {
            return !this.containsFiles() && !this.containsDirectories();
        }
    }
}

