/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectoryPath;
import de.schlichtherle.truezip.file.TFile;

public abstract class ModifiableDirectory
extends SoftwareSystemDirectoryPath
implements IModifiableDirectory {
    private final IModifiablePathListener m_listener;

    public ModifiableDirectory(NamedElement parent, TFile file, IModifiablePathListener listener) {
        super(parent, file);
        assert (listener != null) : "Parameter 'listener' of method 'ModifiableDirectoryPath' must not be null";
        this.m_listener = listener;
    }

    @Override
    public String getPresentationKind() {
        return "Directory";
    }

    protected final IModifiablePathListener getListener() {
        return this.m_listener;
    }

    @Override
    public final void reallocate() {
        DirectoryPath parent = this.getParent(DirectoryPath.class, new Class[0]);
        if (parent != null && !(parent instanceof IBaseDirectory)) {
            String ownPath = this.getPath();
            int pos = ownPath.lastIndexOf("/");
            assert (pos != -1) : "No path separator found: " + ownPath;
            String parentPath = parent.getPath();
            assert (parentPath != null && parentPath.length() > 0) : "'parentPath' of method 'reallocate' must not be empty";
            this.setPath(String.valueOf(parentPath) + ownPath.substring(pos));
        }
        super.resetFile();
        this.getFile();
    }

    @Override
    public final void setPath(TFile path) {
        super.setPath(path);
        this.m_listener.modified(this);
    }

    @Override
    public final void remove() {
        this.m_listener.deleted(this);
        super.remove();
    }

    @Override
    public final void parentRemoved() {
        this.m_listener.deleted(this);
        super.parentRemoved();
    }
}

