/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.Path;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.Date;

public abstract class FilePath
extends Path {
    private long m_timestamp;

    protected FilePath(NamedElement parent) {
        super(parent);
        this.m_timestamp = -1L;
    }

    protected FilePath(NamedElement parent, TFile file) {
        super(parent, file);
        this.m_timestamp = file.lastModified();
    }

    protected FilePath(NamedElement parent, TFile file, long timestamp) {
        super(parent, file);
        this.m_timestamp = timestamp;
    }

    protected FilePath(NamedElement parent, TFile file, IBaseDirectory baseDirectory) {
        super(parent, file, baseDirectory);
        this.m_timestamp = file.lastModified();
    }

    protected FilePath(NamedElement parent, String path) {
        super(parent, path);
        this.m_timestamp = -1L;
    }

    public abstract IFileType getFileType();

    public String getExtension() {
        String fileName = this.getShortName();
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos >= 0) {
            return fileName.substring(dotPos);
        }
        return "";
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeLong(this.m_timestamp);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_timestamp = reader.readLong();
    }

    public final long getTimestamp() {
        return this.m_timestamp;
    }

    public final boolean isModified() {
        return this.m_timestamp != this.getFile().lastModified();
    }

    public final void setTimestamp(long timestamp) {
        this.m_timestamp = timestamp;
    }

    @Property
    public final String getLastFileModification() {
        if (this.m_timestamp != -1L) {
            return StringUtility.getDateTimeStringFromLocale((Date)new Date(this.m_timestamp));
        }
        return null;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitFilePath(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitFilePath(FilePath var1);
    }
}

