/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.core.model.analysis.IValueList;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.metrics.AbstractMetric;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.IntegerValueList;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.workspace.External;

public final class SourceElementCountMetric
extends AbstractMetric {
    public SourceElementCountMetric(NamedElement parent, IMetricLevel level) {
        super(parent, CoreMetricId.CORE_SOURCE_ELEMENT_COUNT, level);
    }

    @Override
    public IValueList collectValues(IWorkerContext workerContext, NamedElement root) {
        IntegerValueList resultList = new IntegerValueList(null, this, root);
        return this.collect(workerContext, root, resultList);
    }

    @Override
    protected NamedElementVisitor createCollector(IWorkerContext workerContext, IValueList collectionRoot) {
        return new ValueCollector(workerContext, collectionRoot);
    }

    private class ValueCollector
    extends NamedElementVisitor
    implements ProgrammingElement.IVisitor,
    External.IVisitor {
        private final IWorkerContext m_workerContext;
        private final IValueList m_collectionRoot;
        private ProgrammingElement m_currentElement;
        private int m_currentCount = 0;

        private ValueCollector(IWorkerContext workerContext, IValueList collectionRoot) {
            this.m_workerContext = workerContext;
            this.m_collectionRoot = collectionRoot;
        }

        @Override
        public void visitProgrammingElement(ProgrammingElement element) {
            if (this.m_currentElement == null) {
                this.m_currentElement = element;
                this.m_currentCount = element.getSourceElementCount();
                this.visitChildrenOf(element);
                this.m_collectionRoot.addValue(element, this.m_currentCount);
                this.m_currentElement = null;
            } else if (element.isDefinedInEnclosingElement()) {
                this.m_currentCount += element.getSourceElementCount();
                this.visitChildrenOf(element);
            }
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            if (element instanceof IComponent) {
                if (!element.isExcluded()) {
                    if (!element.getRefactoringState().hasBeenDeleted()) {
                        this.visitChildrenOf(element);
                    }
                    this.m_workerContext.workItemCompleted();
                }
            } else {
                this.visitChildrenOf(element);
            }
        }

        @Override
        public void visitExternal(External element) {
        }
    }
}

