/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.sonargraph.api.IPluginMetricId;
import com.hello2morrow.sonargraph.api.PluginMetricCharacteristic;
import com.hello2morrow.sonargraph.api.PluginMetricLevel;
import com.hello2morrow.sonargraph.api.PluginMetricRange;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.MetricScope;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.plugin.PluginProviderId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class PluginMetricId
implements IPluginMetricId,
IMetricId {
    private static final IMetricCategory METRIC_CATEGORY = new IMetricCategory(){
        private static final String NAME = "Plugin";

        public String getStandardName() {
            return NAME;
        }

        public String getPresentationName() {
            return NAME;
        }

        @Override
        public int getOrderNumber() {
            return Integer.MAX_VALUE;
        }

        public int hashCode() {
            return NAME.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    };
    private final PluginProviderId m_providerId;
    private final String m_name;
    private final String m_description;
    private final boolean m_isFloat;
    private final PluginMetricRange m_range;
    private final PluginMetricCharacteristic m_characteristic;
    private final Set<PluginMetricLevel> m_levels;

    public PluginMetricId(PluginProviderId pluginId, String name, String description, boolean isFloat, PluginMetricRange range, PluginMetricCharacteristic characteristic, Set<PluginMetricLevel> levels) {
        assert (pluginId != null) : "Parameter 'pluginId' of method 'PluginMetricId' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'PluginMetricId' must not be empty";
        assert (description != null && description.length() > 0) : "Parameter 'description' of method 'PluginMetricId' must not be empty";
        assert (range != null) : "Parameter 'range' of method 'PluginMetricId' must not be null";
        assert (characteristic != null) : "Parameter 'characteristic' of method 'PluginMetricId' must not be null";
        assert (levels != null && levels.size() > 0) : "Parameter 'levels' of method 'PluginMetricId' must not be empty";
        this.m_providerId = pluginId;
        this.m_name = name;
        this.m_description = description;
        this.m_isFloat = isFloat;
        this.m_range = range;
        this.m_characteristic = characteristic;
        this.m_levels = levels;
    }

    public String getStandardName() {
        return this.m_name.replace(" ", "_");
    }

    public String getPresentationName() {
        return this.m_name;
    }

    @Override
    public IProviderId getProvider() {
        return this.m_providerId;
    }

    @Override
    public MetricScope getMetricScope() {
        return MetricScope.SYSTEM;
    }

    @Override
    public IMetricId.StandardSorting getSorting() {
        switch (this.m_characteristic) {
            case HIGHER_WORSE: {
                return IMetricId.StandardSorting.HIGHER_WORSE;
            }
            case INDIFFERENT: {
                return IMetricId.StandardSorting.INDIFFERENT;
            }
            case LOWER_WORSE: {
                return IMetricId.StandardSorting.LOWER_WORSE;
            }
        }
        assert (false) : "Unexpected value of PluginMetricCharacteristic: " + this.m_characteristic.name();
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public boolean isFloat() {
        return this.m_isFloat;
    }

    @Override
    public IMetricId.IMetricRange getRange() {
        switch (this.m_range) {
            case NULL_OR_POSITIVE: {
                return IMetricId.MetricRange.NULL_OR_POSITIVE;
            }
            case PERCENTAGE: {
                return IMetricId.MetricRange.PERCENTAGE;
            }
            case ZERO_TO_ONE: {
                return IMetricId.MetricRange.ZERO_TO_ONE;
            }
        }
        assert (false) : "Unexpected value of PluginMetricRange: " + this.m_range.name();
        return null;
    }

    public PluginMetricRange getMetricRange() {
        return this.m_range;
    }

    public PluginMetricCharacteristic getCharacteristic() {
        return this.m_characteristic;
    }

    public Set<PluginMetricLevel> getAvailableLevels() {
        return Collections.unmodifiableSet(this.m_levels);
    }

    public int hashCode() {
        return Objects.hash(this.m_characteristic, this.m_description, this.m_isFloat, this.m_name, this.m_providerId, this.m_range);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluginMetricId other = (PluginMetricId)obj;
        return this.m_characteristic == other.m_characteristic && Objects.equals(this.m_description, other.m_description) && this.m_isFloat == other.m_isFloat && Objects.equals(this.m_name, other.m_name) && Objects.equals(this.m_providerId, other.m_providerId) && this.m_range == other.m_range;
    }

    public String toString() {
        return String.valueOf(this.m_name) + " (" + this.m_range + ", " + this.m_characteristic + ")";
    }

    @Override
    public List<IMetricCategory> getCategories() {
        return Arrays.asList(METRIC_CATEGORY);
    }
}

