/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.IHasMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class MetricDescriptor
extends NamedElement
implements IHasMetricDescriptor,
IMetricDescriptor {
    private final IMetricId m_id;
    private final IMetricLevel m_level;
    private final IAnalyzerId m_providingAnalyzerId;
    private final Predicate<NamedElement> m_elementFilter;
    private final Language m_language;

    public MetricDescriptor(NamedElement parent, IMetricId id, IMetricLevel level, IAnalyzerId providingAnalyzerId, Predicate<NamedElement> elementFilter, Language language) {
        super(parent);
        assert (parent != null) : "Parameter 'parent' of method 'MetricDescriptor' must not be null";
        assert (id != null) : "Parameter 'id' of method 'MetricDescriptor' must not be null";
        assert (level != null) : "Parameter 'level' of method 'MetricDescriptor' must not be null";
        assert (providingAnalyzerId != null) : "Parameter 'providingAnalyzerId' of method 'MetricDescriptor' must not be null";
        this.m_id = id;
        this.m_level = level;
        this.m_providingAnalyzerId = providingAnalyzerId;
        this.m_elementFilter = elementFilter;
        this.m_language = language;
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    @Override
    public boolean providesMetricsForElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'providesMetricsForElement' must not be null";
        return this.m_elementFilter == null ? true : this.m_elementFilter.test(element);
    }

    @Override
    public IMetricId getMetricId() {
        return this.m_id;
    }

    @Override
    public IMetricLevel getLevel() {
        return this.m_level;
    }

    @Override
    public String getImageResourceName() {
        return "Metric";
    }

    @Override
    public IMetricDescriptor getMetricDescriptor() {
        return this;
    }

    @Override
    public String getShortName() {
        return this.m_id.getPresentationName();
    }

    @Override
    public String getDescription() {
        return this.m_id.getDescription();
    }

    @Override
    public IAnalyzerId getProvidingAnalyzerId() {
        return this.m_providingAnalyzerId;
    }

    @Property
    public String getCategories() {
        return StringUtility.concat((Collection)this.m_id.getCategories().stream().map(c2 -> c2.getPresentationName()).collect(Collectors.toList()), (String)", ");
    }

    @Override
    public Language getLanguage() {
        return this.m_language;
    }

    @Override
    public boolean isFloat() {
        return this.m_id.isFloat();
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return Integer.toString(this.hashCode());
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n").append("Id: ").append(this.m_id);
        builder.append("\n").append("Level: ").append(this.m_level);
        builder.append("\n").append("Language: ").append(this.m_language);
        builder.append("\n").append("Providing analyzer: ").append(this.m_providingAnalyzerId);
        return builder.toString();
    }
}

