/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import java.util.function.Predicate;

public final class CoreMetricLevel
extends Enum<CoreMetricLevel>
implements IMetricLevel {
    public static final /* enum */ CoreMetricLevel SYSTEM = new CoreMetricLevel(SoftwareSystem.class, 0);
    public static final /* enum */ CoreMetricLevel MODULE = new CoreMetricLevel(Module.class, 10);
    public static final /* enum */ CoreMetricLevel DIRECTORY = new CoreMetricLevel(DirectoryPath.class, 30);
    public static final /* enum */ CoreMetricLevel DIRECTORY_FRAGMENT = new CoreMetricLevel(DirectoryFragment.class, 35);
    public static final /* enum */ CoreMetricLevel NAMESPACE_FRAGMENT = new CoreMetricLevel(NamespaceFragment.class, 45);
    public static final /* enum */ CoreMetricLevel COMPONENT = new CoreMetricLevel(IComponent.class, 50);
    public static final /* enum */ CoreMetricLevel SOURCE_FILE = new CoreMetricLevel(SourceFile.class, 60);
    public static final /* enum */ CoreMetricLevel LOGICAL_PROGRAMMING_ELEMENT = new CoreMetricLevel(LogicalProgrammingElement.class, 65);
    public static final /* enum */ CoreMetricLevel TYPE = new CoreMetricLevel(IType.class, 70);
    public static final /* enum */ CoreMetricLevel ROUTINE = new CoreMetricLevel(IRoutine.class, c2 -> ((IRoutine)c2).foundInSource(), 80);
    public static final /* enum */ CoreMetricLevel ELEMENT = new CoreMetricLevel(ProgrammingElement.class, 90);
    private final Class<?> m_class;
    private final Predicate<Object> m_predicate;
    private final int m_orderNumber;
    private static final /* synthetic */ CoreMetricLevel[] ENUM$VALUES;

    static {
        ENUM$VALUES = new CoreMetricLevel[]{SYSTEM, MODULE, DIRECTORY, DIRECTORY_FRAGMENT, NAMESPACE_FRAGMENT, COMPONENT, SOURCE_FILE, LOGICAL_PROGRAMMING_ELEMENT, TYPE, ROUTINE, ELEMENT};
    }

    private CoreMetricLevel(Class<?> clazz, int orderNumber) {
        assert (clazz != null) : "Parameter 'clazz' of method 'CoreMetricLevel' must not be null";
        this.m_class = clazz;
        this.m_orderNumber = orderNumber;
        this.m_predicate = null;
    }

    private CoreMetricLevel(Class<?> clazz, Predicate<Object> predicate, int orderNumber) {
        assert (clazz != null) : "Parameter 'clazz' of method 'CoreMetricLevel' must not be null";
        this.m_class = clazz;
        this.m_orderNumber = orderNumber;
        this.m_predicate = predicate;
    }

    @Override
    public Class<?> getAssociatedClass() {
        return this.m_class;
    }

    @Override
    public Predicate<Object> getPredicate() {
        return this.m_predicate;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return StringUtility.convertConstantNameToPresentationName((String)this.name());
    }

    @Override
    public int getOrderNumber() {
        return this.m_orderNumber;
    }

    public static CoreMetricLevel[] values() {
        CoreMetricLevel[] coreMetricLevelArray = ENUM$VALUES;
        int n2 = coreMetricLevelArray.length;
        CoreMetricLevel[] coreMetricLevelArray2 = new CoreMetricLevel[n2];
        System.arraycopy(ENUM$VALUES, 0, coreMetricLevelArray2, 0, n2);
        return coreMetricLevelArray2;
    }

    public static CoreMetricLevel valueOf(String string) {
        return Enum.valueOf(CoreMetricLevel.class, string);
    }
}

