/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.MetricScope;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.metrics.MetricCategory;
import java.util.Arrays;
import java.util.List;

public final class CoreMetricId
extends Enum<CoreMetricId>
implements IMetricId {
    public static final /* enum */ CoreMetricId CORE_SOURCE_ELEMENT_COUNT = new CoreMetricId("Source Element Count", "Number of programming elements (i.e. types, fields, methods, functions, ...) plus number of statements. This includes elements of fully analyzed and issue ignoring code.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_LINES_OF_CODE = new CoreMetricId("Lines of Code", "Lines of code excluding blank and comment lines. This includes fully analyzed and issue ignoring code.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_LINES_OF_CODE_FULLY_ANALYZED = new CoreMetricId("Lines of Fully Analyzed Code", "Lines of fully analyzed code excluding blank and comment lines.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_LINES_OF_CODE_ISSUE_IGNORING = new CoreMetricId("Lines of Issue-Ignoring Code", "Lines of code excluding blank and comment lines for which only architecture violations and parsing problems are reported.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_COMMENT_LINES = new CoreMetricId("Comment Lines", "Counts all comment lines excluding blank comment lines. This includes fully analyzed and issue ignoring code.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_CODE_COMMENT_LINES = new CoreMetricId("Code Comment Lines", "Counts all comment lines excluding header comments and blank comment lines. This includes code of fully analyzed and issue ignoring code.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_TOTAL_LINES = new CoreMetricId("Total Lines", "Counts all lines including empty and comment lines of source files. This includes files of fully analyzed and issue ignoring code.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_LINES_OF_CODE_IN_LARGE_FILES = new CoreMetricId("Lines of Fully Analyzed Code in Large Files", "Lines of fully analyzed code excluding blank and comment lines in files violating the threshold (default 1000).", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_LINES_OF_CODE_IN_LARGE_FILES_PERCENT = new CoreMetricId("Lines of Fully Analyzed Code in Large Files (%)", "Percent of lines of fully analyzed code excluding blank and comment lines in files violating the threshold (default 1000).", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_LINES_OF_CODE_IN_LARGE_FILES_IGNORED = new CoreMetricId("Lines of Fully Analyzed Code in Large Files [Ignored]", "Lines of fully analyzed code excluding blank and comment lines in ignored files violating the threshold (default 1000).", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_LINES_OF_CODE_IN_LARGE_FILES_IGNORED_PERCENT = new CoreMetricId("Lines of Fully Analyzed Code in Large Files [Ignored] (%)", "Percent of lines of fully analyzed code excluding blank and comment lines in ignored files violating the threshold (default 1000).", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_LINES_OF_CODE_IN_LARGE_FILES_TO_FIX = new CoreMetricId("Lines of Fully Analyzed Code in Large Files [To Be Fixed]", "Lines of fully analyzed code excluding blank and comment lines in to be fixed files violating the threshold (default 1000).", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_LINES_OF_CODE_IN_LARGE_FILES_TO_FIX_PERCENT = new CoreMetricId("Lines of Fully Analyzed Code in Large Files [To Be Fixed] (%)", "Percent of lines of fully analyzed code excluding blank and comment lines in to be fixed files violating the threshold (default 1000).", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_STATEMENTS = new CoreMetricId("Number of Statements", "Counts all statements. This includes statements of fully analyzed and issue ignoring code.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_STATEMENTS_FULLY_ANALYZED = new CoreMetricId("Number of Statements in Fully Analyzed Code", "Counts all statements in fully analyzed code.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_STATEMENTS_COMPLEX_METHODS = new CoreMetricId("Number of Statements in Complex Methods", "Counts all statements in fully analyzed code of too complex methods, i.e. that violate the thresholds for max nesting depth (default 4) or for extended modified cyclomatic complexity (default 15).", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.COMPLEXITY);
    public static final /* enum */ CoreMetricId CORE_STATEMENTS_COMPLEX_METHODS_PERCENT = new CoreMetricId("Number of Statements in Complex Methods (%)", "Percentage of statements in fully analyzed code in too complex methods, i.e. that violate the thresholds for max nesting depth (default 4) or for extended modified cyclomatic complexity (default 15).", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.COMPLEXITY);
    public static final /* enum */ CoreMetricId CORE_STATEMENTS_COMPLEX_METHODS_IGNORED = new CoreMetricId("Number of Statements in Complex Methods [Ignored]", "Counts all statements in fully analyzed code of ignored too complex methods, i.e. that violate the thresholds for max nesting depth (default 4) or for extended modified cyclomatic complexity (default 15).", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.COMPLEXITY);
    public static final /* enum */ CoreMetricId CORE_STATEMENTS_COMPLEX_METHODS_IGNORED_PERCENT = new CoreMetricId("Number of Statements in Complex Methods [Ignored] (%)", "Percentage of statements in fully analyzed code in ignored too complex methods, i.e. that violate the thresholds for max nesting depth (default 4) or for extended modified cyclomatic complexity (default 15).", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.COMPLEXITY);
    public static final /* enum */ CoreMetricId CORE_STATEMENTS_COMPLEX_METHODS_TO_FIX = new CoreMetricId("Number of Statements in Complex Methods [To Be Fixed]", "Counts all statements in fully analyzed code of to be fixed too complex methods, i.e. that violate the thresholds for max nesting depth (default 4) or for extended modified cyclomatic complexity (default 15).", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.COMPLEXITY);
    public static final /* enum */ CoreMetricId CORE_STATEMENTS_COMPLEX_METHODS_TO_FIX_PERCENT = new CoreMetricId("Number of Statements in Complex Methods [To Be Fixed] (%)", "Percentage of statements in fully analyzed code in to be fixed too complex methods, i.e. that violate the thresholds for max nesting depth (default 4) or for extended modified cyclomatic complexity (default 15).", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.COMPLEXITY);
    public static final /* enum */ CoreMetricId CORE_PARAMETERS = new CoreMetricId("Number of Parameters", "Number of parameters.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_COMPONENTS = new CoreMetricId("Number of Components/Sources", "Number of components or source files", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_COMPONENTS_FULLY_ANALYZED = new CoreMetricId("Number of Components (Full Analysis)", "Number of fully analyzed components.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_COMPONENTS_IGNORING_ISSUES = new CoreMetricId("Number of Components (Ignoring Issues)", "Number of components ignoring issues.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_METHODS = new CoreMetricId("Number of Methods", "Number of member functions.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_TYPES = new CoreMetricId("Number of Types", "Number of types (classes, enums or similar) in container.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_TYPES_MODULE = new CoreMetricId("Number of Logical Types (Module)", "Number of logical types (classes, enums or similar) in container on module level.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_TYPES_SYSTEM = new CoreMetricId("Number of Logical Types (System)", "Number of logical types (classes, enums or similar) in container on system level.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_SOURCEFILES = new CoreMetricId("Number of Source Files", "Number of source files in fully analyzed and issue ignoring code.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_SOURCEFILES_FULLY_ANALYZED = new CoreMetricId("Number of Source Files (Full Analysis)", "Number of source files that are fully analyzed, i.e. not excluded by any workspace filter.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_SOURCEFILES_TEST = new CoreMetricId("Number of Source Files (Excluded)", "Number of source files in test code (excluded via 'Production Code Filter').", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_SOURCEFILES_ISSUE_IGNORE = new CoreMetricId("Number of Source Files (Ignoring Issue)", "Number of source files excluded via 'Issue Filter' that no issues (except parser issues and architecture violations) are generated for.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_SOURCEFILES_EXCLUDED = new CoreMetricId("Number of Excluded Source Files", "Number of source files excluded via 'File Filter'. These files are completely excluded from the analysis and do not contribute to any metric.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_MODULES = new CoreMetricId("Number of Modules", "Number of modules.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.SIZE);
    public static final /* enum */ CoreMetricId CORE_CCN = new CoreMetricId("Cyclomatic Complexity", "Cyclomatic complexity according to Thomas J. McCabe. Number of decision points in a method plus one for the method entry.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.THOMAS_MCCABE);
    public static final /* enum */ CoreMetricId CORE_MODIFIED_CCN = new CoreMetricId("Modified Cyclomatic Complexity", "As cyclomatic complexity but switch statements only add 1 independent from the number of cases.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.THOMAS_MCCABE);
    public static final /* enum */ CoreMetricId CORE_EXTENDED_CCN = new CoreMetricId("Extended Cyclomatic Complexity", "As cyclomatic complexity adding the number of logical '&&' and '||' operations.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.THOMAS_MCCABE);
    public static final /* enum */ CoreMetricId CORE_MODIFIED_EXTENDED_CCN = new CoreMetricId("Modified Extended Cyclomatic Complexity", "As cyclomatic complexity but switch statements only add 1 independent from the number of cases and adding the number of logical '&&' and '||' operations.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.THOMAS_MCCABE);
    public static final /* enum */ CoreMetricId CORE_AVERAGE_COMPLEXITY = new CoreMetricId("Average Complexity", "Weighted average modified extended cyclomatic complexity for fully analyzed code", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.THOMAS_MCCABE);
    public static final /* enum */ CoreMetricId CORE_AVERAGE_COMPLEXITY_SYSTEM = new CoreMetricId("Average Complexity (System)", "Weighted average modified extended cyclomatic complexity for fully analyzed code on system level", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.THOMAS_MCCABE);
    public static final /* enum */ CoreMetricId CORE_AVERAGE_COMPLEXITY_MODULE = new CoreMetricId("Average Complexity (Module)", "Weighted average modified extended cyclomatic complexity for fully analyzed code on module level", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.THOMAS_MCCABE);
    public static final /* enum */ CoreMetricId CORE_RELATIONAL_COHESION_SYSTEM = new CoreMetricId("Relational Cohesion (System)", "Relation cohesion according to Craig Larman (adapted). Number of internal namespace dependencies divided by the number of top-level logical programming elements in the same namespace on system level. Higher numbers suggest more cohesion. ", true, IMetricId.StandardSorting.LOWER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.CRAIG_LARMAN, MetricCategory.COHESION_AND_COUPLING);
    public static final /* enum */ CoreMetricId CORE_RELATIONAL_COHESION_MODULE = new CoreMetricId("Relational Cohesion (Module)", "Relation cohesion according to Craig Larman (adapted). Number of internal namespace dependencies divided by the number of top-level logical programming elements in the same namespace on module level. Higher numbers suggest more cohesion. ", true, IMetricId.StandardSorting.LOWER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.CRAIG_LARMAN, MetricCategory.COHESION_AND_COUPLING);
    public static final /* enum */ CoreMetricId CORE_LCOM4 = new CoreMetricId("LCOM4", "Determines the number of components in a class. A component is composed of fields, methods and types defined top level including all their nested programming elements. Constructors, destructors, empty, abstract and overridden methods of classes are not included in the calculation. The metric represents the unrelated portions of code in a class. A value of 1 indicates the highest cohesion possible - which is normally desirable. High values might indicate that a class is a candidate for a refactoring. Consider that utility classes by nature have high LCOM4 values.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.COHESION_AND_COUPLING);
    public static final /* enum */ CoreMetricId CORE_LOGICAL_COHESION_MODULE = new CoreMetricId("Logical Cohesion (Module)", "Number of dependencies 'to' and 'from' other top-level logical programming elements in the same namespace on module level.", false, IMetricId.StandardSorting.LOWER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.COHESION_AND_COUPLING);
    public static final /* enum */ CoreMetricId CORE_LOGICAL_COUPLING_MODULE = new CoreMetricId("Logical Coupling (Module)", "Number of dependencies 'to' and 'from' other top-level logical programming elements in other namespaces on module level.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.COHESION_AND_COUPLING);
    public static final /* enum */ CoreMetricId CORE_LOGICAL_COHESION_SYSTEM = new CoreMetricId("Logical Cohesion (System)", "Number of dependencies 'to' and 'from' other top-level logical programming elements in the same namespace on system level.", false, IMetricId.StandardSorting.LOWER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.COHESION_AND_COUPLING);
    public static final /* enum */ CoreMetricId CORE_LOGICAL_COUPLING_SYSTEM = new CoreMetricId("Logical Coupling (System)", "Number of dependencies 'to' and 'from' other top-level logical programming elements in other namespaces on system level.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.COHESION_AND_COUPLING);
    public static final /* enum */ CoreMetricId CORE_PHYSICAL_COHESION = new CoreMetricId("Physical Cohesion", "Number of dependencies 'to' and 'from' other components in the same module.", false, IMetricId.StandardSorting.LOWER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.COHESION_AND_COUPLING);
    public static final /* enum */ CoreMetricId CORE_PHYSICAL_COUPLING = new CoreMetricId("Physical Coupling", "Number of dependencies 'to' and 'from' other components in other modules.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.COHESION_AND_COUPLING);
    public static final /* enum */ CoreMetricId CORE_COMPONENT_CYCLE_GROUPS = new CoreMetricId("Number of Component Cycle Groups", "Number of all component cycle groups, warnings and errors.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_CRITICAL_COMPONENT_CYCLE_GROUPS = new CoreMetricId("Number of Critical Component Cycle Groups", "Number of component cycle groups marked as errors.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_CYCLIC_COMPONENTS = new CoreMetricId("Number of Cyclic Components", "Number of cyclic components.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_CYCLIC_MODULES = new CoreMetricId("Number of Cyclic Modules", "Number of cyclic modules.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_IGNORED_CYCLIC_COMPONENTS = new CoreMetricId("Number of Ignored Cyclic Components", "Number of ignored cyclic components.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_BIGGEST_COMPONENT_CYCLE_GROUP = new CoreMetricId("Biggest Component Cycle Group", "Number of components in biggest cycle.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_STRUCTURAL_DEBT_INDEX_COMPONENTS = new CoreMetricId("Structural Debt Index (Components)", "Cumulative structural debt index of component cycles.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CODE_ANALYSIS);
    public static final /* enum */ CoreMetricId CORE_PARSER_DEPENDENCIES_TO_REMOVE_COMPONENTS = new CoreMetricId("Parser Dependencies to Remove (Components)", "Number of code lines to change to break up all  component cycles.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CODE_ANALYSIS, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_COMPONENT_DEPENDENCIES_TO_REMOVE_COMPONENTS = new CoreMetricId("Component Dependencies to Remove (Components)", "Number of component dependencies to remove to break up all  component cycles.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CODE_ANALYSIS, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_CYCLICITY_COMPONENTS = new CoreMetricId("Cyclicity (Components)", "Cumulated cyclicity of component cycles.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_RELATIVE_CYCLICITY_COMPONENTS = new CoreMetricId("Relative Cyclicity (Components)", "Relative component cyclicity in percent.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_RELATIVE_ENTANGLEMENT = new CoreMetricId("Relative Entanglement (%)", "Computed as the sum of relative cyclicities on component and namespace/directory levels, with each level contributing 50%. If the system contains several languages, the namespace/directory values per language are weighted against the lines of code contributed by the language. High values are an indicator for very large cycle groups.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_CRITICAL_ENTANGLED_LINES_OF_CODE = new CoreMetricId("Critically Entangled Lines of Code", "Lines of code of source files involved any type of critical cycle (marked as error).", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_ENTANGLED_LINES_OF_CODE = new CoreMetricId("Entangled Lines of Code", "Lines of code of source files involved any type of cycle.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_PERCENT = new CoreMetricId("Critically Entangled Lines of Code (%)", "Percentage of fully analyzed code contained in source files involved any type of critical cycle (marked as error). This also represents the probability that any line is involved in critically entangled code.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_ENTANGLED_LINES_OF_CODE_PERCENT = new CoreMetricId("Entangled Lines of Code (%)", "Percentage of fully analyzed code contained in source files involved in any type of cycle. This also represents the probability that any line is involved in entangled code.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_IGNORED = new CoreMetricId("Critically Entangled Lines of Code [Ignored]", "Lines of code of source files involved in any type of ignored critical cycle (marked as error).", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_ENTANGLED_LINES_OF_CODE_PERCENT_IGNORED = new CoreMetricId("Entangled Lines of Code [Ignored] (%)", "Percentage of fully analyzed code contained in source files involved in any type of ignored cycle. This also represents the probability that any line is involved in ignored entangled code.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_ENTANGLED_LINES_OF_CODE_IGNORED = new CoreMetricId("Entangled Lines of Code [Ignored]", "Lines of code of source files involved in any type of ignored cycle.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_PERCENT_IGNORED = new CoreMetricId("Critically Entangled Lines of Code [Ignored] (%)", "Percentage of fully analyzed code contained in source files involved in any type of ignored critical cycle (marked as error). This also represents the probability that any line is involved in ignored critically entangled code.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_ENTANGLED_LINES_OF_CODE_PERCENT_TO_FIX = new CoreMetricId("Entangled Lines of Code [To Be Fixed] (%)", "Percentage of fully analyzed code contained in source files involved any type of to be fixed cycle. This also represents the probability that any line is involved in to be fixed entangled code.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_TO_FIX = new CoreMetricId("Critically Entangled Lines of Code [To Be Fixed]", "Lines of code of source files involved any type of to be fixed critical cycle (marked as error).", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_ENTANGLED_LINES_OF_CODE_TO_FIX = new CoreMetricId("Entangled Lines of Code [To Be Fixed]", "Lines of code of source files involved any type of to be fixed cycle.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_PERCENT_TO_FIX = new CoreMetricId("Critically Entangled Lines of Code [To Be Fixed] (%)", "Percentage of fully analyzed code contained in source files involved any type of to be fixed critical cycle (marked as error). This also represents the probability that any line is involved in to be fixed critically entangled code.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_BIGGEST_CYCLE_LOC = new CoreMetricId("Maximum Lines of Code Involved in a Cycle", "Biggest cycle group with respect to the lines of code of involved source files.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CYCLE);
    public static final /* enum */ CoreMetricId CORE_COMPONENT_RANK_MODULE = new CoreMetricId("Component Rank (Module)", "Component Rank is based on Google's page rank algorithm. The total component rank over all components in the selected group adds up to 100. The higher the rank, the more 'important' a component is in a system. Having many incoming dependencies or being referenced by other important components increases rank.", true, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.PERCENTAGE, MetricScope.MODULE, MetricCategory.CODE_ANALYSIS);
    public static final /* enum */ CoreMetricId CORE_COMPONENT_RANK_SYSTEM = new CoreMetricId("Component Rank (System)", "Component Rank is based on Google's page rank algorithm. The total component rank over all components in the selected group adds up to 100. The higher the rank, the more 'important' a component is in a system. Having many incoming dependencies or being referenced by other important components increases rank.", true, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.PERCENTAGE, MetricScope.SYSTEM, MetricCategory.CODE_ANALYSIS);
    public static final /* enum */ CoreMetricId CORE_MAX_NESTING = new CoreMetricId("Max Block Nesting Depth", "Nesting depth is a good complexity indicator. Minimum value is zero, each nesting level adds 1.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.CODE_ANALYSIS);
    public static final /* enum */ CoreMetricId CORE_AVERAGE_NESTING = new CoreMetricId("Average Block Nesting Depth", "Weighted average of nesting depth.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.CODE_ANALYSIS);
    public static final /* enum */ CoreMetricId CORE_INCOMING_DEPENDENCIES_MODULE = new CoreMetricId("Number of Incoming Dependencies (Module)", "Number of incoming dependencies on module level.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.ROBERT_MARTIN);
    public static final /* enum */ CoreMetricId CORE_OUTGOING_DEPENDENCIES_MODULE = new CoreMetricId("Number of Outgoing Dependencies (Module)", "Number of outgoing dependencies on module level.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.ROBERT_MARTIN);
    public static final /* enum */ CoreMetricId CORE_INCOMING_DEPENDENCIES_SYSTEM = new CoreMetricId("Number of Incoming Dependencies (System)", "Number of incoming dependencies on system level.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.ROBERT_MARTIN);
    public static final /* enum */ CoreMetricId CORE_OUTGOING_DEPENDENCIES_SYSTEM = new CoreMetricId("Number of Outgoing Dependencies (System)", "Number of outgoing dependencies on system level.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.ROBERT_MARTIN);
    public static final /* enum */ CoreMetricId CORE_INSTABILITY_MODULE = new CoreMetricId("Instability (Module)", "Instability according to Robert C. Martin based on module level dependencies. The metric has a range of [0,1]. If there are no outgoing dependencies, then the Instability will be 0 and the measured element is stable. If there are no incoming dependencies, then the Instability will be 1 and the measured element is instable. Stable means that the element is not so easy to be changed. Instable means that it is easier to be changed.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.ROBERT_MARTIN);
    public static final /* enum */ CoreMetricId CORE_DISTANCE_MODULE = new CoreMetricId("Distance (Module)", "Distance according to Robert C. Martin based on module level dependencies. Abstractness + Instability - 1. The metric has a range of [-1,1]. This is a variation of the original metric definition. A negative sign means 'in the zone of pain' and a positive sign means 'in the zone of uselessness'. A 'good' value should be around 0.", true, IMetricId.StandardSorting.OPTIMUM_AT_ZERO, IMetricId.MetricRange.MINUS_ONE_TO_ONE, MetricScope.MODULE, MetricCategory.ROBERT_MARTIN);
    public static final /* enum */ CoreMetricId CORE_INSTABILITY_SYSYTEM = new CoreMetricId("Instability (System)", "Instability according to Robert C. Martin based on system level dependencies. The metric has a range of [0,1]. If there are no outgoing dependencies, then I will be 0 and the measured element is stable. If there are no incoming dependencies, then I will be 1 and the measured element is instable. Stable means that the element is not so easy to be changed. Instable means that it is easier to be changed. ", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.ZERO_TO_ONE, MetricScope.SYSTEM, MetricCategory.ROBERT_MARTIN);
    public static final /* enum */ CoreMetricId CORE_DISTANCE_SYSTEM = new CoreMetricId("Distance (System)", "Distance according to Robert C. Martin based on system level dependencies. Abstractness + Instability - 1. The metric has a range of [-1,1]. This is a variation of the original metric definition. A negative sign means 'in the zone of pain' and a positive sign means 'in the zone of uselessness'. A 'good' value should be around 0.", true, IMetricId.StandardSorting.OPTIMUM_AT_ZERO, IMetricId.MetricRange.MINUS_ONE_TO_ONE, MetricScope.SYSTEM, MetricCategory.ROBERT_MARTIN);
    public static final /* enum */ CoreMetricId CORE_ABSTRACTNESS_MODULE = new CoreMetricId("Abstractness (Module)", "Abstractness according to Robert C. Martin based on module level dependencies. Total number of abstract types divided by the total number of concrete types. The metric has a range of [0,1]. 0 means that the container contains no abstract types. 1 means that the container contains nothing but abstract types.", true, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.ZERO_TO_ONE, MetricScope.MODULE, MetricCategory.ROBERT_MARTIN);
    public static final /* enum */ CoreMetricId CORE_ABSTRACTNESS_SYSTEM = new CoreMetricId("Abstractness (System)", "Abstractness according to Robert C. Martin based on system level dependencies. Total number of abstract types divided by the total number of concrete types. The metric has a range of [0,1]. 0 means that the container contains no abstract types. 1 means that the container contains nothing but abstract types.", true, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.ZERO_TO_ONE, MetricScope.SYSTEM, MetricCategory.ROBERT_MARTIN);
    public static final /* enum */ CoreMetricId CORE_MAX_ACD = new CoreMetricId("Highest ACD", "Highest module ACD.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.COHESION_AND_COUPLING, MetricCategory.JOHN_LAKOS);
    public static final /* enum */ CoreMetricId CORE_ACD = new CoreMetricId("ACD", "Average component dependency according to John Lakos. Average number of components a component depends on directly and indirectly. This metric can be used to characterize the overall average coupling of internal components.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.COHESION_AND_COUPLING, MetricCategory.JOHN_LAKOS);
    public static final /* enum */ CoreMetricId CORE_CCD = new CoreMetricId("CCD", "Cumulative component dependency according to John Lakos. Cumulated depends upon values.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.COHESION_AND_COUPLING, MetricCategory.JOHN_LAKOS);
    public static final /* enum */ CoreMetricId CORE_NCCD = new CoreMetricId("NCCD", "Normalized cumulative component dependency  according to John Lakos. The ratio between the cumulative component dependency and the cumulative component dependency of a balanced binary tree of the same size. A value greater than 1 indicates a more vertical design. A value less than 1 indicates a more horizontal design.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.COHESION_AND_COUPLING, MetricCategory.JOHN_LAKOS);
    public static final /* enum */ CoreMetricId CORE_DEPENDS_UPON_MODULE = new CoreMetricId("Depends Upon (Module)", "Depends upon module level according to DependsOn by John Lakos. Total number of components that a component directly and indirectly depends upon in containing module.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.COHESION_AND_COUPLING, MetricCategory.JOHN_LAKOS);
    public static final /* enum */ CoreMetricId CORE_USED_FROM_MODULE = new CoreMetricId("Used From (Module)", "Number of all depending elements (direct and indirect) + 1 (including self) in containing module.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.COHESION_AND_COUPLING, MetricCategory.JOHN_LAKOS);
    public static final /* enum */ CoreMetricId CORE_DEPENDS_UPON_SYSTEM = new CoreMetricId("Depends Upon (System)", "Depends upon system level according to DependsOn by John Lakos. Total number of components that a component directly and indirectly depends upon in system.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.COHESION_AND_COUPLING, MetricCategory.JOHN_LAKOS);
    public static final /* enum */ CoreMetricId CORE_USED_FROM_SYSTEM = new CoreMetricId("Used From (System)", "Number of all depending elements (direct and indirect) + 1 (including self) in system.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.COHESION_AND_COUPLING, MetricCategory.JOHN_LAKOS);
    public static final /* enum */ CoreMetricId CORE_FAN_OUT_MODULE = new CoreMetricId("Fan Out Visibility (Module)", "Percentage of components in the same module that this component depends upon.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.COHESION_AND_COUPLING, MetricCategory.MAC_CORMACK);
    public static final /* enum */ CoreMetricId CORE_FAN_OUT_SYSTEM = new CoreMetricId("Fan Out Visibility (System)", "Percentage of internal components in the system that this component depends upon.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.COHESION_AND_COUPLING, MetricCategory.MAC_CORMACK);
    public static final /* enum */ CoreMetricId CORE_FAN_IN_MODULE = new CoreMetricId("Fan In Visibility (Module)", "Percentage of components in the same module that depend directly or indirectly on this component.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.COHESION_AND_COUPLING, MetricCategory.MAC_CORMACK);
    public static final /* enum */ CoreMetricId CORE_FAN_IN_SYSTEM = new CoreMetricId("Fan In Visibility (System)", "Percentage of internal components in the system that depend directly or indirectly on this component.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.SYSTEM, MetricCategory.COHESION_AND_COUPLING, MetricCategory.MAC_CORMACK);
    public static final /* enum */ CoreMetricId CORE_PROPAGATION_COST = new CoreMetricId("Propagation Cost", "Propagation cost metric according to MacCormack, Rusnak and Baldwin. It describes the proportion of software files that are directly or indirectly linked to each other.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.COHESION_AND_COUPLING, MetricCategory.MAC_CORMACK);
    public static final /* enum */ CoreMetricId CORE_MAINTAINABILITY_LEVEL = new CoreMetricId("Maintainability Level", "This metric estimates maintainability as a percentage. 100% is the best possible value. To do that it looks at the dependency structure between components (source files in most languages). Cyclic dependencies and low level classes with a lot of incoming dependencies have a negative influence on the metric. Keeping good vertical boundaries and not having too many layers will have a positive influence. It is also recommended to have as many components as possible that are independent, i.e. have no incoming dependencies and therefore can be changed without influencing the rest of the system. In Java and C# the metric also considers the value of the relative cyclicity metric for packages/namespaces. If you have large cycle groups they will have a negative influence on the metric value.", true, IMetricId.StandardSorting.LOWER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.COHESION_AND_COUPLING);
    public static final /* enum */ CoreMetricId CORE_ML_FAN_IN_MODULE = new CoreMetricId("Fan In Maintainability Level (Module)", "Percentage of higher-level components in the same module that depend directly or indirectly on this component.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricScope.MODULE, MetricCategory.COHESION_AND_COUPLING);
    public static final /* enum */ CoreMetricId CORE_REDUNDANCY = new CoreMetricId("Redundant Code (%)", "Percentage of redundant code. This also represents the probability that any line is contained in a duplicate. This metric is calculated for fully analyzed code.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.CODE_ANALYSIS);
    public static final /* enum */ CoreMetricId CORE_REDUNDANCY_IGNORED = new CoreMetricId("Redundant Code [Ignored] (%)", "Percentage of ignored redundant code. This also represents the probability that any line is contained in an ignored duplicate. This metric is calculated for fully analyzed code.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.CODE_ANALYSIS);
    public static final /* enum */ CoreMetricId CORE_REDUNDANCY_FIXED = new CoreMetricId("Redundant Code [To Be Fixed] (%)", "Percentage of redundant code with an assigned \"Fix\" task. This also represents the probability that any line is contained in a to-be-fixed duplicate. This metric is calculated for fully analyzed code.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.CODE_ANALYSIS);
    public static final /* enum */ CoreMetricId CORE_DUPLICATES = new CoreMetricId("Number of Code Duplicates", "Number of duplicated code blocks.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CODE_ANALYSIS);
    public static final /* enum */ CoreMetricId CORE_DUPLICATED_LINES = new CoreMetricId("Number of Duplicated Code Lines", "Number of duplicated lines in duplicated code blocks. The duplicated lines of each code block are calculated as the sum of involved occurrences excluding the largest, which is treated as the reference.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CODE_ANALYSIS);
    public static final /* enum */ CoreMetricId CORE_IGNORED_DUPLICATES = new CoreMetricId("Number of Ignored Code Duplicates", "Number of ignored duplicated code blocks.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CODE_ANALYSIS);
    public static final /* enum */ CoreMetricId CORE_DUPLICATES_FIXED = new CoreMetricId("Number of Code Duplicates to be Fixed", "Number of duplicated code blocks with applied Fix task.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CODE_ANALYSIS);
    public static final /* enum */ CoreMetricId CORE_UNASSIGNED_COMPONENTS = new CoreMetricId("Number of Unassigned Physical Components", "Number of internal physical components that are not assigned to any artifact", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_UNASSIGNED_LOGICAL_ELEMENTS = new CoreMetricId("Number of Unassigned Logical Elements", "Number of internal logical elements that are not assigned to any artifact", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_COMPONENTS_IN_DEPRECATED_ARTIFACTS = new CoreMetricId("Number of Components in Deprecated Artifacts", "Number of components that are assigned to deprecated artifact", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_ELEMENTS_IN_DEPRECATED_ARTIFACTS = new CoreMetricId("Number of Logical Elements in Deprecated Artifacts", "Number of logical programming elements that are assigned to deprecated artifact", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_VIOLATIONS_COMPONENT_DEPENDENCIES = new CoreMetricId("Number of Violations (Component Dependencies)", "Number of architecture-violating component dependencies", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_VIOLATING_COMPONENTS = new CoreMetricId("Number of Components with Violations", "Number of components that contain architecture violations", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_VIOLATIONS_PARSER_DEPENDENCIES = new CoreMetricId("Number of Violations (Parser Dependencies)", "Number of architecture-violating parser dependencies", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_DEPRECATED_PARSER_DEPENDENCIES = new CoreMetricId("Deprecated parser dependencies", "Number of deprecated parser dependencies", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_IGNORED_VIOLATIONS_PARSER_DEPENDENCIES = new CoreMetricId("Number of Ignored Violations (Parser Dependencies)", "Number of parser dependencies in ignored architecture violations", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_IGNORED_DEPRECATED_PARSER_DEPENDENCIES = new CoreMetricId("Ignored Deprecated Parser Dependencies", "Number of parser dependencies in ignored architecture deprecations", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_ARTIFACT_COUNT = new CoreMetricId("Number of Artifacts", "Number of architecture artifacts in checked files", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_EMPTY_ARTIFACT_COUNT = new CoreMetricId("Number of Empty Artifacts", "Number of architecture artifacts that are empty in checked files", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_VIOLATING_LINES_OF_CODE_PERCENT = new CoreMetricId("Code Contained in Files with Violations (%)", "Percentage of lines of code contained in files with at least one violation. This metric is calculated for code that is fully analyzed plus code that is excluded by the 'Issue Filter'.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_DEPRECATED_OR_VIOLATING_LINES_OF_CODE_PERCENT = new CoreMetricId("Code Contained in Files with Violations or Deprecations (%)", "Percentage of lines of code contained in files with at least one violation or deprecation.This metric is calculated for code that is fully analyzed plus code that is excluded by the 'Issue Filter'.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_VIOLATING_LINES_OF_CODE = new CoreMetricId("Lines of Code in Files with Violations", "Lines of code contained in files with at least one violation. This metric is calculated for code that is fully analyzed plus code that is excluded by the 'Issue Filter'.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_DEPRECATED_OR_VIOLATING_LINES_OF_CODE = new CoreMetricId("Lines of Code in Files with Violations or Deprecations (%)", "Lines of code contained in files with at least one violation or deprecation.This metric is calculated for code that is fully analyzed plus code that is excluded by the 'Issue Filter'.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_UNASSIGNED_LINES_OF_CODE_PERCENT = new CoreMetricId("Code Contained in Files Uncovered by Architecture (%)", "Percentage of lines of code contained in files not assigned to any architecture artifact. This metric is calculated for code that is fully analyzed plus code that is excluded by the 'Issue Filter'.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_VIOLATION_DENSITY_SOURCE_ELEMENTS = new CoreMetricId("Architecture Violation Density (Source Elements)", "Number of architecture violations per 1000 source elements. This metric is calculated for code that is fully analyzed plus code that is excluded by the 'Issue Filter'.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_VIOLATION_DENSITY_LINES_OF_CODE = new CoreMetricId("Architecture Violation Density", "Number of architecture violations per 1000 lines of code. This metric is calculated for code that is fully analyzed plus code that is excluded by the 'Issue Filter'.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricCategory.ARCHITECTURE);
    public static final /* enum */ CoreMetricId CORE_CHANGES_30 = new CoreMetricId("File Changes (30d)", "Number of committed file changes in the last 30 days", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CHANGES_90 = new CoreMetricId("File Changes (90d)", "Number of committed file changes in the last 90 days", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CHANGES_365 = new CoreMetricId("File Changes (365d)", "Number of committed file changes in the last 365 days", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CHANGES_2Y = new CoreMetricId("File Changes (2y)", "Number of committed file changes in the last 2 years", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CHANGES_5Y = new CoreMetricId("File Changes (5y)", "Number of committed file changes in the last 5 years", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CODE_CHURN_RATE_30 = new CoreMetricId("Code Churn Rate (30d)", "Percentage of lines added or removed in the last 30 days based on total lines", true, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CODE_CHURN_RATE_90 = new CoreMetricId("Code Churn Rate (90d)", "Percentage of lines added or removed in the last 90 days based on total lines", true, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CODE_CHURN_RATE_365 = new CoreMetricId("Code Churn Rate (365d)", "Percentage of lines added or removed in the last 365 days based on total lines", true, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CODE_CHURN_RATE_2Y = new CoreMetricId("Code Churn Rate (2y)", "Percentage of lines added or removed in the last 2 years based on total lines", true, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CODE_CHURN_RATE_5Y = new CoreMetricId("Code Churn Rate (5y)", "Percentage of lines added or removed in the last 5 years based on total lines", true, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CODE_CHURN_30 = new CoreMetricId("Code Churn (30d)", "Number of lines added or removed in the last 30 days", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CODE_CHURN_90 = new CoreMetricId("Code Churn (90d)", "Number of lines added or removed in the last 90 days", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CODE_CHURN_365 = new CoreMetricId("Code Churn (365d)", "Number of lines added or removed in the last 365 days", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CODE_CHURN_2Y = new CoreMetricId("Code Churn (2y)", "Number of lines added or removed in the last 2 years", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_CODE_CHURN_5Y = new CoreMetricId("Code Churn (5y)", "Number of lines added or removed in the last 5 years", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_NUMBER_OF_AUTHORS_30 = new CoreMetricId("Number of Authors (30d)", "Number of developers who have worked on this item in the last 30 days", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_NUMBER_OF_AUTHORS_90 = new CoreMetricId("Number of authors (90d)", "Number of developers who have worked on this item in the last 90 days", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_NUMBER_OF_AUTHORS = new CoreMetricId("Number of authors (365d)", "Number of developers who have worked on this item in the last year", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_NUMBER_OF_AUTHORS_2Y = new CoreMetricId("Number of authors (2y)", "Number of developers who have worked on this item in the last 2 years", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_NUMBER_OF_AUTHORS_5Y = new CoreMetricId("Number of authors (5y)", "Number of developers who have worked on this item in the last 5 years", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_DAYS_SINCE_LAST_COMMIT = new CoreMetricId("Days since last commit", "Days since this file was last changed (9999 means no changes in the last 5 years)", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CHANGE_HISTORY);
    public static final /* enum */ CoreMetricId CORE_ISSUE_DENSITY = new CoreMetricId("Issue Density", "Calculated as the number of unresolved issues (errors, warnings) * 1000, divided by source element count", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, MetricCategory.CODE_ANALYSIS);
    private final String m_presentationName;
    private final String m_description;
    private final boolean m_isFloat;
    private final IMetricId.StandardSorting m_sorting;
    private final IMetricId.MetricRange m_range;
    private final IMetricCategory[] m_categories;
    private final MetricScope m_metricScope;
    private static final /* synthetic */ CoreMetricId[] ENUM$VALUES;

    static {
        ENUM$VALUES = new CoreMetricId[]{CORE_SOURCE_ELEMENT_COUNT, CORE_LINES_OF_CODE, CORE_LINES_OF_CODE_FULLY_ANALYZED, CORE_LINES_OF_CODE_ISSUE_IGNORING, CORE_COMMENT_LINES, CORE_CODE_COMMENT_LINES, CORE_TOTAL_LINES, CORE_LINES_OF_CODE_IN_LARGE_FILES, CORE_LINES_OF_CODE_IN_LARGE_FILES_PERCENT, CORE_LINES_OF_CODE_IN_LARGE_FILES_IGNORED, CORE_LINES_OF_CODE_IN_LARGE_FILES_IGNORED_PERCENT, CORE_LINES_OF_CODE_IN_LARGE_FILES_TO_FIX, CORE_LINES_OF_CODE_IN_LARGE_FILES_TO_FIX_PERCENT, CORE_STATEMENTS, CORE_STATEMENTS_FULLY_ANALYZED, CORE_STATEMENTS_COMPLEX_METHODS, CORE_STATEMENTS_COMPLEX_METHODS_PERCENT, CORE_STATEMENTS_COMPLEX_METHODS_IGNORED, CORE_STATEMENTS_COMPLEX_METHODS_IGNORED_PERCENT, CORE_STATEMENTS_COMPLEX_METHODS_TO_FIX, CORE_STATEMENTS_COMPLEX_METHODS_TO_FIX_PERCENT, CORE_PARAMETERS, CORE_COMPONENTS, CORE_COMPONENTS_FULLY_ANALYZED, CORE_COMPONENTS_IGNORING_ISSUES, CORE_METHODS, CORE_TYPES, CORE_TYPES_MODULE, CORE_TYPES_SYSTEM, CORE_SOURCEFILES, CORE_SOURCEFILES_FULLY_ANALYZED, CORE_SOURCEFILES_TEST, CORE_SOURCEFILES_ISSUE_IGNORE, CORE_SOURCEFILES_EXCLUDED, CORE_MODULES, CORE_CCN, CORE_MODIFIED_CCN, CORE_EXTENDED_CCN, CORE_MODIFIED_EXTENDED_CCN, CORE_AVERAGE_COMPLEXITY, CORE_AVERAGE_COMPLEXITY_SYSTEM, CORE_AVERAGE_COMPLEXITY_MODULE, CORE_RELATIONAL_COHESION_SYSTEM, CORE_RELATIONAL_COHESION_MODULE, CORE_LCOM4, CORE_LOGICAL_COHESION_MODULE, CORE_LOGICAL_COUPLING_MODULE, CORE_LOGICAL_COHESION_SYSTEM, CORE_LOGICAL_COUPLING_SYSTEM, CORE_PHYSICAL_COHESION, CORE_PHYSICAL_COUPLING, CORE_COMPONENT_CYCLE_GROUPS, CORE_CRITICAL_COMPONENT_CYCLE_GROUPS, CORE_CYCLIC_COMPONENTS, CORE_CYCLIC_MODULES, CORE_IGNORED_CYCLIC_COMPONENTS, CORE_BIGGEST_COMPONENT_CYCLE_GROUP, CORE_STRUCTURAL_DEBT_INDEX_COMPONENTS, CORE_PARSER_DEPENDENCIES_TO_REMOVE_COMPONENTS, CORE_COMPONENT_DEPENDENCIES_TO_REMOVE_COMPONENTS, CORE_CYCLICITY_COMPONENTS, CORE_RELATIVE_CYCLICITY_COMPONENTS, CORE_RELATIVE_ENTANGLEMENT, CORE_CRITICAL_ENTANGLED_LINES_OF_CODE, CORE_ENTANGLED_LINES_OF_CODE, CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_PERCENT, CORE_ENTANGLED_LINES_OF_CODE_PERCENT, CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_IGNORED, CORE_ENTANGLED_LINES_OF_CODE_PERCENT_IGNORED, CORE_ENTANGLED_LINES_OF_CODE_IGNORED, CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_PERCENT_IGNORED, CORE_ENTANGLED_LINES_OF_CODE_PERCENT_TO_FIX, CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_TO_FIX, CORE_ENTANGLED_LINES_OF_CODE_TO_FIX, CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_PERCENT_TO_FIX, CORE_BIGGEST_CYCLE_LOC, CORE_COMPONENT_RANK_MODULE, CORE_COMPONENT_RANK_SYSTEM, CORE_MAX_NESTING, CORE_AVERAGE_NESTING, CORE_INCOMING_DEPENDENCIES_MODULE, CORE_OUTGOING_DEPENDENCIES_MODULE, CORE_INCOMING_DEPENDENCIES_SYSTEM, CORE_OUTGOING_DEPENDENCIES_SYSTEM, CORE_INSTABILITY_MODULE, CORE_DISTANCE_MODULE, CORE_INSTABILITY_SYSYTEM, CORE_DISTANCE_SYSTEM, CORE_ABSTRACTNESS_MODULE, CORE_ABSTRACTNESS_SYSTEM, CORE_MAX_ACD, CORE_ACD, CORE_CCD, CORE_NCCD, CORE_DEPENDS_UPON_MODULE, CORE_USED_FROM_MODULE, CORE_DEPENDS_UPON_SYSTEM, CORE_USED_FROM_SYSTEM, CORE_FAN_OUT_MODULE, CORE_FAN_OUT_SYSTEM, CORE_FAN_IN_MODULE, CORE_FAN_IN_SYSTEM, CORE_PROPAGATION_COST, CORE_MAINTAINABILITY_LEVEL, CORE_ML_FAN_IN_MODULE, CORE_REDUNDANCY, CORE_REDUNDANCY_IGNORED, CORE_REDUNDANCY_FIXED, CORE_DUPLICATES, CORE_DUPLICATED_LINES, CORE_IGNORED_DUPLICATES, CORE_DUPLICATES_FIXED, CORE_UNASSIGNED_COMPONENTS, CORE_UNASSIGNED_LOGICAL_ELEMENTS, CORE_COMPONENTS_IN_DEPRECATED_ARTIFACTS, CORE_ELEMENTS_IN_DEPRECATED_ARTIFACTS, CORE_VIOLATIONS_COMPONENT_DEPENDENCIES, CORE_VIOLATING_COMPONENTS, CORE_VIOLATIONS_PARSER_DEPENDENCIES, CORE_DEPRECATED_PARSER_DEPENDENCIES, CORE_IGNORED_VIOLATIONS_PARSER_DEPENDENCIES, CORE_IGNORED_DEPRECATED_PARSER_DEPENDENCIES, CORE_ARTIFACT_COUNT, CORE_EMPTY_ARTIFACT_COUNT, CORE_VIOLATING_LINES_OF_CODE_PERCENT, CORE_DEPRECATED_OR_VIOLATING_LINES_OF_CODE_PERCENT, CORE_VIOLATING_LINES_OF_CODE, CORE_DEPRECATED_OR_VIOLATING_LINES_OF_CODE, CORE_UNASSIGNED_LINES_OF_CODE_PERCENT, CORE_VIOLATION_DENSITY_SOURCE_ELEMENTS, CORE_VIOLATION_DENSITY_LINES_OF_CODE, CORE_CHANGES_30, CORE_CHANGES_90, CORE_CHANGES_365, CORE_CHANGES_2Y, CORE_CHANGES_5Y, CORE_CODE_CHURN_RATE_30, CORE_CODE_CHURN_RATE_90, CORE_CODE_CHURN_RATE_365, CORE_CODE_CHURN_RATE_2Y, CORE_CODE_CHURN_RATE_5Y, CORE_CODE_CHURN_30, CORE_CODE_CHURN_90, CORE_CODE_CHURN_365, CORE_CODE_CHURN_2Y, CORE_CODE_CHURN_5Y, CORE_NUMBER_OF_AUTHORS_30, CORE_NUMBER_OF_AUTHORS_90, CORE_NUMBER_OF_AUTHORS, CORE_NUMBER_OF_AUTHORS_2Y, CORE_NUMBER_OF_AUTHORS_5Y, CORE_DAYS_SINCE_LAST_COMMIT, CORE_ISSUE_DENSITY};
    }

    private CoreMetricId(String presentationName, String description, boolean isFloat, IMetricId.StandardSorting sorting, IMetricId.MetricRange range, MetricScope metricScope, IMetricCategory ... category) {
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'CoreMetricId' must not be empty";
        assert (description != null && description.length() > 0) : "Parameter 'description' of method 'CoreMetricId' must not be empty";
        assert (sorting != null) : "Parameter 'sorting' of method 'CoreMetricId' must not be null";
        assert (range != null) : "Parameter 'range' of method 'CoreMetricId' must not be null";
        assert (metricScope != null) : "Parameter 'metricScope' of method 'CoreMetricId' must not be null";
        assert (category != null && category.length > 0) : "Parameter 'category' of method 'CoreMetricId' must not be empty";
        this.m_presentationName = presentationName;
        this.m_description = description;
        this.m_isFloat = isFloat;
        this.m_metricScope = metricScope;
        this.m_categories = category;
        this.m_sorting = sorting;
        this.m_range = range;
    }

    private CoreMetricId(String presentationName, String description, boolean isFloat, IMetricId.StandardSorting sorting, IMetricId.MetricRange range, IMetricCategory ... category) {
        this(presentationName, description, isFloat, sorting, range, MetricScope.SYSTEM, category);
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    @Override
    public IProviderId getProvider() {
        return CoreProviderId.INSTANCE;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public boolean isFloat() {
        return this.m_isFloat;
    }

    @Override
    public MetricScope getMetricScope() {
        return this.m_metricScope;
    }

    @Override
    public IMetricId.MetricRange getRange() {
        return this.m_range;
    }

    @Override
    public IMetricId.StandardSorting getSorting() {
        return this.m_sorting;
    }

    @Override
    public List<IMetricCategory> getCategories() {
        return Arrays.asList(this.m_categories);
    }

    public static CoreMetricId[] values() {
        CoreMetricId[] coreMetricIdArray = ENUM$VALUES;
        int n2 = coreMetricIdArray.length;
        CoreMetricId[] coreMetricIdArray2 = new CoreMetricId[n2];
        System.arraycopy(ENUM$VALUES, 0, coreMetricIdArray2, 0, n2);
        return coreMetricIdArray2;
    }

    public static CoreMetricId valueOf(String string) {
        return Enum.valueOf(CoreMetricId.class, string);
    }
}

