/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.graphview;

import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DependenciesViewRepresentationInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DeprecationInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ViolationInfo;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewElement;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewStructureMode;
import com.hello2morrow.sonargraph.core.model.graphview.IGraphViewDependencyInfoProvider;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public final class GraphViewRepresentation
extends GraphViewElement
implements IGraphViewDependencyInfoProvider {
    private final DependenciesViewRepresentationInfo m_representationInfo = new DependenciesViewRepresentationInfo();
    private final GraphViewStructureMode m_structureMode;
    private final IAnalyzerId m_analyzerId;
    private final boolean m_cyclesAreExpandable;
    private Set<String> m_basedOnNamedElementFqNames;
    private boolean m_isValid = true;
    private boolean m_isBlocked = false;

    public GraphViewRepresentation(GraphViewStructureMode structureMode, IAnalyzerId analyzerId, boolean cyclesAreExpandable) {
        super(null);
        assert (structureMode != null) : "Parameter 'structureMode' of method 'GraphViewRepresentation' must not be null";
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'GraphViewRepresentation' must not be null";
        this.m_structureMode = structureMode;
        this.m_analyzerId = analyzerId;
        this.m_cyclesAreExpandable = cyclesAreExpandable;
    }

    public DependenciesViewRepresentationInfo getRepresentationInfo() {
        return this.m_representationInfo;
    }

    public void reset() {
        assert (this.m_basedOnNamedElementFqNames != null) : "'m_basedOnNamedElementFqNames' of method 'reset' must not be null";
        this.m_basedOnNamedElementFqNames = null;
        this.forgetChildren(true);
    }

    public void finishCreation(Set<String> basedOnNamedElementFqNames) {
        assert (basedOnNamedElementFqNames != null && !basedOnNamedElementFqNames.isEmpty()) : "Parameter 'basedOnNamedElementFqNames' of method 'finishCreation' must not be empty";
        assert (this.m_basedOnNamedElementFqNames == null) : "'m_basedOnNamedElementFqNames' of method 'finishCreation' must be null";
        this.m_basedOnNamedElementFqNames = new THashSet(basedOnNamedElementFqNames);
    }

    public Set<String> getBasedOnNamedElementFqNames() {
        assert (this.m_basedOnNamedElementFqNames != null) : "'m_basedOnNamedElementFqNames' of method 'getBasedOnNamedElementFqNames' must not be null";
        return Collections.unmodifiableSet(this.m_basedOnNamedElementFqNames);
    }

    public boolean cyclesAreExpandable() {
        return this.m_cyclesAreExpandable;
    }

    public GraphViewStructureMode getStructureMode() {
        return this.m_structureMode;
    }

    @Override
    public boolean contributesFullyQualifiedNamePartToRelativePath() {
        return false;
    }

    @Override
    public synchronized boolean isValid() {
        return this.m_isValid;
    }

    public synchronized void setInvalid() {
        assert (this.m_isValid) : "Already set to 'invalid': " + this;
        this.m_isValid = false;
    }

    public synchronized boolean isBlocked() {
        return this.m_isBlocked;
    }

    public synchronized void setBlocked() {
        assert (!this.m_isBlocked) : "Already set to 'blocked': " + this;
        this.m_isBlocked = true;
    }

    public synchronized void setUnblocked() {
        assert (this.m_isBlocked) : "Not 'blocked': " + this;
        this.m_isBlocked = false;
    }

    @Override
    public String getShortName() {
        return "Graph view representation";
    }

    public IAnalyzerId getAnalyzerId() {
        return this.m_analyzerId;
    }

    @Override
    public ViolationInfo isViolation(ParserDependency dependency) {
        return this.m_representationInfo.isViolation(dependency);
    }

    @Override
    public DeprecationInfo isDeprecation(ParserDependency dependency) {
        return this.m_representationInfo.isDeprecation(dependency);
    }

    @Override
    public Collection<Issue> getIssues(ParserDependency parserDependency) {
        return this.m_representationInfo.getIssues(parserDependency);
    }

    public boolean clearDependencyInfo(boolean clearIgnoredAndToBeFixed) {
        return this.m_representationInfo.clearDependencyInfo(clearIgnoredAndToBeFixed);
    }
}

