/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.graph;

import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.analysis.OnDemandCycleGroup;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.NodeType;
import com.hello2morrow.sonargraph.core.model.representation.ProgrammingElementDeltaManager;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public final class GraphRepresentation
extends NodeAndEdgeRepresentation {
    private final Map<NamedElement, RepresentationNode> m_namedElementToNode = new LinkedHashMap<NamedElement, RepresentationNode>();
    private final Map<NamedElement, OnDemandCycleGroup> m_mainPathNodesDelta = new LinkedHashMap<NamedElement, OnDemandCycleGroup>();
    private final Map<NamedElement, OnDemandCycleGroup> m_additionalNodesDelta = new LinkedHashMap<NamedElement, OnDemandCycleGroup>();
    private final Set<Pair<NamedElement, NamedElement>> m_discardedEdges = new LinkedHashSet<Pair<NamedElement, NamedElement>>();
    private final boolean m_levelized;
    private Predicate<ParserDependency> m_dependencyFilter;

    public GraphRepresentation(SoftwareSystem softwareSystem, INamedElementResolver resolver, String cycleForRepresentationFQName, Collection<NamedElement> originalInput, Set<CoreParserDependencyType> parserDependencyTypesForEdges, Predicate<ParserDependency> dependencyFilter, IDomainRoot.Domain domain, FocusMode mode, PresentationMode presentationMode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties, EndpointType endpointType, boolean levelized, int nameSuffix) {
        super(softwareSystem, resolver, cycleForRepresentationFQName, originalInput, parserDependencyTypesForEdges, domain, mode, presentationMode, properties, endpointType, nameSuffix);
        this.m_levelized = levelized;
        this.m_dependencyFilter = dependencyFilter;
    }

    public GraphRepresentation(SoftwareSystem softwareSystem, INamedElementResolver resolver, String cycleForRepresentationFqName, Collection<NamedElement> originalInput, Set<CoreParserDependencyType> parserDependencyTypesForEdges, Predicate<ParserDependency> dependencyFilter, IDomainRoot.Domain domain, ProgrammingElementDeltaManager deltaManager, FocusMode mode, PresentationMode presentationMode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties, EndpointType endpointType, boolean levelized, int nameSuffix) {
        this(softwareSystem, resolver, cycleForRepresentationFqName, originalInput, parserDependencyTypesForEdges, dependencyFilter, domain, mode, presentationMode, properties, endpointType, levelized, nameSuffix);
        this.setProgrammingElementDeltaManager(deltaManager);
    }

    public RepresentationNode createNode(NamedElement namedElement, NodeType nodeType) {
        assert (namedElement != null) : "Parameter 'element' of method 'createNode' must not be null";
        assert (nodeType != null) : "Parameter 'nodeType' of method 'createNode' must not be null";
        NamedElement original = namedElement.getOriginal();
        RepresentationNode node = new RepresentationNode(original);
        switch (nodeType) {
            case MAIN: {
                node.setIsMainPathNode(true);
                break;
            }
            case ADDITIONAL: {
                node.setIsAdditionalNode(true);
                break;
            }
            case ORIGINAL: {
                assert (false) : "NodeType not supported: " + (Object)((Object)nodeType);
                break;
            }
        }
        node.setIsVisible(true);
        RepresentationNode previous = this.m_namedElementToNode.put(original, node);
        assert (previous == null) : "'previous' of method 'createNode' must be null";
        this.checkForMappingsToProxies(original);
        return node;
    }

    @Override
    public void finishModification() {
        this.m_namedElementToNode.values().forEach(n2 -> n2.finishModification());
        super.finishModification();
    }

    @Override
    protected void removeNodeFromElement(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'removeNodeFromElement' must not be null";
        RepresentationNode node = this.m_namedElementToNode.remove(namedElement.getOriginal());
        assert (node != null) : "'node' of method 'removeFromAdditionalNodes' must not be null";
        node.removeEdges();
    }

    public void updateMainPathNode(NamedElement toReplace, OnDemandCycleGroup elementReplacing) {
        assert (toReplace != null) : "Parameter 'toReplace' of method 'enclosing_method' must not be null";
        assert (elementReplacing != null) : "Parameter 'elementReplacing' of method 'addMainPathDeltaEntry' must not be null";
        NamedElement original = toReplace.getOriginal();
        RepresentationNode node = this.m_namedElementToNode.remove(original);
        assert (node != null) : " 'node' of method 'addMainPathDeltaEntry' must not be null";
        this.m_mainPathNodesDelta.put(original, elementReplacing);
        this.m_discardedEdges.addAll(elementReplacing.getIncomingRealEdges());
        this.m_discardedEdges.addAll(elementReplacing.getOutgoingRealEdges());
        node.removeEdges();
    }

    public void updateAdditionalNode(NamedElement toReplace, OnDemandCycleGroup elementReplacing) {
        assert (toReplace != null) : "Parameter 'toReplace' of method 'addAdditionalNodesDeltaEntry' must not be null";
        assert (elementReplacing != null) : "Parameter 'elementReplacing' of method 'addAdditionalNodesDeltaEntry' must not be null";
        NamedElement original = toReplace.getOriginal();
        RepresentationNode node = this.m_namedElementToNode.remove(original);
        assert (node != null) : " 'node' of method 'addMainPathDeltaEntry' must not be null";
        this.m_additionalNodesDelta.put(original, elementReplacing);
        this.m_discardedEdges.addAll(elementReplacing.getIncomingRealEdges());
        this.m_discardedEdges.addAll(elementReplacing.getOutgoingRealEdges());
        node.removeEdges();
    }

    public Set<Pair<NamedElement, NamedElement>> getDiscardedEdges() {
        return Collections.unmodifiableSet(this.m_discardedEdges);
    }

    public boolean mainPathElementsContainsElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'mainPathElementsContainsElement' must not be null";
        return this.getMainNodes().contains(element);
    }

    public boolean additionalsContainsElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'additionalsContainsElement' must not be null";
        return this.getAdditionalNodes().contains(element);
    }

    public Collection<RepresentationNode> getNodes() {
        return Collections.unmodifiableCollection(this.m_namedElementToNode.values());
    }

    @Override
    public Collection<? extends RepresentationNode> getVisibleNodes() {
        return this.getNodes();
    }

    public Collection<NamedElement> getNamedElements() {
        return Collections.unmodifiableCollection(this.m_namedElementToNode.keySet());
    }

    @Override
    public RepresentationNode getNode(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getNode' must not be null";
        return this.m_namedElementToNode.get(namedElement.getOriginal());
    }

    @Override
    public Collection<NamedElement> getVisibleMainNodes() {
        LinkedHashSet<NamedElement> upToDateMainPathElements = new LinkedHashSet<NamedElement>();
        upToDateMainPathElements.addAll(this.getMainNodes());
        upToDateMainPathElements.addAll(this.m_mainPathNodesDelta.values());
        upToDateMainPathElements.removeAll(this.m_mainPathNodesDelta.keySet());
        return upToDateMainPathElements;
    }

    public Collection<NamedElement> getUpdatedAdditionals() {
        LinkedHashSet<NamedElement> updatedAdditionals = new LinkedHashSet<NamedElement>();
        updatedAdditionals.addAll(this.getAdditionalNodes());
        updatedAdditionals.addAll(this.m_additionalNodesDelta.values());
        updatedAdditionals.removeAll(this.m_additionalNodesDelta.keySet());
        return updatedAdditionals;
    }

    @Override
    public boolean isLevelized() {
        return this.m_levelized;
    }

    @Override
    public String toString() {
        StringBuilder nodesBuilder = new StringBuilder();
        StringBuilder dependenciesBuilder = new StringBuilder();
        for (RepresentationNode node : this.getNodes()) {
            String nodeType = "";
            if (node.isMainNode()) {
                nodeType = "(M)";
            } else if (node.isAdditionalNode()) {
                nodeType = "(A)";
            }
            nodesBuilder.append(String.valueOf(!node.getUnderlyingObject().equals(node.getElement()) ? "[Clone] " : "") + node.getPresentationName(true) + nodeType);
            nodesBuilder.append(StringUtility.LINE_SEPARATOR);
            for (RepresentationEdge edge : node.getOutgoingEdges()) {
                dependenciesBuilder.append(String.valueOf(((RepresentationNode)edge.getFrom()).getPresentationName(true)) + "->" + ((RepresentationNode)edge.getTo()).getPresentationName(true));
                dependenciesBuilder.append(StringUtility.LINE_SEPARATOR);
            }
        }
        return String.valueOf(nodesBuilder.toString()) + StringUtility.LINE_SEPARATOR + dependenciesBuilder.toString();
    }

    public void setDependencyFilter(Predicate<ParserDependency> dependencyFilter) {
        this.m_dependencyFilter = dependencyFilter;
    }

    @Override
    public Predicate<ParserDependency> getDependencyFilter() {
        return this.m_dependencyFilter;
    }
}

