/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.generic.programming;

import com.hello2morrow.sonargraph.core.model.element.GenericStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IField;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElementWithChildren;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import java.io.IOException;

public class GenericField
extends ProgrammingElementWithChildren
implements IField {
    private boolean m_isStatic = false;

    public GenericField(NamedElement parent) {
        super(parent);
    }

    public GenericField(IModelServiceProvider msp, NamedElement parent, String shortName, boolean isStatic, int lineNumber) {
        super(msp, parent, shortName, lineNumber);
        this.m_isStatic = isStatic;
    }

    @Override
    public IStructureItem getStructureItem() {
        return GenericStructureItem.PROGRAMMING_ELEMENT;
    }

    public boolean isPrivate() {
        return false;
    }

    public boolean isStatic() {
        return this.m_isStatic;
    }

    @Override
    public boolean isMember() {
        return true;
    }

    @Override
    public String getImageResourceName() {
        if (this.m_isStatic) {
            return "FieldStatic";
        }
        return this.isPrivate() ? "FieldPrivate" : "FieldPublic";
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeBoolean(this.m_isStatic);
    }

    @Override
    public String getFullyQualifiedNamePart() {
        String namePart = super.getFullyQualifiedNamePart();
        if (this.m_isStatic) {
            namePart = "<static>" + namePart;
        }
        return namePart;
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_isStatic = reader.readBoolean();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitGenericField(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitGenericField(GenericField var1);
    }
}

