/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.filter;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;

public final class WorkspaceFilter
extends Filter
implements IWorkspaceFilter {
    private Set<String> m_excludedFiles;
    private boolean m_isEnabled = true;

    public WorkspaceFilter(NamedElement parent) {
        super(parent);
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return true;
    }

    @Override
    public String getPresentationKind() {
        return "File Filter";
    }

    @Override
    public String getImageResourceName() {
        return "FileFilter";
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        assert (writer != null) : "Parameter 'writer' of method 'store' must not be null";
        super.store(writer);
        if (this.m_excludedFiles != null) {
            for (String next : this.m_excludedFiles) {
                writer.writeString(next);
            }
        }
        writer.writeString(null);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        assert (reader != null) : "Parameter 'reader' of method 'retrieve' must not be null";
        super.retrieve(reader);
        assert (this.m_excludedFiles == null) : "'m_excludedFiles' of method 'retrieve' must be null";
        this.m_excludedFiles = new TreeSet<String>();
        String nextEntry = null;
        while ((nextEntry = reader.readString()) != null) {
            this.m_excludedFiles.add(nextEntry);
        }
    }

    @Override
    public final String getShortName() {
        return "File Filter";
    }

    @Override
    public boolean invalidatesParserModel() {
        return this.m_isEnabled;
    }

    @Override
    public String getDescription() {
        return "Exclude files (matches against the 'Identifying Path' property)";
    }

    @Override
    public final void initialize() {
        if (this.m_isEnabled) {
            this.m_excludedFiles = new TreeSet<String>();
            super.initialize();
        }
    }

    @Override
    public final void clear() {
        if (this.m_isEnabled) {
            this.m_excludedFiles = null;
            super.clear();
        }
    }

    @Override
    public boolean includeFile(Supplier<String> supplier) {
        assert (supplier != null) : "Parameter 'supplier' of method 'add' must not be null";
        if (this.m_isEnabled) {
            assert (this.m_excludedFiles != null) : "'m_excludedFiles' of method 'add' must not be null";
            if (this.hasPatterns()) {
                String relPath = supplier.get();
                assert (relPath != null && relPath.length() > 0) : "'relPath' of method 'add' must not be empty";
                boolean include = super.include(relPath);
                if (!include) {
                    this.m_excludedFiles.add(relPath);
                }
                return include;
            }
        }
        return true;
    }

    public boolean isEnabled() {
        return this.m_isEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.m_isEnabled != enabled) {
            if (!enabled) {
                this.clear();
            }
            this.m_isEnabled = enabled;
        }
    }

    @Override
    public final String getInformation() {
        if (!this.m_isEnabled) {
            return "Disabled";
        }
        if (this.m_excludedFiles == null) {
            return "";
        }
        return "Excluded " + NumberUtility.format((Number)this.m_excludedFiles.size()) + " files(s)";
    }

    @Property
    public List<String> getExcludedFile() {
        if (this.m_isEnabled && this.m_excludedFiles != null && !this.m_excludedFiles.isEmpty()) {
            return new ArrayList<String>(this.m_excludedFiles);
        }
        return Collections.emptyList();
    }

    public int getNumberOfExcludedFiles() {
        return this.m_excludedFiles == null ? 0 : this.m_excludedFiles.size();
    }
}

