/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.filter;

import com.hello2morrow.foundation.utilities.CustomPattern;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.Pattern;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import java.io.IOException;

public abstract class WildcardPattern
extends Pattern {
    public static final String WILDCARD_INFO = "?=any character, *=any sequence between dots or slashes, **=any sequence";
    private CustomPattern m_pattern;

    public static String isValid(String wildchardPattern) {
        assert (wildchardPattern != null) : "Parameter 'wildchardPattern' of method 'isValid' must not be null";
        try {
            CustomPattern.compileWildcardPattern((String)wildchardPattern, (boolean)false);
            return null;
        }
        catch (IllegalArgumentException e2) {
            return e2.getLocalizedMessage();
        }
    }

    public WildcardPattern(NamedElement parent) {
        super(parent);
    }

    public WildcardPattern(NamedElement parent, String name) {
        super(parent, name);
        this.m_pattern = CustomPattern.compileWildcardPattern((String)this.getName(), (boolean)false);
    }

    @Override
    public final void setName(String name) {
        super.setName(name);
        this.m_pattern = CustomPattern.compileWildcardPattern((String)this.getName(), (boolean)false);
    }

    @Override
    public final void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_pattern = CustomPattern.compileWildcardPattern((String)this.getName(), (boolean)false);
    }

    @Override
    public final boolean matches(String name) {
        assert (name != null) : "Parameter 'name' of method 'matches' must not be null";
        assert (this.m_pattern != null) : "Parameter 'm_pattern' of method 'matches' must not be null";
        boolean matches = this.m_pattern.matches((CharSequence)name);
        if (matches) {
            this.incrementNumberOfMatchedElements();
        }
        return matches;
    }
}

