/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import java.util.List;

public abstract class TargetParentOperation
extends ArchitecturalViewOperation {
    private final String m_targetParent;
    private final int m_targetPos;

    protected static final String getInfo(String kind, List<String> list) {
        assert (kind != null && kind.length() > 0) : "Parameter 'kind' of method 'get' must not be empty";
        assert (list != null && !list.isEmpty()) : "Parameter 'list' of method 'get' must not be empty";
        StringBuilder builder = new StringBuilder();
        builder.append(list.size());
        builder.append(" ").append(kind).append("(s):");
        list.forEach(e2 -> {
            StringBuilder stringBuilder2 = builder.append("\n - ").append((String)e2);
        });
        return builder.toString();
    }

    public TargetParentOperation(NamedElement parent, PresentationMode presentationMode, String targetParent, int targetPos) {
        super(parent, presentationMode);
        assert (targetParent != null) : "Parameter 'targetParent' of method 'TargetParentOperation' must not be null";
        this.m_targetParent = targetParent;
        this.m_targetPos = targetPos;
    }

    protected TargetParentOperation(NamedElement parent, TargetParentOperation copyOf) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'TargetParentOperation' must not be null";
        this.m_targetParent = copyOf.m_targetParent;
        this.m_targetPos = copyOf.m_targetPos;
    }

    public final String getTargetParent() {
        return this.m_targetParent;
    }

    protected final String getTargetParentPresentationName() {
        if (this.m_targetParent.isEmpty()) {
            return this.m_targetParent;
        }
        return this.m_targetParent.replaceAll(ArtifactNode.RELATIVE_PATH_PREFIX_ESCAPED, "");
    }

    public final int getTargetPos() {
        return this.m_targetPos;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("\n");
        builder.append("Target parent: ").append(this.m_targetParent).append("\n");
        builder.append("Target pos: ").append(this.m_targetPos);
        return builder.toString();
    }
}

