/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.collections.HashBag;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RecursiveNode
extends AssignableNode {
    private final ArrayList<NamedElement> m_underlyingElements = new ArrayList(2);

    public RecursiveNode(ArchitecturalViewElement parent, PresentationMode presentationMode, boolean isReadOnly, IRecursiveElement recursiveElement) {
        super(parent, presentationMode, isReadOnly, (Collection<ProgrammingElement>)new HashBag(100));
        assert (recursiveElement != null) : "Parameter 'recursiveElement' of method 'RecursiveNode' must not be null";
        this.m_underlyingElements.add(recursiveElement.getNamedElement());
    }

    public RecursiveNode(ArchitecturalViewElement parent, RecursiveNode copyOf) {
        super(parent, copyOf, (Collection<ProgrammingElement>)new HashBag(100));
        assert (copyOf != null) : "Parameter 'copyOf' of method 'RecursiveNode' must not be null";
        this.m_underlyingElements.addAll(copyOf.m_underlyingElements);
    }

    public final void addUnderlyingElement(IRecursiveElement recursiveElement) {
        assert (recursiveElement != null) : "Parameter 'recursiveElement' of method 'addUnderlyingElement' must not be null";
        NamedElement recursiveElementAsNamedElement = recursiveElement.getNamedElement();
        assert (!this.m_underlyingElements.contains(recursiveElementAsNamedElement)) : "Already added: " + recursiveElement;
        this.m_underlyingElements.add(recursiveElementAsNamedElement);
    }

    @Override
    public final String getImageResourceName() {
        NamedElement underlying = this.getFirstUnderlyingElement();
        assert (underlying != null && underlying instanceof IRecursiveElement) : "Unexpected class in method 'getImageResourceName': " + underlying;
        return this.isPart() ? ((IRecursiveElement)((Object)underlying)).getImageResourcePart() : ((IRecursiveElement)((Object)underlying)).getImageResource();
    }

    @Override
    public final boolean isRecursive() {
        return true;
    }

    @Override
    public final boolean supportsCopy() {
        return true;
    }

    @Override
    public RecursiveNode copy(ArchitecturalViewElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copyOf' must not be null";
        return new RecursiveNode(parent, this);
    }

    @Override
    public final String getRawPresentationName(boolean shortName) {
        return this.getFirstUnderlyingElement().getRawPresentationName(shortName);
    }

    @Override
    public final String getShortName() {
        if (!this.isSuppressed()) {
            PresentationMode presentationMode = this.getPresentationMode();
            switch (presentationMode) {
                case MIXED: {
                    RecursiveNode nonSkippedParent = null;
                    RecursiveNode nextParent = this.getParent(RecursiveNode.class, ParentMode.ONLY_DIRECT_PARENT);
                    while (nextParent != null) {
                        if (!nextParent.isSuppressed()) {
                            nonSkippedParent = nextParent;
                            break;
                        }
                        nextParent = nextParent.getParent(RecursiveNode.class, ParentMode.ONLY_DIRECT_PARENT);
                    }
                    if (nonSkippedParent != null) {
                        String nonSkippedParentName = nonSkippedParent.getFirstUnderlyingElement().getName();
                        assert (nonSkippedParentName != null && nonSkippedParentName.length() > 0) : "Parameter 'nonSkippedParentName' of method 'getShortName' must not be empty";
                        return this.getFirstUnderlyingElement().getName().substring(nonSkippedParentName.length() + 1);
                    }
                    return this.getFirstUnderlyingElement().getName();
                }
                case FLAT: {
                    return this.getFirstUnderlyingElement().getName();
                }
                case HIERARCHICAL: {
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    assert (false) : "Unhandled presentation mode: " + (Object)((Object)presentationMode);
                    break;
                }
            }
        }
        return super.getShortName();
    }

    @Override
    public final NamedElement getFirstUnderlyingElement() {
        return this.m_underlyingElements.get(0);
    }

    @Override
    public final List<NamedElement> getUnderlyingElements() {
        return Collections.unmodifiableList(this.m_underlyingElements);
    }

    @Override
    public final Collection<ProgrammingElement> getRelevantProgrammingElements(boolean recursively) {
        if (recursively) {
            return super.getProgrammingElements();
        }
        List<RecursiveNode> recursiveNodeChildren = this.getChildren(RecursiveNode.class);
        if (recursiveNodeChildren.isEmpty()) {
            return super.getProgrammingElements();
        }
        Collection<ProgrammingElement> programmingElements = super.getProgrammingElements();
        HashBag flat = new HashBag(programmingElements.size());
        flat.addAll(programmingElements);
        recursiveNodeChildren.forEach(r2 -> {
            boolean bl2 = flat.removeAll(r2.getProgrammingElements());
        });
        return flat;
    }

    @Override
    public final void finishModification() {
        this.m_underlyingElements.trimToSize();
        Collection<ProgrammingElement> collection = this.getProgrammingElementsCollection();
        assert (collection != null && collection instanceof HashBag) : "Unexpected class in method 'finishModification': " + collection;
        ((HashBag)collection).trimToSize();
        super.finishModification();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitRecursiveNode(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitRecursiveNode(RecursiveNode var1);
    }
}

